/*
 * Decompiled with CFR 0.152.
 */
package org.drools.asm.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.asm.AnnotationVisitor;
import org.drools.asm.ClassVisitor;
import org.drools.asm.ClassWriter;
import org.drools.asm.FieldVisitor;
import org.drools.asm.Label;
import org.drools.asm.MethodVisitor;
import org.drools.asm.Opcodes;
import org.drools.asm.Type;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ASMContentHandler
extends DefaultHandler
implements Opcodes {
    private final List stack = new ArrayList();
    private String match = "";
    protected boolean computeMax;
    protected OutputStream os;
    protected ClassWriter cw;
    protected Map labels;
    private static final String BASE = "class";
    private final RuleSet RULES = new RuleSet();
    static final Map OPCODES = new HashMap();
    static /* synthetic */ Class class$org$drools$asm$Type;

    public ASMContentHandler(OutputStream outputStream, boolean bl) {
        this.RULES.add(BASE, new ClassRule());
        this.RULES.add("class/interfaces/interface", new InterfaceRule());
        this.RULES.add("class/interfaces", new InterfacesRule());
        this.RULES.add("class/outerclass", new OuterClassRule());
        this.RULES.add("class/innerclass", new InnerClassRule());
        this.RULES.add("class/source", new SourceRule());
        this.RULES.add("class/field", new FieldRule());
        this.RULES.add("class/method", new MethodRule());
        this.RULES.add("class/method/exceptions/exception", new ExceptionRule());
        this.RULES.add("class/method/exceptions", new ExceptionsRule());
        this.RULES.add("class/method/annotationDefault", new AnnotationDefaultRule());
        this.RULES.add("class/method/code/*", new OpcodesRule());
        this.RULES.add("class/method/code/TABLESWITCH", new TableSwitchRule());
        this.RULES.add("class/method/code/TABLESWITCH/label", new TableSwitchLabelRule());
        this.RULES.add("class/method/code/LOOKUPSWITCH", new LookupSwitchRule());
        this.RULES.add("class/method/code/LOOKUPSWITCH/label", new LookupSwitchLabelRule());
        this.RULES.add("class/method/code/Label", new LabelRule());
        this.RULES.add("class/method/code/TryCatch", new TryCatchRule());
        this.RULES.add("class/method/code/LineNumber", new LineNumberRule());
        this.RULES.add("class/method/code/LocalVar", new LocalVarRule());
        this.RULES.add("class/method/code/Max", new MaxRule());
        this.RULES.add("*/annotation", new AnnotationRule());
        this.RULES.add("*/parameterAnnotation", new AnnotationParameterRule());
        this.RULES.add("*/annotationValue", new AnnotationValueRule());
        this.RULES.add("*/annotationValueAnnotation", new AnnotationValueAnnotationRule());
        this.RULES.add("*/annotationValueEnum", new AnnotationValueEnumRule());
        this.RULES.add("*/annotationValueArray", new AnnotationValueArrayRule());
        this.os = outputStream;
        this.computeMax = bl;
    }

    public byte[] toByteArray() {
        return this.cw == null ? null : this.cw.toByteArray();
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.length() < 1) {
            string4 = string3;
        }
        StringBuffer stringBuffer = new StringBuffer(this.match);
        if (this.match.length() > 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string4);
        this.match = stringBuffer.toString();
        Rule rule = (Rule)this.RULES.match(this.match);
        if (rule != null) {
            rule.begin(string4, attributes);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        int n;
        Rule rule;
        String string4 = string2;
        if (string4 == null || string4.length() < 1) {
            string4 = string3;
        }
        if ((rule = (Rule)this.RULES.match(this.match)) != null) {
            rule.end(string4);
        }
        this.match = (n = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, n) : "";
    }

    public final void endDocument() throws SAXException {
        try {
            this.os.write(this.cw.toByteArray());
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.toString(), iOException);
        }
    }

    final Object peek() {
        return this.stack.size() == 0 ? null : this.stack.get(this.stack.size() - 1);
    }

    final Object peek(int n) {
        return this.stack.size() < n + 1 ? null : this.stack.get(n);
    }

    final Object pop() {
        return this.stack.size() == 0 ? null : this.stack.remove(this.stack.size() - 1);
    }

    final void push(Object object) {
        this.stack.add(object);
    }

    static {
        OPCODES.put("NOP", new Opcode(0, 0));
        OPCODES.put("ACONST_NULL", new Opcode(1, 0));
        OPCODES.put("ICONST_M1", new Opcode(2, 0));
        OPCODES.put("ICONST_0", new Opcode(3, 0));
        OPCODES.put("ICONST_1", new Opcode(4, 0));
        OPCODES.put("ICONST_2", new Opcode(5, 0));
        OPCODES.put("ICONST_3", new Opcode(6, 0));
        OPCODES.put("ICONST_4", new Opcode(7, 0));
        OPCODES.put("ICONST_5", new Opcode(8, 0));
        OPCODES.put("LCONST_0", new Opcode(9, 0));
        OPCODES.put("LCONST_1", new Opcode(10, 0));
        OPCODES.put("FCONST_0", new Opcode(11, 0));
        OPCODES.put("FCONST_1", new Opcode(12, 0));
        OPCODES.put("FCONST_2", new Opcode(13, 0));
        OPCODES.put("DCONST_0", new Opcode(14, 0));
        OPCODES.put("DCONST_1", new Opcode(15, 0));
        OPCODES.put("BIPUSH", new Opcode(16, 1));
        OPCODES.put("SIPUSH", new Opcode(17, 1));
        OPCODES.put("LDC", new Opcode(18, 7));
        OPCODES.put("ILOAD", new Opcode(21, 2));
        OPCODES.put("LLOAD", new Opcode(22, 2));
        OPCODES.put("FLOAD", new Opcode(23, 2));
        OPCODES.put("DLOAD", new Opcode(24, 2));
        OPCODES.put("ALOAD", new Opcode(25, 2));
        OPCODES.put("IALOAD", new Opcode(46, 0));
        OPCODES.put("LALOAD", new Opcode(47, 0));
        OPCODES.put("FALOAD", new Opcode(48, 0));
        OPCODES.put("DALOAD", new Opcode(49, 0));
        OPCODES.put("AALOAD", new Opcode(50, 0));
        OPCODES.put("BALOAD", new Opcode(51, 0));
        OPCODES.put("CALOAD", new Opcode(52, 0));
        OPCODES.put("SALOAD", new Opcode(53, 0));
        OPCODES.put("ISTORE", new Opcode(54, 2));
        OPCODES.put("LSTORE", new Opcode(55, 2));
        OPCODES.put("FSTORE", new Opcode(56, 2));
        OPCODES.put("DSTORE", new Opcode(57, 2));
        OPCODES.put("ASTORE", new Opcode(58, 2));
        OPCODES.put("IASTORE", new Opcode(79, 0));
        OPCODES.put("LASTORE", new Opcode(80, 0));
        OPCODES.put("FASTORE", new Opcode(81, 0));
        OPCODES.put("DASTORE", new Opcode(82, 0));
        OPCODES.put("AASTORE", new Opcode(83, 0));
        OPCODES.put("BASTORE", new Opcode(84, 0));
        OPCODES.put("CASTORE", new Opcode(85, 0));
        OPCODES.put("SASTORE", new Opcode(86, 0));
        OPCODES.put("POP", new Opcode(87, 0));
        OPCODES.put("POP2", new Opcode(88, 0));
        OPCODES.put("DUP", new Opcode(89, 0));
        OPCODES.put("DUP_X1", new Opcode(90, 0));
        OPCODES.put("DUP_X2", new Opcode(91, 0));
        OPCODES.put("DUP2", new Opcode(92, 0));
        OPCODES.put("DUP2_X1", new Opcode(93, 0));
        OPCODES.put("DUP2_X2", new Opcode(94, 0));
        OPCODES.put("SWAP", new Opcode(95, 0));
        OPCODES.put("IADD", new Opcode(96, 0));
        OPCODES.put("LADD", new Opcode(97, 0));
        OPCODES.put("FADD", new Opcode(98, 0));
        OPCODES.put("DADD", new Opcode(99, 0));
        OPCODES.put("ISUB", new Opcode(100, 0));
        OPCODES.put("LSUB", new Opcode(101, 0));
        OPCODES.put("FSUB", new Opcode(102, 0));
        OPCODES.put("DSUB", new Opcode(103, 0));
        OPCODES.put("IMUL", new Opcode(104, 0));
        OPCODES.put("LMUL", new Opcode(105, 0));
        OPCODES.put("FMUL", new Opcode(106, 0));
        OPCODES.put("DMUL", new Opcode(107, 0));
        OPCODES.put("IDIV", new Opcode(108, 0));
        OPCODES.put("LDIV", new Opcode(109, 0));
        OPCODES.put("FDIV", new Opcode(110, 0));
        OPCODES.put("DDIV", new Opcode(111, 0));
        OPCODES.put("IREM", new Opcode(112, 0));
        OPCODES.put("LREM", new Opcode(113, 0));
        OPCODES.put("FREM", new Opcode(114, 0));
        OPCODES.put("DREM", new Opcode(115, 0));
        OPCODES.put("INEG", new Opcode(116, 0));
        OPCODES.put("LNEG", new Opcode(117, 0));
        OPCODES.put("FNEG", new Opcode(118, 0));
        OPCODES.put("DNEG", new Opcode(119, 0));
        OPCODES.put("ISHL", new Opcode(120, 0));
        OPCODES.put("LSHL", new Opcode(121, 0));
        OPCODES.put("ISHR", new Opcode(122, 0));
        OPCODES.put("LSHR", new Opcode(123, 0));
        OPCODES.put("IUSHR", new Opcode(124, 0));
        OPCODES.put("LUSHR", new Opcode(125, 0));
        OPCODES.put("IAND", new Opcode(126, 0));
        OPCODES.put("LAND", new Opcode(127, 0));
        OPCODES.put("IOR", new Opcode(128, 0));
        OPCODES.put("LOR", new Opcode(129, 0));
        OPCODES.put("IXOR", new Opcode(130, 0));
        OPCODES.put("LXOR", new Opcode(131, 0));
        OPCODES.put("IINC", new Opcode(132, 8));
        OPCODES.put("I2L", new Opcode(133, 0));
        OPCODES.put("I2F", new Opcode(134, 0));
        OPCODES.put("I2D", new Opcode(135, 0));
        OPCODES.put("L2I", new Opcode(136, 0));
        OPCODES.put("L2F", new Opcode(137, 0));
        OPCODES.put("L2D", new Opcode(138, 0));
        OPCODES.put("F2I", new Opcode(139, 0));
        OPCODES.put("F2L", new Opcode(140, 0));
        OPCODES.put("F2D", new Opcode(141, 0));
        OPCODES.put("D2I", new Opcode(142, 0));
        OPCODES.put("D2L", new Opcode(143, 0));
        OPCODES.put("D2F", new Opcode(144, 0));
        OPCODES.put("I2B", new Opcode(145, 0));
        OPCODES.put("I2C", new Opcode(146, 0));
        OPCODES.put("I2S", new Opcode(147, 0));
        OPCODES.put("LCMP", new Opcode(148, 0));
        OPCODES.put("FCMPL", new Opcode(149, 0));
        OPCODES.put("FCMPG", new Opcode(150, 0));
        OPCODES.put("DCMPL", new Opcode(151, 0));
        OPCODES.put("DCMPG", new Opcode(152, 0));
        OPCODES.put("IFEQ", new Opcode(153, 6));
        OPCODES.put("IFNE", new Opcode(154, 6));
        OPCODES.put("IFLT", new Opcode(155, 6));
        OPCODES.put("IFGE", new Opcode(156, 6));
        OPCODES.put("IFGT", new Opcode(157, 6));
        OPCODES.put("IFLE", new Opcode(158, 6));
        OPCODES.put("IF_ICMPEQ", new Opcode(159, 6));
        OPCODES.put("IF_ICMPNE", new Opcode(160, 6));
        OPCODES.put("IF_ICMPLT", new Opcode(161, 6));
        OPCODES.put("IF_ICMPGE", new Opcode(162, 6));
        OPCODES.put("IF_ICMPGT", new Opcode(163, 6));
        OPCODES.put("IF_ICMPLE", new Opcode(164, 6));
        OPCODES.put("IF_ACMPEQ", new Opcode(165, 6));
        OPCODES.put("IF_ACMPNE", new Opcode(166, 6));
        OPCODES.put("GOTO", new Opcode(167, 6));
        OPCODES.put("JSR", new Opcode(168, 6));
        OPCODES.put("RET", new Opcode(169, 2));
        OPCODES.put("IRETURN", new Opcode(172, 0));
        OPCODES.put("LRETURN", new Opcode(173, 0));
        OPCODES.put("FRETURN", new Opcode(174, 0));
        OPCODES.put("DRETURN", new Opcode(175, 0));
        OPCODES.put("ARETURN", new Opcode(176, 0));
        OPCODES.put("RETURN", new Opcode(177, 0));
        OPCODES.put("GETSTATIC", new Opcode(178, 4));
        OPCODES.put("PUTSTATIC", new Opcode(179, 4));
        OPCODES.put("GETFIELD", new Opcode(180, 4));
        OPCODES.put("PUTFIELD", new Opcode(181, 4));
        OPCODES.put("INVOKEVIRTUAL", new Opcode(182, 5));
        OPCODES.put("INVOKESPECIAL", new Opcode(183, 5));
        OPCODES.put("INVOKESTATIC", new Opcode(184, 5));
        OPCODES.put("INVOKEINTERFACE", new Opcode(185, 5));
        OPCODES.put("NEW", new Opcode(187, 3));
        OPCODES.put("NEWARRAY", new Opcode(188, 1));
        OPCODES.put("ANEWARRAY", new Opcode(189, 3));
        OPCODES.put("ARRAYLENGTH", new Opcode(190, 0));
        OPCODES.put("ATHROW", new Opcode(191, 0));
        OPCODES.put("CHECKCAST", new Opcode(192, 3));
        OPCODES.put("INSTANCEOF", new Opcode(193, 3));
        OPCODES.put("MONITORENTER", new Opcode(194, 0));
        OPCODES.put("MONITOREXIT", new Opcode(195, 0));
        OPCODES.put("MULTIANEWARRAY", new Opcode(197, 9));
        OPCODES.put("IFNULL", new Opcode(198, 6));
        OPCODES.put("IFNONNULL", new Opcode(199, 6));
    }

    private static final class Opcode {
        public int opcode;
        public int type;

        public Opcode(int n, int n2) {
            this.opcode = n;
            this.type = n2;
        }
    }

    private final class AnnotationDefaultRule
    extends Rule {
        private AnnotationDefaultRule() {
        }

        public void begin(String string, Attributes attributes) {
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitAnnotationDefault());
        }

        public void end(String string) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class AnnotationValueArrayRule
    extends Rule {
        private AnnotationValueArrayRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("name");
            ASMContentHandler.this.push(((AnnotationVisitor)ASMContentHandler.this.peek()).visitArray(string2));
        }

        public void end(String string) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class AnnotationValueAnnotationRule
    extends Rule {
        private AnnotationValueAnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("desc");
            ASMContentHandler.this.push(((AnnotationVisitor)ASMContentHandler.this.peek()).visitAnnotation(string2, string3));
        }

        public void end(String string) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class AnnotationValueEnumRule
    extends Rule {
        private AnnotationValueEnumRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("desc");
            String string4 = attributes.getValue("value");
            ((AnnotationVisitor)ASMContentHandler.this.peek()).visitEnum(string2, string3, string4);
        }
    }

    private final class AnnotationValueRule
    extends Rule {
        private AnnotationValueRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("desc");
            String string4 = attributes.getValue("value");
            ((AnnotationVisitor)ASMContentHandler.this.peek()).visit(string2, this.getValue(string3, string4));
        }
    }

    private final class AnnotationParameterRule
    extends Rule {
        private AnnotationParameterRule() {
        }

        public void begin(String string, Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("parameter"));
            String string2 = attributes.getValue("desc");
            boolean bl = Boolean.valueOf(attributes.getValue("visible"));
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitParameterAnnotation(n, string2, bl));
        }

        public void end(String string) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class AnnotationRule
    extends Rule {
        private AnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("desc");
            boolean bl = Boolean.valueOf(attributes.getValue("visible"));
            Object object = ASMContentHandler.this.peek();
            if (object instanceof ClassVisitor) {
                ASMContentHandler.this.push(((ClassVisitor)object).visitAnnotation(string2, bl));
            } else if (object instanceof FieldVisitor) {
                ASMContentHandler.this.push(((FieldVisitor)object).visitAnnotation(string2, bl));
            } else if (object instanceof MethodVisitor) {
                ASMContentHandler.this.push(((MethodVisitor)object).visitAnnotation(string2, bl));
            }
        }

        public void end(String string) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class MaxRule
    extends Rule {
        private MaxRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("maxStack"));
            int n2 = Integer.parseInt(attributes.getValue("maxLocals"));
            this.getCodeVisitor().visitMaxs(n, n2);
        }
    }

    private final class OpcodesRule
    extends Rule {
        private OpcodesRule() {
        }

        public final void begin(String string, Attributes attributes) {
            Opcode opcode = (Opcode)OPCODES.get(string);
            if (opcode == null) {
                return;
            }
            switch (opcode.type) {
                case 0: {
                    this.getCodeVisitor().visitInsn(opcode.opcode);
                    break;
                }
                case 4: {
                    this.getCodeVisitor().visitFieldInsn(opcode.opcode, attributes.getValue("owner"), attributes.getValue("name"), attributes.getValue("desc"));
                    break;
                }
                case 1: {
                    this.getCodeVisitor().visitIntInsn(opcode.opcode, Integer.parseInt(attributes.getValue("value")));
                    break;
                }
                case 6: {
                    this.getCodeVisitor().visitJumpInsn(opcode.opcode, this.getLabel(attributes.getValue("label")));
                    break;
                }
                case 5: {
                    this.getCodeVisitor().visitMethodInsn(opcode.opcode, attributes.getValue("owner"), attributes.getValue("name"), attributes.getValue("desc"));
                    break;
                }
                case 3: {
                    this.getCodeVisitor().visitTypeInsn(opcode.opcode, attributes.getValue("desc"));
                    break;
                }
                case 2: {
                    this.getCodeVisitor().visitVarInsn(opcode.opcode, Integer.parseInt(attributes.getValue("var")));
                    break;
                }
                case 8: {
                    this.getCodeVisitor().visitIincInsn(Integer.parseInt(attributes.getValue("var")), Integer.parseInt(attributes.getValue("inc")));
                    break;
                }
                case 7: {
                    this.getCodeVisitor().visitLdcInsn(this.getValue(attributes.getValue("desc"), attributes.getValue("cst")));
                    break;
                }
                case 9: {
                    this.getCodeVisitor().visitMultiANewArrayInsn(attributes.getValue("desc"), Integer.parseInt(attributes.getValue("dims")));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid element: " + string + " at " + ASMContentHandler.this.match);
                }
            }
        }
    }

    private final class LocalVarRule
    extends Rule {
        private LocalVarRule() {
        }

        public final void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("desc");
            String string4 = attributes.getValue("signature");
            Label label = this.getLabel(attributes.getValue("start"));
            Label label2 = this.getLabel(attributes.getValue("end"));
            int n = Integer.parseInt(attributes.getValue("var"));
            this.getCodeVisitor().visitLocalVariable(string2, string3, string4, label, label2, n);
        }
    }

    private final class LineNumberRule
    extends Rule {
        private LineNumberRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("line"));
            Label label = this.getLabel(attributes.getValue("start"));
            this.getCodeVisitor().visitLineNumber(n, label);
        }
    }

    private final class TryCatchRule
    extends Rule {
        private TryCatchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            Label label = this.getLabel(attributes.getValue("start"));
            Label label2 = this.getLabel(attributes.getValue("end"));
            Label label3 = this.getLabel(attributes.getValue("handler"));
            String string2 = attributes.getValue("type");
            this.getCodeVisitor().visitTryCatchBlock(label, label2, label3, string2);
        }
    }

    private final class LabelRule
    extends Rule {
        private LabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            this.getCodeVisitor().visitLabel(this.getLabel(attributes.getValue("name")));
        }
    }

    private final class LookupSwitchLabelRule
    extends Rule {
        private LookupSwitchLabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            Map map = (Map)ASMContentHandler.this.peek();
            ((List)map.get("labels")).add(this.getLabel(attributes.getValue("name")));
            ((List)map.get("keys")).add(attributes.getValue("key"));
        }
    }

    private final class LookupSwitchRule
    extends Rule {
        private LookupSwitchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("dflt", attributes.getValue("dflt"));
            hashMap.put("labels", new ArrayList());
            hashMap.put("keys", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            Label label = this.getLabel(map.get("dflt"));
            List list = (List)map.get("keys");
            List list2 = (List)map.get("labels");
            Label[] labelArray = list2.toArray(new Label[list2.size()]);
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.parseInt((String)list.get(i));
            }
            this.getCodeVisitor().visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    private final class TableSwitchLabelRule
    extends Rule {
        private TableSwitchLabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((List)((Map)ASMContentHandler.this.peek()).get("labels")).add(this.getLabel(attributes.getValue("name")));
        }
    }

    private class TableSwitchRule
    extends Rule {
        private TableSwitchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("min", attributes.getValue("min"));
            hashMap.put("max", attributes.getValue("max"));
            hashMap.put("dflt", attributes.getValue("dflt"));
            hashMap.put("labels", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            int n = Integer.parseInt((String)map.get("min"));
            int n2 = Integer.parseInt((String)map.get("max"));
            Label label = this.getLabel(map.get("dflt"));
            List list = (List)map.get("labels");
            Label[] labelArray = list.toArray(new Label[list.size()]);
            this.getCodeVisitor().visitTableSwitchInsn(n, n2, label, labelArray);
        }
    }

    private final class ExceptionsRule
    extends Rule {
        private ExceptionsRule() {
        }

        public final void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            int n = this.getAccess((String)map.get("access"));
            String string2 = (String)map.get("name");
            String string3 = (String)map.get("desc");
            String string4 = (String)map.get("signature");
            List list = (List)map.get("exceptions");
            String[] stringArray = list.toArray(new String[list.size()]);
            ASMContentHandler.this.push(ASMContentHandler.this.cw.visitMethod(n, string2, string3, string4, stringArray));
        }
    }

    private final class ExceptionRule
    extends Rule {
        private ExceptionRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((List)((Map)ASMContentHandler.this.peek()).get("exceptions")).add(attributes.getValue("name"));
        }
    }

    private final class MethodRule
    extends Rule {
        private MethodRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ASMContentHandler.this.labels = new HashMap();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("access", attributes.getValue("access"));
            hashMap.put("name", attributes.getValue("name"));
            hashMap.put("desc", attributes.getValue("desc"));
            hashMap.put("signature", attributes.getValue("signature"));
            hashMap.put("exceptions", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            ((MethodVisitor)ASMContentHandler.this.pop()).visitEnd();
            ASMContentHandler.this.labels = null;
        }
    }

    private final class FieldRule
    extends Rule {
        private FieldRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = this.getAccess(attributes.getValue("access"));
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("signature");
            String string4 = attributes.getValue("desc");
            Object object = this.getValue(string4, attributes.getValue("value"));
            ASMContentHandler.this.push(ASMContentHandler.this.cw.visitField(n, string2, string4, string3, object));
        }

        public void end(String string) {
            ((FieldVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class InnerClassRule
    extends Rule {
        private InnerClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = this.getAccess(attributes.getValue("access"));
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("outerName");
            String string4 = attributes.getValue("innerName");
            ASMContentHandler.this.cw.visitInnerClass(string2, string3, string4, n);
        }
    }

    private final class OuterClassRule
    extends Rule {
        private OuterClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("owner");
            String string3 = attributes.getValue("name");
            String string4 = attributes.getValue("desc");
            ASMContentHandler.this.cw.visitOuterClass(string2, string3, string4);
        }
    }

    private final class InterfacesRule
    extends Rule {
        private InterfacesRule() {
        }

        public final void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            int n = (Integer)map.get("version");
            int n2 = this.getAccess((String)map.get("access"));
            String string2 = (String)map.get("name");
            String string3 = (String)map.get("signature");
            String string4 = (String)map.get("parent");
            List list = (List)map.get("interfaces");
            String[] stringArray = list.toArray(new String[list.size()]);
            ASMContentHandler.this.cw.visit(n, n2, string2, string3, string4, stringArray);
            ASMContentHandler.this.push(ASMContentHandler.this.cw);
        }
    }

    private final class InterfaceRule
    extends Rule {
        private InterfaceRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((List)((Map)ASMContentHandler.this.peek()).get("interfaces")).add(attributes.getValue("name"));
        }
    }

    private final class SourceRule
    extends Rule {
        private SourceRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("file");
            String string3 = attributes.getValue("debug");
            ASMContentHandler.this.cw.visitSource(string2, string3);
        }
    }

    private final class ClassRule
    extends Rule {
        private ClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("major"));
            int n2 = Integer.parseInt(attributes.getValue("minor"));
            ASMContentHandler.this.cw = new ClassWriter(ASMContentHandler.this.computeMax);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("version", new Integer(n2 << 16 | n));
            hashMap.put("access", attributes.getValue("access"));
            hashMap.put("name", attributes.getValue("name"));
            hashMap.put("parent", attributes.getValue("parent"));
            hashMap.put("source", attributes.getValue("source"));
            hashMap.put("signature", attributes.getValue("signature"));
            hashMap.put("interfaces", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }
    }

    protected abstract class Rule {
        protected Rule() {
        }

        public void begin(String string, Attributes attributes) {
        }

        public void end(String string) {
        }

        protected final Object getValue(String string, String string2) {
            Object object = null;
            if (string2 != null) {
                if (string.equals("Ljava/lang/String;")) {
                    object = this.decode(string2);
                } else if ("Ljava/lang/Integer;".equals(string) || "I".equals(string) || "S".equals(string) || "B".equals(string) || "C".equals(string) || string.equals("Z")) {
                    object = new Integer(string2);
                } else if ("Ljava/lang/Short;".equals(string)) {
                    object = new Short(string2);
                } else if ("Ljava/lang/Byte;".equals(string)) {
                    object = new Byte(string2);
                } else if ("Ljava/lang/Character;".equals(string)) {
                    object = new Character(this.decode(string2).charAt(0));
                } else if ("Ljava/lang/Boolean;".equals(string)) {
                    object = Boolean.valueOf(string2);
                } else if ("Ljava/lang/Long;".equals(string) || string.equals("J")) {
                    object = new Long(string2);
                } else if ("Ljava/lang/Float;".equals(string) || string.equals("F")) {
                    object = new Float(string2);
                } else if ("Ljava/lang/Double;".equals(string) || string.equals("D")) {
                    object = new Double(string2);
                } else if (Type.getDescriptor(class$org$drools$asm$Type == null ? (class$org$drools$asm$Type = ASMContentHandler.class$("org.drools.asm.Type")) : class$org$drools$asm$Type).equals(string)) {
                    object = Type.getType(string2);
                } else {
                    throw new RuntimeException("Invalid value:" + string2 + " desc:" + string + " ctx:" + this);
                }
            }
            return object;
        }

        private final String decode(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            try {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\\') {
                        if ((c = string.charAt(++i)) == '\\') {
                            stringBuffer.append('\\');
                            continue;
                        }
                        stringBuffer.append((char)Integer.parseInt(string.substring(++i, i + 4), 16));
                        i += 3;
                        continue;
                    }
                    stringBuffer.append(c);
                }
            }
            catch (RuntimeException runtimeException) {
                System.err.println(string + "\n" + runtimeException.toString());
                runtimeException.printStackTrace();
                throw runtimeException;
            }
            return stringBuffer.toString();
        }

        protected final Label getLabel(Object object) {
            Label label = (Label)ASMContentHandler.this.labels.get(object);
            if (label == null) {
                label = new Label();
                ASMContentHandler.this.labels.put(object, label);
            }
            return label;
        }

        protected final MethodVisitor getCodeVisitor() {
            return (MethodVisitor)ASMContentHandler.this.peek();
        }

        protected final int getAccess(String string) {
            int n = 0;
            if (string.indexOf("public") != -1) {
                n |= 1;
            }
            if (string.indexOf("private") != -1) {
                n |= 2;
            }
            if (string.indexOf("protected") != -1) {
                n |= 4;
            }
            if (string.indexOf("static") != -1) {
                n |= 8;
            }
            if (string.indexOf("final") != -1) {
                n |= 0x10;
            }
            if (string.indexOf("super") != -1) {
                n |= 0x20;
            }
            if (string.indexOf("synchronized") != -1) {
                n |= 0x20;
            }
            if (string.indexOf("volatile") != -1) {
                n |= 0x40;
            }
            if (string.indexOf("bridge") != -1) {
                n |= 0x40;
            }
            if (string.indexOf("varargs") != -1) {
                n |= 0x80;
            }
            if (string.indexOf("transient") != -1) {
                n |= 0x80;
            }
            if (string.indexOf("native") != -1) {
                n |= 0x100;
            }
            if (string.indexOf("interface") != -1) {
                n |= 0x200;
            }
            if (string.indexOf("abstract") != -1) {
                n |= 0x400;
            }
            if (string.indexOf("strict") != -1) {
                n |= 0x800;
            }
            if (string.indexOf("synthetic") != -1) {
                n |= 0x1000;
            }
            if (string.indexOf("annotation") != -1) {
                n |= 0x2000;
            }
            if (string.indexOf("enum") != -1) {
                n |= 0x4000;
            }
            if (string.indexOf("deprecated") != -1) {
                n |= 0x20000;
            }
            return n;
        }
    }

    private static final class RuleSet {
        private final Map rules = new HashMap();
        private final List lpatterns = new ArrayList();
        private final List rpatterns = new ArrayList();

        private RuleSet() {
        }

        public void add(String string, Object object) {
            String string2 = string;
            if (string.startsWith("*/")) {
                string2 = string.substring(1);
                this.lpatterns.add(string2);
            } else if (string.endsWith("/*")) {
                string2 = string.substring(0, string.length() - 1);
                this.rpatterns.add(string2);
            }
            this.rules.put(string2, object);
        }

        public Object match(String string) {
            String string2;
            if (this.rules.containsKey(string)) {
                return this.rules.get(string);
            }
            int n = string.lastIndexOf(47);
            Iterator iterator = this.lpatterns.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!string.substring(n).endsWith(string2)) continue;
                return this.rules.get(string2);
            }
            iterator = this.rpatterns.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!string.startsWith(string2)) continue;
                return this.rules.get(string2);
            }
            return null;
        }
    }

    private static interface OpcodeGroup {
        public static final int INSN = 0;
        public static final int INSN_INT = 1;
        public static final int INSN_VAR = 2;
        public static final int INSN_TYPE = 3;
        public static final int INSN_FIELD = 4;
        public static final int INSN_METHOD = 5;
        public static final int INSN_JUMP = 6;
        public static final int INSN_LDC = 7;
        public static final int INSN_IINC = 8;
        public static final int INSN_MULTIANEWARRAY = 9;
    }
}

