/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.editor;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.editor.Editor;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class EditorRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Editor editor = (Editor)component;
        String paramKey = this.getInputId(editor.getClientId(facesContext));
        String submittedValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(paramKey);
        editor.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Editor editor = (Editor)component;
        this.encodeEditorScript(facesContext, editor);
        this.encodeEditorMarkup(facesContext, editor);
    }

    private void encodeEditorMarkup(FacesContext facesContext, Editor editor) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = editor.getClientId(facesContext);
        String inputId = this.getInputId(clientId);
        String value = ComponentUtils.getStringValueToRender(facesContext, (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        if (value != null) {
            writer.write(value);
        }
        writer.endElement("textarea");
        if (editor.isResizable()) {
            this.encodeSizeStateHolder(facesContext, editor, clientId);
        }
        writer.endElement("div");
    }

    private void encodeSizeStateHolder(FacesContext facesContext, Editor editor, String clientId) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String size = editor.getWidth() + "," + editor.getHeight();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)this.getSizeStateHolderId(clientId), null);
        writer.writeAttribute("name", (Object)this.getSizeStateHolderId(clientId), null);
        writer.writeAttribute("value", (Object)size, null);
        writer.endElement("input");
    }

    private void restoreSize(FacesContext facesContext, Editor editor, String clientId) {
        String newSize = (String)facesContext.getExternalContext().getRequestParameterMap().get(this.getSizeStateHolderId(clientId));
        if (newSize != null) {
            String[] boundaries = newSize.split(",");
            editor.setWidth(boundaries[0].trim());
            editor.setHeight(boundaries[1].trim());
        }
    }

    private void encodeEditorScript(FacesContext facesContext, Editor editor) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = editor.getClientId(facesContext);
        String editorVariable = this.createUniqueWidgetVar(facesContext, (UIComponent)editor);
        this.restoreSize(facesContext, editor, clientId);
        writer.startElement("script", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(editorVariable + " = new PrimeFaces.widget.Editor('" + this.getInputId(clientId) + "',{");
        writer.write("width:'" + editor.getWidth() + "'");
        writer.write(",height:'" + editor.getHeight() + "'");
        writer.write(",handleSubmit: true");
        if (editor.isResizable()) {
            writer.write(",resizable: true");
            writer.write(",widthHeightController: '" + this.getSizeStateHolderId(clientId) + "'");
            writer.write(",dompath: true");
        }
        if (editor.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (editor.getLanguage() != null) {
            writer.write(",language:'" + editor.getLanguage() + "'");
        }
        if (editor.getTitle() != null) {
            writer.write(",title:'" + editor.getTitle() + "'");
        }
        writer.write("});\n");
        writer.write(editorVariable + ".render();\n");
        writer.write("});\n");
        writer.endElement("script");
    }

    private String getSizeStateHolderId(String clientId) {
        return clientId.replaceAll(":", "_") + "_size";
    }

    private String getInputId(String clientId) {
        return clientId + ":input";
    }
}

