/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.idlemonitor;

import java.io.Serializable;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.resource.ResourceHolder;

public class IdleMonitor
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.IdleMonitor";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.IdleMonitorRenderer";

    public IdleMonitor() {
        this.setRendererType(DEFAULT_RENDERER);
        ResourceHolder resourceHolder = this.getResourceHolder();
        if (resourceHolder != null) {
            resourceHolder.addResource("/jquery/jquery.js");
            resourceHolder.addResource("/jquery/plugins/idletimer/idletimer.js");
            resourceHolder.addResource("/primefaces/ajax/ajax.js");
            resourceHolder.addResource("/primefaces/idlemonitor/idlemonitor.js");
        }
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public int getTimeout() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeout), (Object)300000);
    }

    public void setTimeout(int _timeout) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeout), (Object)_timeout);
    }

    public String getOnidle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onidle), null);
    }

    public void setOnidle(String _onidle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onidle), (Object)_onidle);
    }

    public String getOnactive() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onactive), null);
    }

    public void setOnactive(String _onactive) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onactive), (Object)_onactive);
    }

    public MethodExpression getIdleListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.idleListener), null);
    }

    public void setIdleListener(MethodExpression _idleListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.idleListener), (Object)_idleListener);
    }

    public String getUpdate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.update), null);
    }

    public void setUpdate(String _update) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.update), (Object)_update);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MethodExpression me = this.getIdleListener();
        if (me != null) {
            me.invoke(facesContext.getELContext(), new Object[]{event});
        }
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected ResourceHolder getResourceHolder() {
        FacesContext facesContext = this.getFacesContext();
        if (facesContext == null) {
            return null;
        }
        ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);
        return (ResourceHolder)ve.getValue(facesContext.getELContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        timeout,
        onidle,
        onactive,
        idleListener,
        update;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

