/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionRemoveEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;

public class EventType<T> {
    public static final EventType<LoadEventListener> LOAD = new EventType<LoadEventListener>("load", LoadEventListener.class);
    public static final EventType<InitializeCollectionEventListener> INIT_COLLECTION = new EventType<InitializeCollectionEventListener>("load-collection", InitializeCollectionEventListener.class);
    public static final EventType<SaveOrUpdateEventListener> SAVE_UPDATE = new EventType<SaveOrUpdateEventListener>("save-update", SaveOrUpdateEventListener.class);
    public static final EventType<SaveOrUpdateEventListener> UPDATE = new EventType<SaveOrUpdateEventListener>("update", SaveOrUpdateEventListener.class);
    public static final EventType<SaveOrUpdateEventListener> SAVE = new EventType<SaveOrUpdateEventListener>("save", SaveOrUpdateEventListener.class);
    public static final EventType<PersistEventListener> PERSIST = new EventType<PersistEventListener>("create", PersistEventListener.class);
    public static final EventType<PersistEventListener> PERSIST_ONFLUSH = new EventType<PersistEventListener>("create-onflush", PersistEventListener.class);
    public static final EventType<MergeEventListener> MERGE = new EventType<MergeEventListener>("merge", MergeEventListener.class);
    public static final EventType<DeleteEventListener> DELETE = new EventType<DeleteEventListener>("delete", DeleteEventListener.class);
    public static final EventType<ReplicateEventListener> REPLICATE = new EventType<ReplicateEventListener>("replicate", ReplicateEventListener.class);
    public static final EventType<FlushEventListener> FLUSH = new EventType<FlushEventListener>("flush", FlushEventListener.class);
    public static final EventType<AutoFlushEventListener> AUTO_FLUSH = new EventType<AutoFlushEventListener>("auto-flush", AutoFlushEventListener.class);
    public static final EventType<DirtyCheckEventListener> DIRTY_CHECK = new EventType<DirtyCheckEventListener>("dirty-check", DirtyCheckEventListener.class);
    public static final EventType<FlushEntityEventListener> FLUSH_ENTITY = new EventType<FlushEntityEventListener>("flush-entity", FlushEntityEventListener.class);
    public static final EventType<EvictEventListener> EVICT = new EventType<EvictEventListener>("evict", EvictEventListener.class);
    public static final EventType<LockEventListener> LOCK = new EventType<LockEventListener>("lock", LockEventListener.class);
    public static final EventType<RefreshEventListener> REFRESH = new EventType<RefreshEventListener>("refresh", RefreshEventListener.class);
    public static final EventType<PreLoadEventListener> PRE_LOAD = new EventType<PreLoadEventListener>("pre-load", PreLoadEventListener.class);
    public static final EventType<PreDeleteEventListener> PRE_DELETE = new EventType<PreDeleteEventListener>("pre-delete", PreDeleteEventListener.class);
    public static final EventType<PreUpdateEventListener> PRE_UPDATE = new EventType<PreUpdateEventListener>("pre-update", PreUpdateEventListener.class);
    public static final EventType<PreInsertEventListener> PRE_INSERT = new EventType<PreInsertEventListener>("pre-insert", PreInsertEventListener.class);
    public static final EventType<PostLoadEventListener> POST_LOAD = new EventType<PostLoadEventListener>("post-load", PostLoadEventListener.class);
    public static final EventType<PostDeleteEventListener> POST_DELETE = new EventType<PostDeleteEventListener>("post-delete", PostDeleteEventListener.class);
    public static final EventType<PostUpdateEventListener> POST_UPDATE = new EventType<PostUpdateEventListener>("post-update", PostUpdateEventListener.class);
    public static final EventType<PostInsertEventListener> POST_INSERT = new EventType<PostInsertEventListener>("post-insert", PostInsertEventListener.class);
    public static final EventType<PostDeleteEventListener> POST_COMMIT_DELETE = new EventType<PostDeleteEventListener>("post-commit-delete", PostDeleteEventListener.class);
    public static final EventType<PostUpdateEventListener> POST_COMMIT_UPDATE = new EventType<PostUpdateEventListener>("post-commit-update", PostUpdateEventListener.class);
    public static final EventType<PostInsertEventListener> POST_COMMIT_INSERT = new EventType<PostInsertEventListener>("post-commit-insert", PostInsertEventListener.class);
    public static final EventType<PreCollectionRecreateEventListener> PRE_COLLECTION_RECREATE = new EventType<PreCollectionRecreateEventListener>("pre-collection-recreate", PreCollectionRecreateEventListener.class);
    public static final EventType<PreCollectionRemoveEventListener> PRE_COLLECTION_REMOVE = new EventType<PreCollectionRemoveEventListener>("pre-collection-remove", PreCollectionRemoveEventListener.class);
    public static final EventType<PreCollectionUpdateEventListener> PRE_COLLECTION_UPDATE = new EventType<PreCollectionUpdateEventListener>("pre-collection-update", PreCollectionUpdateEventListener.class);
    public static final EventType<PostCollectionRecreateEventListener> POST_COLLECTION_RECREATE = new EventType<PostCollectionRecreateEventListener>("post-collection-recreate", PostCollectionRecreateEventListener.class);
    public static final EventType<PostCollectionRemoveEventListener> POST_COLLECTION_REMOVE = new EventType<PostCollectionRemoveEventListener>("post-collection-remove", PostCollectionRemoveEventListener.class);
    public static final EventType<PostCollectionUpdateEventListener> POST_COLLECTION_UPDATE = new EventType<PostCollectionUpdateEventListener>("post-collection-update", PostCollectionUpdateEventListener.class);
    public static final Map<String, EventType> eventTypeByNameMap = AccessController.doPrivileged(new PrivilegedAction<Map<String, EventType>>(){

        @Override
        public Map<String, EventType> run() {
            HashMap<String, EventType> typeByNameMap = new HashMap<String, EventType>();
            Field[] fields = EventType.class.getDeclaredFields();
            int max = fields.length;
            for (int i = 0; i < max; ++i) {
                if (!EventType.class.isAssignableFrom(fields[i].getType())) continue;
                try {
                    EventType typeField = (EventType)fields[i].get(null);
                    typeByNameMap.put(typeField.eventName(), typeField);
                    continue;
                }
                catch (Exception t) {
                    throw new HibernateException("Unable to initialize EventType map", t);
                }
            }
            return typeByNameMap;
        }
    });
    private final String eventName;
    private final Class<? extends T> baseListenerInterface;

    public static EventType resolveEventTypeByName(String eventName) {
        if (eventName == null) {
            throw new HibernateException("event name to resolve cannot be null");
        }
        EventType eventType = eventTypeByNameMap.get(eventName);
        if (eventType == null) {
            throw new HibernateException("Unable to locate proper event type for event name [" + eventName + "]");
        }
        return eventType;
    }

    public static Collection<EventType> values() {
        return eventTypeByNameMap.values();
    }

    private EventType(String eventName, Class<? extends T> baseListenerInterface) {
        this.eventName = eventName;
        this.baseListenerInterface = baseListenerInterface;
    }

    public String eventName() {
        return this.eventName;
    }

    public Class baseListenerInterface() {
        return this.baseListenerInterface;
    }

    public String toString() {
        return this.eventName();
    }
}

