/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.framework.ViewHandlerWrapper;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxViewRoot;
import org.ajax4jsf.framework.ajax.ViewIdHolder;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxViewHandler
extends ViewHandlerWrapper {
    public static final String STATE_MARKER_KEY = "org.ajax4jsf.view.state";
    public static final String SERIALIZED_STATE_KEY = "org.ajax4jsf.view.serializedstate";
    private static final Log _log = LogFactory.getLog((Class)AjaxViewHandler.class);
    private static final String REDIRECTED = "org.ajax4jsf.view.REDIRECTED";

    public AjaxViewHandler(ViewHandler parent) {
        super(parent);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        UIViewRoot riRoot;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(facesContext);
        ViewIdHolder viewIdHolder = ajaxContext.getViewIdHolder();
        if (null != viewIdHolder && viewIdHolder.skipNavigation(viewId)) {
            viewIdHolder.setViewId(viewId);
            riRoot = facesContext.getViewRoot();
        } else {
            UIViewRoot root = super.createView(facesContext, viewId);
            if (null == root || root instanceof AjaxViewRoot) {
                riRoot = root;
            } else {
                riRoot = (UIViewRoot)facesContext.getApplication().createComponent("javax.faces.ViewRoot");
                riRoot.setViewId(root.getViewId());
                riRoot.setLocale(root.getLocale());
                String renderKitId = root.getRenderKitId();
                if (null == renderKitId) {
                    renderKitId = this.calculateRenderKitId(facesContext);
                }
                riRoot.setRenderKitId(renderKitId);
            }
            if (ajaxContext.isAjaxRequest(facesContext)) {
                ajaxContext.setAjaxRequest(false);
            }
        }
        return riRoot;
    }

    public void writeState(FacesContext context) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        if (ajaxContext.isAjaxRequest(context)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)STATE_MARKER_KEY, null);
            writer.writeAttribute("name", (Object)STATE_MARKER_KEY, null);
            if (!ajaxContext.isSelfRender()) {
                super.writeState(context);
            }
            writer.endElement("span");
        } else {
            super.writeState(context);
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot viewRoot = super.restoreView(context, viewId);
        ExternalContext externalContext = context.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        Map requestMap = externalContext.getRequestMap();
        if (null == viewRoot && requestParameterMap.containsKey("AJAXREQUEST") && !requestMap.containsKey(REDIRECTED)) {
            String actionURL = this.getActionURL(context, viewId);
            requestMap.put(REDIRECTED, Boolean.TRUE);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Detect session expiration in AJAX request - view don't restored, action URL is " + actionURL));
            }
            try {
                Object response = externalContext.getResponse();
                if (response instanceof HttpServletResponse) {
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.setHeader("Ajax-Expired", Messages.getMessage("AJAX_VIEW_EXPIRED"));
                }
                actionURL = externalContext.encodeActionURL(actionURL);
                externalContext.redirect(actionURL);
            }
            catch (IOException e) {
                throw new FacesException("Error on redirect for reload expired page", (Throwable)e);
            }
        }
        return viewRoot;
    }

    public String getResourceURL(FacesContext context, String url) {
        String resourceURL;
        if (url.startsWith("resource://")) {
            InternetResource resource = InternetResourceBuilder.getInstance().createResource(null, url.substring(InternetResource.RESOURCE_URI_PREFIX_LENGTH));
            resourceURL = resource.getUri(context, null);
        } else {
            resourceURL = super.getResourceURL(context, url);
        }
        return resourceURL;
    }

    public void renderView(FacesContext context, UIViewRoot root) throws IOException, FacesException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        if (root instanceof AjaxViewRoot) {
            AjaxViewRoot ajaxRoot = (AjaxViewRoot)root;
            Map requestMap = context.getExternalContext().getRequestMap();
            if (ajaxContext.isAjaxRequest(context) && null == requestMap.get("org.ajax4jsf.areas.rendered")) {
                this.processAjaxEvents(context, ajaxRoot);
            }
            if (!context.getResponseComplete()) {
                super.renderView(context, root);
                if (ajaxContext.isAjaxRequest(context) && null == requestMap.get("org.ajax4jsf.areas.rendered")) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)Messages.getMessage(Messages.AJAX_RESPONSE_NOT_RENDERED_INFO));
                    }
                    ajaxContext.setSelfRender(true);
                    Object response = context.getExternalContext().getResponse();
                    try {
                        response.getClass().getDeclaredMethod("reset", new Class[0]).invoke(response, new Object[0]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ajaxContext.renderSubmittedAjaxRegion(context, true);
                }
            }
        } else {
            super.renderView(context, root);
        }
        ajaxContext.processHeadResources(context);
    }

    private void processAjaxEvents(FacesContext context, AjaxViewRoot ajaxRoot) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)Messages.getMessage(Messages.PROCESS_AJAX_EVENTS_INFO));
        }
        ajaxRoot.broadcastAjaxEvents(context);
    }
}

