/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.jms;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.Token;
import org.jbpm.msg.Message;
import org.jbpm.msg.MessageService;

public class JmsMessageServiceImpl
implements MessageService {
    private static final long serialVersionUID = 1L;
    Connection connection = null;
    Session session = null;
    Destination destination = null;
    MessageProducer messageProducer = null;
    boolean isCommitEnabled = true;

    public JmsMessageServiceImpl(Connection connection, Session session, Destination destination, boolean isCommitEnabled) {
        this.connection = connection;
        this.session = session;
        this.destination = destination;
        this.isCommitEnabled = isCommitEnabled;
    }

    public void send(Message message) {
        try {
            ObjectMessage objectMessage = this.session.createObjectMessage((Serializable)message);
            Token token = message.getToken();
            if (token != null) {
                objectMessage.setLongProperty("tokenId", token.getId());
            }
            this.getMessageProducer().send(this.destination, (javax.jms.Message)objectMessage);
        }
        catch (JMSException e) {
            throw new JbpmException("couldn't send jms message", e);
        }
    }

    public void close() {
        Exception exception = null;
        try {
            if (this.messageProducer != null) {
                this.messageProducer.close();
            }
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            if (this.session != null && this.isCommitEnabled) {
                this.session.commit();
            }
        }
        catch (Exception e) {
            exception = exception != null ? new JbpmException("couldn't commit JMS session", e) : e;
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Exception e) {
            exception = exception != null ? new JbpmException("couldn't close JMS session", e) : e;
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            exception = exception != null ? new JbpmException("couldn't close JMS connection", e) : e;
        }
        if (exception != null) {
            throw new JbpmException("couldn't close one of the jms objects", exception);
        }
    }

    public void suspendMessages(Token token) {
    }

    public void resumeMessages(Token token) {
    }

    MessageProducer getMessageProducer() throws JMSException {
        if (this.messageProducer == null) {
            this.messageProducer = this.session.createProducer(this.destination);
        }
        return this.messageProducer;
    }

    public boolean hasMessages() {
        return false;
    }

    public Message receiveNoWait() {
        return null;
    }

    public Message receiveByIdNoWait(long id) {
        return null;
    }
}

