/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

public class ServiceDynamicMBeanSupport
extends ServiceMBeanSupport
implements DynamicMBean {
    public ServiceDynamicMBeanSupport() {
    }

    public ServiceDynamicMBeanSupport(Class type) {
        super(type);
    }

    public ServiceDynamicMBeanSupport(String category) {
        super(category);
    }

    public ServiceDynamicMBeanSupport(Logger log) {
        super(log);
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if ("State".equals(attribute)) {
            return new Integer(this.getState());
        }
        if ("StateString".equals(attribute)) {
            return this.getStateString();
        }
        if ("Name".equals(attribute)) {
            return this.getName();
        }
        return this.getInternalAttribute(attribute);
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            if ("jbossInternalLifecycle".equals(actionName)) {
                this.jbossInternalLifecycle((String)params[0]);
                return null;
            }
            if (params == null || params.length == 0) {
                if ("create".equals(actionName)) {
                    this.create();
                    return null;
                }
                if ("start".equals(actionName)) {
                    this.start();
                    return null;
                }
                if ("stop".equals(actionName)) {
                    this.stop();
                    return null;
                }
                if ("destroy".equals(actionName)) {
                    this.destroy();
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new MBeanException(e, "Exception in service lifecyle operation: " + actionName);
        }
        try {
            return this.internalInvoke(actionName, params, signature);
        }
        catch (Exception e) {
            throw new MBeanException(e, "Exception invoking: " + actionName);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.setInternalAttribute(attribute);
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        if (attributes == null) {
            return list;
        }
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            try {
                this.setAttribute(attribute);
                list.add(attribute);
                continue;
            }
            catch (Throwable t) {
                this.log.debug("Error setting attribute " + attribute.getName(), t);
            }
        }
        return list;
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        if (attributes == null) {
            return list;
        }
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                list.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (Throwable t) {
                this.log.debug("Error getting attribute " + attributes[i], t);
            }
        }
        return list;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanParameterInfo[] noParams = new MBeanParameterInfo[]{};
        MBeanConstructorInfo[] ctorInfo = this.getInternalConstructorInfo();
        MBeanAttributeInfo[] attrs = this.getInternalAttributeInfo();
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[3 + attrs.length];
        attrInfo[0] = new MBeanAttributeInfo("Name", "java.lang.String", "Return the service name", true, false, false);
        attrInfo[1] = new MBeanAttributeInfo("State", "int", "Return the service state", true, false, false);
        attrInfo[2] = new MBeanAttributeInfo("StateString", "java.lang.String", "Return the service's state as a String", true, false, false);
        System.arraycopy(attrs, 0, attrInfo, 3, attrs.length);
        MBeanParameterInfo[] jbossInternalLifecycleParms = new MBeanParameterInfo[]{new MBeanParameterInfo("method", String.class.getName(), "The lifecycle method")};
        MBeanOperationInfo[] ops = this.getInternalOperationInfo();
        MBeanOperationInfo[] opInfo = new MBeanOperationInfo[5 + ops.length];
        opInfo[0] = new MBeanOperationInfo("create", "create service lifecycle operation", noParams, "void", 1);
        opInfo[1] = new MBeanOperationInfo("start", "start service lifecycle operation", noParams, "void", 1);
        opInfo[2] = new MBeanOperationInfo("stop", "stop service lifecycle operation", noParams, "void", 1);
        opInfo[3] = new MBeanOperationInfo("destroy", "destroy service lifecycle operation", noParams, "void", 1);
        opInfo[4] = new MBeanOperationInfo("jbossInternalLifecycle", "Internal lifecycle (for internal use)", jbossInternalLifecycleParms, "void", 1);
        System.arraycopy(ops, 0, opInfo, 5, ops.length);
        MBeanNotificationInfo[] notifyInfo = this.getInternalNotificationInfo();
        return new MBeanInfo(this.getClass().getName(), this.getInternalDescription(), attrInfo, ctorInfo, opInfo, notifyInfo);
    }

    protected String getInternalDescription() {
        return "DynamicMBean Service";
    }

    protected MBeanConstructorInfo[] getInternalConstructorInfo() {
        return new MBeanConstructorInfo[0];
    }

    protected MBeanAttributeInfo[] getInternalAttributeInfo() {
        return new MBeanAttributeInfo[0];
    }

    protected MBeanOperationInfo[] getInternalOperationInfo() {
        return new MBeanOperationInfo[0];
    }

    protected MBeanNotificationInfo[] getInternalNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    protected Object getInternalAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("Attribute not found " + attribute);
    }

    protected void setInternalAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("Attribute not found " + attribute);
    }

    protected Object internalInvoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(actionName);
        buffer.append('(');
        for (int i = 0; i < signature.length; ++i) {
            buffer.append(signature[i]);
            if (i >= signature.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(')');
        throw new MBeanException(new Exception("Operation not found " + buffer.toString()), "Operation not found " + actionName);
    }
}

