/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.ScheduleMouseEvent;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.renderer.DefaultScheduleEntryRenderer;
import org.apache.myfaces.custom.schedule.renderer.ScheduleEntryRenderer;
import org.apache.myfaces.custom.schedule.util.ScheduleEntryComparator;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;

public abstract class AbstractScheduleRenderer
extends Renderer
implements Serializable {
    protected static final ScheduleEntryComparator comparator = new ScheduleEntryComparator();
    protected static final String LAST_CLICKED_DATE = "_last_clicked_date";
    protected static final String LAST_CLICKED_Y = "_last_clicked_y";
    private static final String CSS_RESOURCE = "css/schedule.css";
    public static final String DEFAULT_THEME = "default";
    public static final String OUTLOOK_THEME = "outlookxp";
    public static final String EVOLUTION_THEME = "evolution";
    static /* synthetic */ Class class$org$apache$myfaces$custom$schedule$HtmlSchedule;

    public void decode(FacesContext context, UIComponent component) {
        HtmlSchedule schedule = (HtmlSchedule)component;
        boolean queueAction = false;
        if (ScheduleUtil.canModifyValue(component)) {
            Map parameters = context.getExternalContext().getRequestParameterMap();
            String selectedEntryId = (String)parameters.get(schedule.getClientId(context));
            String lastClickedDateId = (String)parameters.get(schedule.getClientId(context) + LAST_CLICKED_DATE);
            String lastClickedY = (String)parameters.get(schedule.getClientId(context) + LAST_CLICKED_Y);
            ScheduleMouseEvent mouseEvent = null;
            if (selectedEntryId != null && selectedEntryId.length() > 0) {
                ScheduleEntry entry = schedule.findEntry(selectedEntryId);
                schedule.setSubmittedEntry(entry);
                mouseEvent = new ScheduleMouseEvent(schedule, 3);
                queueAction = true;
            }
            if (schedule.isSubmitOnClick()) {
                schedule.resetMouseEvents();
                if (lastClickedY != null && lastClickedY.length() > 0) {
                    schedule.setLastClickedDateAndTime(this.determineLastClickedDate(schedule, lastClickedDateId, lastClickedY));
                    mouseEvent = new ScheduleMouseEvent(schedule, 1);
                    queueAction = true;
                } else if (lastClickedDateId != null && lastClickedDateId.length() > 0) {
                    schedule.setLastClickedDateAndTime(this.determineLastClickedDate(schedule, lastClickedDateId, "0"));
                    mouseEvent = new ScheduleMouseEvent(schedule, 2);
                    queueAction = true;
                } else if (mouseEvent == null) {
                    mouseEvent = new ScheduleMouseEvent(schedule, 0);
                }
            }
            if (mouseEvent != null) {
                schedule.queueEvent(mouseEvent);
            }
        }
        if (queueAction) {
            schedule.queueEvent((FacesEvent)new ActionEvent((UIComponent)schedule));
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        AddResource addResource = AddResourceFactory.getInstance(context);
        String theme = this.getTheme((UIComponent)schedule);
        if (DEFAULT_THEME.equals(theme) || OUTLOOK_THEME.equals(theme) || EVOLUTION_THEME.equals(theme)) {
            addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$schedule$HtmlSchedule == null ? (class$org$apache$myfaces$custom$schedule$HtmlSchedule = AbstractScheduleRenderer.class$("org.apache.myfaces.custom.schedule.HtmlSchedule")) : class$org$apache$myfaces$custom$schedule$HtmlSchedule, CSS_RESOURCE);
        }
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$schedule$HtmlSchedule == null ? (class$org$apache$myfaces$custom$schedule$HtmlSchedule = AbstractScheduleRenderer.class$("org.apache.myfaces.custom.schedule.HtmlSchedule")) : class$org$apache$myfaces$custom$schedule$HtmlSchedule, "javascript/schedule.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$schedule$HtmlSchedule == null ? (class$org$apache$myfaces$custom$schedule$HtmlSchedule = AbstractScheduleRenderer.class$("org.apache.myfaces.custom.schedule.HtmlSchedule")) : class$org$apache$myfaces$custom$schedule$HtmlSchedule, "javascript/alphaAPI.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$schedule$HtmlSchedule == null ? (class$org$apache$myfaces$custom$schedule$HtmlSchedule = AbstractScheduleRenderer.class$("org.apache.myfaces.custom.schedule.HtmlSchedule")) : class$org$apache$myfaces$custom$schedule$HtmlSchedule, "javascript/domLib.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$schedule$HtmlSchedule == null ? (class$org$apache$myfaces$custom$schedule$HtmlSchedule = AbstractScheduleRenderer.class$("org.apache.myfaces.custom.schedule.HtmlSchedule")) : class$org$apache$myfaces$custom$schedule$HtmlSchedule, "javascript/domTT.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$schedule$HtmlSchedule == null ? (class$org$apache$myfaces$custom$schedule$HtmlSchedule = AbstractScheduleRenderer.class$("org.apache.myfaces.custom.schedule.HtmlSchedule")) : class$org$apache$myfaces$custom$schedule$HtmlSchedule, "javascript/fadomatic.js");
        writer.startElement("input", (UIComponent)schedule);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)schedule.getClientId(context), "clientId");
        writer.endElement("input");
        writer.startElement("input", (UIComponent)schedule);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(schedule.getClientId(context) + LAST_CLICKED_DATE), "clicked_date");
        writer.endElement("input");
        writer.startElement("input", (UIComponent)schedule);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(schedule.getClientId(context) + LAST_CLICKED_Y), "clicked_y");
        writer.endElement("input");
    }

    protected String getDateString(FacesContext context, UIComponent component, Date date) {
        String pattern = this.getHeaderDateFormat(component);
        DateFormat format = pattern != null && pattern.length() > 0 ? new SimpleDateFormat(pattern) : (context.getApplication().getDefaultLocale() != null ? DateFormat.getDateInstance(2, context.getApplication().getDefaultLocale()) : DateFormat.getDateInstance(2));
        return format.format(date);
    }

    protected String getTheme(UIComponent component) {
        String value;
        ValueBinding binding = component.getValueBinding("theme");
        if (binding != null && (value = (String)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        String theme = (String)attributes.get("theme");
        if (theme == null || theme.length() < 1) {
            theme = DEFAULT_THEME;
        }
        return theme;
    }

    protected String getStyleClass(UIComponent component, String className) {
        String value;
        ValueBinding binding = component.getValueBinding(className);
        if (binding != null && (value = (String)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        String returnValue = (String)attributes.get(className);
        return returnValue == null ? className : returnValue;
    }

    protected String getHeaderDateFormat(UIComponent component) {
        String value;
        ValueBinding binding = component.getValueBinding("headerDateFormat");
        if (binding != null && (value = (String)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        return (String)attributes.get("headerDateFormat");
    }

    protected boolean showTooltip(UIComponent component) {
        Boolean value;
        ValueBinding binding = component.getValueBinding("tooltip");
        if (binding != null && (value = (Boolean)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        return Boolean.valueOf((String)attributes.get("tooltip"));
    }

    protected ScheduleEntryRenderer getEntryRenderer(UIComponent component) {
        Object entryRendererObject = ScheduleUtil.getObjectProperty(component, null, "entryRenderer", null);
        if (entryRendererObject instanceof ScheduleEntryRenderer) {
            return (ScheduleEntryRenderer)entryRendererObject;
        }
        return new DefaultScheduleEntryRenderer();
    }

    protected abstract int getDefaultRowHeight();

    protected abstract String getRowHeightProperty();

    protected int getRowHeight(Map attributes) {
        int rowHeight = 0;
        try {
            Integer rowHeightObject = (Integer)attributes.get(this.getRowHeightProperty());
            rowHeight = rowHeightObject;
        }
        catch (Exception e) {
            rowHeight = 0;
        }
        if (rowHeight <= 0) {
            rowHeight = this.getDefaultRowHeight();
        }
        return rowHeight;
    }

    protected abstract Date determineLastClickedDate(HtmlSchedule var1, String var2, String var3);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

