/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.CallbackListener;
import org.apache.myfaces.renderkit.html.util.HtmlBufferResponseWriterWrapper;
import org.apache.myfaces.renderkit.html.util.MyFacesResourceHandler;
import org.apache.myfaces.renderkit.html.util.ReducedHTMLParser;
import org.apache.myfaces.renderkit.html.util.ResourceHandler;
import org.apache.myfaces.renderkit.html.util.ResourceLoader;
import org.apache.myfaces.renderkit.html.util.ResourcePosition;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlResponseWriterImpl;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public class DefaultAddResource
implements AddResource {
    private static final String PATH_SEPARATOR = "/";
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$util$DefaultAddResource == null ? (class$org$apache$myfaces$renderkit$html$util$DefaultAddResource = DefaultAddResource.class$("org.apache.myfaces.renderkit.html.util.DefaultAddResource")) : class$org$apache$myfaces$renderkit$html$util$DefaultAddResource));
    private static final String RESOURCE_VIRTUAL_PATH = "/faces/myFacesExtensionResource";
    private static final String RESOURCES_CACHE_KEY = (class$org$apache$myfaces$renderkit$html$util$AddResource == null ? (class$org$apache$myfaces$renderkit$html$util$AddResource = DefaultAddResource.class$("org.apache.myfaces.renderkit.html.util.AddResource")) : class$org$apache$myfaces$renderkit$html$util$AddResource).getName() + ".CACHE_KEY";
    protected String _contextPath;
    private StringBuffer originalResponse;
    private Set headerBeginInfo;
    private Set bodyEndInfo;
    private Set bodyOnloadInfo;
    protected boolean parserCalled = false;
    protected int headerInsertPosition = -1;
    protected int bodyInsertPosition = -1;
    protected int beforeBodyPosition = -1;
    protected int afterBodyContentInsertPosition = -1;
    protected int beforeBodyEndPosition = -1;
    private String resourceVirtualPath;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$DefaultAddResource;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$AddResource;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$ResourceLoader;

    protected DefaultAddResource() {
    }

    public void setContextPath(String contextPath) {
        if (this._contextPath != null) {
            throw new SecurityException("context path already set");
        }
        this._contextPath = contextPath;
    }

    public void addJavaScriptHere(FacesContext context, Class myfacesCustomComponent, String resourceName) throws IOException {
        this.addJavaScriptHere(context, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addJavaScriptHere(FacesContext context, String uri) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String src = context.getExternalContext().encodeResourceURL(this.getResourceUri(context, uri));
        writer.writeURIAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    public void addJavaScriptHerePlain(FacesContext context, String uri) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String src = this.getResourceUri(context, uri);
        writer.writeURIAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    public void addJavaScriptHere(FacesContext context, ResourceHandler resourceHandler) throws IOException {
        this.validateResourceHandler(resourceHandler);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String src = context.getExternalContext().encodeResourceURL(this.getResourceUri(context, resourceHandler));
        writer.writeURIAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    public void addResourceHere(FacesContext context, ResourceHandler resourceHandler) throws IOException {
        this.validateResourceHandler(resourceHandler);
        String path = this.getResourceUri(context, resourceHandler);
        ResponseWriter writer = context.getResponseWriter();
        writer.write(context.getExternalContext().encodeResourceURL(path));
    }

    protected void validateResourceHandler(ResourceHandler resourceHandler) {
        if (resourceHandler == null) {
            throw new IllegalArgumentException("ResourceHandler is null");
        }
        this.validateResourceLoader(resourceHandler.getResourceLoaderClass());
    }

    protected void validateResourceLoader(Class resourceloader) {
        if (!(class$org$apache$myfaces$renderkit$html$util$ResourceLoader == null ? (class$org$apache$myfaces$renderkit$html$util$ResourceLoader = DefaultAddResource.class$("org.apache.myfaces.renderkit.html.util.ResourceLoader")) : class$org$apache$myfaces$renderkit$html$util$ResourceLoader).isAssignableFrom(resourceloader)) {
            throw new FacesException("Class " + resourceloader.getName() + " must implement " + (class$org$apache$myfaces$renderkit$html$util$ResourceLoader == null ? (class$org$apache$myfaces$renderkit$html$util$ResourceLoader = DefaultAddResource.class$("org.apache.myfaces.renderkit.html.util.ResourceLoader")) : class$org$apache$myfaces$renderkit$html$util$ResourceLoader).getName());
        }
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler) {
        this.addJavaScriptAtPosition(context, position, resourceHandler, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addJavaScriptAtPositionPlain(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName), false, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName, boolean defer) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName), defer);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, String uri) {
        this.addJavaScriptAtPosition(context, position, uri, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, String uri, boolean defer) {
        this.addPositionedInfo(position, this.getScriptInstance(context, uri, defer));
    }

    public void addJavaScriptToBodyTag(FacesContext context, String javascriptEventName, String addedJavaScript) {
        AttributeInfo info = new AttributeInfo();
        info.setAttributeName(javascriptEventName);
        info.setAttributeValue(addedJavaScript);
        this.addPositionedInfo(BODY_ONLOAD, info);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler, boolean defer) {
        this.validateResourceHandler(resourceHandler);
        this.addPositionedInfo(position, this.getScriptInstance(context, resourceHandler, defer));
    }

    private void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler, boolean defer, boolean encodeUrl) {
        this.validateResourceHandler(resourceHandler);
        this.addPositionedInfo(position, this.getScriptInstance(context, resourceHandler, defer, encodeUrl));
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addStyleSheet(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, String uri) {
        this.addPositionedInfo(position, this.getStyleInstance(context, uri));
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler) {
        this.validateResourceHandler(resourceHandler);
        this.addPositionedInfo(position, this.getStyleInstance(context, resourceHandler));
    }

    public void addInlineStyleAtPosition(FacesContext context, ResourcePosition position, String inlineStyle) {
        this.addPositionedInfo(position, this.getInlineStyleInstance(inlineStyle));
    }

    public void addInlineScriptAtPosition(FacesContext context, ResourcePosition position, String inlineScript) {
        this.addPositionedInfo(position, this.getInlineScriptInstance(inlineScript));
    }

    public String getResourceUri(FacesContext context, Class myfacesCustomComponent, String resource, boolean withContextPath) {
        return this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resource), withContextPath);
    }

    public String getResourceUri(FacesContext context, Class myfacesCustomComponent, String resource) {
        return this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resource));
    }

    public String getResourceUri(FacesContext context, ResourceHandler resourceHandler) {
        String uri = resourceHandler.getResourceUri(context);
        if (uri == null) {
            return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), true);
        }
        return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), true) + uri;
    }

    public String getResourceUri(FacesContext context, ResourceHandler resourceHandler, boolean withContextPath) {
        String uri = resourceHandler.getResourceUri(context);
        if (uri == null) {
            return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), withContextPath);
        }
        return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), withContextPath) + uri;
    }

    public String getResourceUri(FacesContext context, String uri) {
        return this.getResourceUri(context, uri, true);
    }

    public String getResourceUri(FacesContext context, String uri, boolean withContextPath) {
        if (withContextPath) {
            return context.getApplication().getViewHandler().getResourceURL(context, uri);
        }
        return uri;
    }

    protected String getResourceUri(FacesContext context, Class resourceLoader, boolean withContextPath) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(MyfacesConfig.getCurrentInstance(context.getExternalContext()).getResourceVirtualPath());
        sb.append(PATH_SEPARATOR);
        sb.append(resourceLoader.getName());
        sb.append(PATH_SEPARATOR);
        sb.append(this.getCacheKey(context));
        sb.append(PATH_SEPARATOR);
        return this.getResourceUri(context, sb.toString(), withContextPath);
    }

    protected long getCacheKey(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        Long cacheKey = (Long)applicationMap.get(RESOURCES_CACHE_KEY);
        if (cacheKey == null) {
            cacheKey = new Long(System.currentTimeMillis() / 100000L);
            applicationMap.put(RESOURCES_CACHE_KEY, cacheKey);
        }
        return cacheKey;
    }

    public boolean isResourceUri(ServletContext servletContext, HttpServletRequest request) {
        String path = this._contextPath != null ? this._contextPath + this.getResourceVirtualPath(servletContext) : this.getResourceVirtualPath(servletContext);
        try {
            if (request.getRequestURI().startsWith(URLEncoder.encode(path, "UTF-8"))) {
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Unsupported encoding UTF-8 used", (Throwable)e);
        }
        return request.getRequestURI().startsWith(path);
    }

    private String getResourceVirtualPath(ServletContext servletContext) {
        if (this.resourceVirtualPath == null) {
            this.resourceVirtualPath = servletContext.getInitParameter("org.apache.myfaces.RESOURCE_VIRTUAL_PATH");
            if (this.resourceVirtualPath == null) {
                this.resourceVirtualPath = RESOURCE_VIRTUAL_PATH;
            }
        }
        return this.resourceVirtualPath;
    }

    private Class getClass(String className) throws ClassNotFoundException {
        Class clazz = ClassUtils.classForName(className);
        this.validateResourceLoader(clazz);
        return clazz;
    }

    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        String uri = request.getContextPath() + request.getServletPath() + (pathInfo == null ? "" : pathInfo);
        String classNameStartsAfter = this.getResourceVirtualPath(context) + '/';
        int posStartClassName = uri.indexOf(classNameStartsAfter) + classNameStartsAfter.length();
        int posEndClassName = uri.indexOf(PATH_SEPARATOR, posStartClassName);
        String className = uri.substring(posStartClassName, posEndClassName);
        int posEndCacheKey = uri.indexOf(PATH_SEPARATOR, posEndClassName + 1);
        String resourceUri = null;
        if (posEndCacheKey + 1 < uri.length()) {
            resourceUri = uri.substring(posEndCacheKey + 1);
        }
        try {
            Class resourceLoader = this.getClass(className);
            this.validateResourceLoader(resourceLoader);
            ((ResourceLoader)resourceLoader.newInstance()).serveResource(context, request, response, resourceUri);
            response.flushBuffer();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find class for name: " + className), (Throwable)e);
            response.sendError(404, "Could not find resourceloader class for name: " + className);
        }
        catch (InstantiationException e) {
            log.error((Object)("Could not instantiate class for name: " + className), (Throwable)e);
            response.sendError(500, "Could not instantiate resourceloader class for name: " + className);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Could not access class for name: " + className), (Throwable)e);
            response.sendError(403, "Could not access resourceloader class for name: " + className);
        }
        catch (Throwable e) {
            log.error((Object)("Error while serving resource: " + resourceUri + ", message : " + e.getMessage()), e);
            response.sendError(500);
        }
    }

    protected Set getHeaderBeginInfos() {
        if (this.headerBeginInfo == null) {
            this.headerBeginInfo = new LinkedHashSet();
        }
        return this.headerBeginInfo;
    }

    protected Set getBodyEndInfos() {
        if (this.bodyEndInfo == null) {
            this.bodyEndInfo = new LinkedHashSet();
        }
        return this.bodyEndInfo;
    }

    protected Set getBodyOnloadInfos() {
        if (this.bodyOnloadInfo == null) {
            this.bodyOnloadInfo = new LinkedHashSet();
        }
        return this.bodyOnloadInfo;
    }

    private void addPositionedInfo(ResourcePosition position, PositionedInfo info) {
        if (HEADER_BEGIN.equals(position)) {
            Set set = this.getHeaderBeginInfos();
            set.add(info);
        } else if (BODY_END.equals(position)) {
            Set set = this.getBodyEndInfos();
            set.add(info);
        } else if (BODY_ONLOAD.equals(position)) {
            Set set = this.getBodyOnloadInfos();
            set.add(info);
        }
    }

    public boolean hasHeaderBeginInfos() {
        return this.headerBeginInfo != null;
    }

    public void parseResponse(HttpServletRequest request, String bufferedResponse, HttpServletResponse response) {
        this.originalResponse = new StringBuffer(bufferedResponse);
        ParseCallbackListener l = new ParseCallbackListener();
        ReducedHTMLParser.parse(this.originalResponse, l);
        this.headerInsertPosition = l.getHeaderInsertPosition();
        this.bodyInsertPosition = l.getBodyInsertPosition();
        this.beforeBodyPosition = l.getBeforeBodyPosition();
        this.afterBodyContentInsertPosition = l.getAfterBodyContentInsertPosition();
        this.beforeBodyEndPosition = l.getAfterBodyEndPosition() - 7;
        this.parserCalled = true;
    }

    public void writeMyFacesJavascriptBeforeBodyEnd(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.parserCalled) {
            throw new IOException("Method parseResponse has to be called first");
        }
        if (this.beforeBodyEndPosition >= 0) {
            String myFacesJavascript = (String)request.getAttribute("org.apache.myfaces.myFacesJavascript");
            if (myFacesJavascript != null) {
                this.originalResponse.insert(this.beforeBodyEndPosition, myFacesJavascript);
            } else {
                log.warn((Object)"MyFaces special javascript could not be retrieved from request-map.");
            }
        }
    }

    public void writeWithFullHeader(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Iterator i;
        HtmlBufferResponseWriterWrapper writerWrapper;
        if (!this.parserCalled) {
            throw new IOException("Method parseResponse has to be called first");
        }
        boolean addHeaderTags = false;
        if (this.headerInsertPosition == -1) {
            if (this.beforeBodyPosition != -1) {
                addHeaderTags = true;
                this.headerInsertPosition = this.beforeBodyPosition;
            } else {
                log.warn((Object)("Response has no <head> or <body> tag:\n" + this.originalResponse));
            }
        }
        HtmlResponseWriterImpl writer = new HtmlResponseWriterImpl(response.getWriter(), HtmlRendererUtils.selectContentType(request.getHeader("accept")), response.getCharacterEncoding());
        if (this.afterBodyContentInsertPosition >= 0) {
            writerWrapper = HtmlBufferResponseWriterWrapper.getInstance(writer);
            i = this.getBodyEndInfos().iterator();
            while (i.hasNext()) {
                writerWrapper.write("\n");
                PositionedInfo positionedInfo = (PositionedInfo)i.next();
                if (!(positionedInfo instanceof WritablePositionedInfo)) {
                    throw new IllegalStateException("positionedInfo of type : " + positionedInfo.getClass().getName());
                }
                ((WritablePositionedInfo)positionedInfo).writePositionedInfo(response, writerWrapper);
            }
            this.originalResponse.insert(this.headerInsertPosition, writerWrapper.toString());
        }
        if (this.bodyInsertPosition > 0) {
            StringBuffer buf = new StringBuffer();
            Set bodyInfos = this.getBodyOnloadInfos();
            if (bodyInfos.size() > 0) {
                int i2 = 0;
                Iterator it = this.getBodyOnloadInfos().iterator();
                while (it.hasNext()) {
                    AttributeInfo positionedInfo = (AttributeInfo)it.next();
                    if (i2 == 0) {
                        buf.append(positionedInfo.getAttributeName());
                        buf.append("=\"");
                    }
                    buf.append(positionedInfo.getAttributeValue());
                    ++i2;
                }
                buf.append("\"");
                this.originalResponse.insert(this.bodyInsertPosition - 1, " " + buf.toString());
            }
        }
        if (this.headerInsertPosition >= 0) {
            writerWrapper = HtmlBufferResponseWriterWrapper.getInstance(writer);
            if (addHeaderTags) {
                writerWrapper.write("<head>");
            }
            i = this.getHeaderBeginInfos().iterator();
            while (i.hasNext()) {
                writerWrapper.write("\n");
                PositionedInfo positionedInfo = (PositionedInfo)i.next();
                if (!(positionedInfo instanceof WritablePositionedInfo)) {
                    throw new IllegalStateException("positionedInfo of type : " + positionedInfo.getClass().getName());
                }
                ((WritablePositionedInfo)positionedInfo).writePositionedInfo(response, writerWrapper);
            }
            if (addHeaderTags) {
                writerWrapper.write("</head>");
            }
            this.originalResponse.insert(this.headerInsertPosition, writerWrapper.toString());
        }
    }

    public void writeResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HtmlResponseWriterImpl writer = new HtmlResponseWriterImpl(response.getWriter(), HtmlRendererUtils.selectContentType(request.getHeader("accept")), response.getCharacterEncoding());
        writer.write(this.originalResponse.toString());
    }

    private PositionedInfo getStyleInstance(FacesContext context, ResourceHandler resourceHandler) {
        return new StylePositionedInfo(this.getResourceUri(context, resourceHandler));
    }

    private PositionedInfo getScriptInstance(FacesContext context, ResourceHandler resourceHandler, boolean defer) {
        return new ScriptPositionedInfo(this.getResourceUri(context, resourceHandler), defer);
    }

    private PositionedInfo getScriptInstance(FacesContext context, ResourceHandler resourceHandler, boolean defer, boolean encodeURL) {
        return new ScriptPositionedInfo(this.getResourceUri(context, resourceHandler), defer, encodeURL);
    }

    private PositionedInfo getStyleInstance(FacesContext context, String uri) {
        return new StylePositionedInfo(this.getResourceUri(context, uri));
    }

    protected PositionedInfo getScriptInstance(FacesContext context, String uri, boolean defer) {
        return new ScriptPositionedInfo(this.getResourceUri(context, uri), defer);
    }

    private PositionedInfo getInlineScriptInstance(String inlineScript) {
        return new InlineScriptPositionedInfo(inlineScript);
    }

    private PositionedInfo getInlineStyleInstance(String inlineStyle) {
        return new InlineStylePositionedInfo(inlineStyle);
    }

    public boolean requiresBuffer() {
        return true;
    }

    public void responseStarted() {
    }

    public void responseFinished() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ParseCallbackListener
    implements CallbackListener {
        private int headerInsertPosition = -1;
        private int bodyInsertPosition = -1;
        private int beforeBodyPosition = -1;
        private int afterBodyContentInsertPosition = -1;
        private int afterBodyEndPosition = -1;

        public void openedStartTag(int charIndex, int tagIdentifier) {
            if (tagIdentifier == 0) {
                this.beforeBodyPosition = charIndex;
            }
        }

        public void closedStartTag(int charIndex, int tagIdentifier) {
            if (tagIdentifier == 1) {
                this.headerInsertPosition = charIndex;
            } else if (tagIdentifier == 0) {
                this.bodyInsertPosition = charIndex;
            }
        }

        public void openedEndTag(int charIndex, int tagIdentifier) {
            if (tagIdentifier == 0) {
                this.afterBodyContentInsertPosition = charIndex;
            }
        }

        public void closedEndTag(int charIndex, int tagIdentifier) {
            if (tagIdentifier == 0) {
                this.afterBodyEndPosition = charIndex;
            }
        }

        public void attribute(int charIndex, int tagIdentifier, String key, String value) {
        }

        public int getHeaderInsertPosition() {
            return this.headerInsertPosition;
        }

        public int getBodyInsertPosition() {
            return this.bodyInsertPosition;
        }

        public int getBeforeBodyPosition() {
            return this.beforeBodyPosition;
        }

        public int getAfterBodyContentInsertPosition() {
            return this.afterBodyContentInsertPosition;
        }

        public int getAfterBodyEndPosition() {
            return this.afterBodyEndPosition;
        }
    }

    private class InlineStylePositionedInfo
    extends InlinePositionedInfo {
        protected InlineStylePositionedInfo(String inlineStyle) {
            super(inlineStyle);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            writer.startElement("style", null);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.writeText((Object)this.getInlineValue(), null);
            writer.endElement("style");
        }
    }

    private class InlineScriptPositionedInfo
    extends InlinePositionedInfo {
        protected InlineScriptPositionedInfo(String inlineScript) {
            super(inlineScript);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeText((Object)this.getInlineValue(), null);
            writer.endElement("script");
        }
    }

    private abstract class InlinePositionedInfo
    implements WritablePositionedInfo {
        private final String _inlineValue;

        protected InlinePositionedInfo(String inlineValue) {
            this._inlineValue = inlineValue;
        }

        public String getInlineValue() {
            return this._inlineValue;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this._inlineValue).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof InlinePositionedInfo) {
                InlinePositionedInfo other = (InlinePositionedInfo)obj;
                return new EqualsBuilder().append((Object)this._inlineValue, (Object)other._inlineValue).isEquals();
            }
            return false;
        }
    }

    private class ScriptPositionedInfo
    extends AbstractResourceUri
    implements WritablePositionedInfo {
        protected final boolean _defer;
        protected final boolean _encode;

        public ScriptPositionedInfo(String resourceUri, boolean defer) {
            this(resourceUri, defer, true);
        }

        public ScriptPositionedInfo(String resourceUri, boolean defer, boolean encodeUrl) {
            super(resourceUri);
            this._defer = defer;
            this._encode = encodeUrl;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getResourceUri()).append(this._defer).append(this._encode).toHashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof ScriptPositionedInfo) {
                ScriptPositionedInfo other = (ScriptPositionedInfo)obj;
                return new EqualsBuilder().append(this._defer, other._defer).append(this._encode, other._encode).isEquals();
            }
            return false;
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            if (this._encode) {
                writer.writeAttribute("src", (Object)response.encodeURL(this.getResourceUri()), null);
            } else {
                writer.writeAttribute("src", (Object)this.getResourceUri(), null);
            }
            if (this._defer) {
                writer.writeAttribute("defer", (Object)"true", null);
            }
            writer.endElement("script");
        }
    }

    private class StylePositionedInfo
    extends AbstractResourceUri
    implements WritablePositionedInfo {
        protected StylePositionedInfo(String resourceUri) {
            super(resourceUri);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            writer.startElement("link", null);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("href", (Object)response.encodeURL(this.getResourceUri()), null);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.endElement("link");
        }
    }

    private abstract class AbstractResourceUri {
        protected final String _resourceUri;

        protected AbstractResourceUri(String resourceUri) {
            this._resourceUri = resourceUri;
        }

        public int hashCode() {
            return this._resourceUri.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof AbstractResourceUri) {
                AbstractResourceUri other = (AbstractResourceUri)obj;
                return this._resourceUri.equals(other._resourceUri);
            }
            return false;
        }

        protected String getResourceUri() {
            return this._resourceUri;
        }
    }

    protected static interface WritablePositionedInfo
    extends PositionedInfo {
        public void writePositionedInfo(HttpServletResponse var1, ResponseWriter var2) throws IOException;
    }

    protected static class AttributeInfo
    implements PositionedInfo {
        private String _attributeName;
        private String _attributeValue;

        protected AttributeInfo() {
        }

        public String getAttributeName() {
            return this._attributeName;
        }

        public void setAttributeName(String attributeName) {
            this._attributeName = attributeName;
        }

        public String getAttributeValue() {
            return this._attributeValue;
        }

        public void setAttributeValue(String attributeValue) {
            this._attributeValue = attributeValue;
        }
    }

    protected static interface PositionedInfo {
    }
}

