/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.facelets.tag;

import java.io.IOException;
import java.util.Collection;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.AjaxBehaviorListener;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.facelets.BehaviorConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.ajax4jsf.component.behavior.AjaxBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxHandler
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    private final TagAttribute event = this.getAttribute("event");
    private final TagAttribute execute = this.getAttribute("execute");
    private final TagAttribute render = this.getAttribute("render");
    private final TagAttribute disabled = this.getAttribute("disabled");
    private final TagAttribute immediate = this.getAttribute("immediate");
    private final TagAttribute listener = this.getAttribute("listener");
    private final TagAttribute limitRender = this.getAttribute("limitRender");
    private final TagAttribute queueId = this.getAttribute("queueId");
    private final TagAttribute statusId = this.getAttribute("status");
    private final TagAttribute similarityGroupingId = this.getAttribute("similarityGroupingId");
    private final TagAttribute onevent = this.getAttribute("onevent");
    private final TagAttribute onerror = this.getAttribute("onerror");
    private final TagAttribute onbegin = this.getAttribute("onbegin");
    private final TagAttribute oncomplete = this.getAttribute("oncomplete");
    private final TagAttribute onbeforedomupdate = this.getAttribute("onbeforedomupdate");
    private final boolean wrapping = this.isWrapping();

    public AjaxHandler(BehaviorConfig config) {
        super((TagConfig)config);
    }

    public void apply(FaceletContext fContext, UIComponent parent) throws IOException {
        String eventName = this.getEventName();
        if (this.wrapping) {
            this.nextHandler.apply(fContext, parent);
        } else {
            this.applyNested(fContext, parent, eventName);
        }
    }

    private void applyNested(FaceletContext ctx, UIComponent parent, String eventName) {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            throw new UnsupportedOperationException("This type of configuration is not supported!");
        }
        if (!(parent instanceof ClientBehaviorHolder)) {
            throw new TagException(this.tag, "Unable to attach <a4j:ajax> to non-ClientBehaviorHolder parent");
        }
        this.applyAttachedObject(ctx, parent, eventName);
    }

    public void applyAttachedObject(FaceletContext fContext, UIComponent parent, String eventName) {
        ClientBehaviorHolder bHolder = (ClientBehaviorHolder)parent;
        if (null == eventName) {
            eventName = bHolder.getDefaultEventName();
            if (null == eventName) {
                throw new TagException(this.tag, "Event attribute could not be determined: " + eventName);
            }
        } else {
            Collection eventNames = bHolder.getEventNames();
            if (!eventNames.contains(eventName)) {
                throw new TagException(this.tag, eventName + "event is not supported for the " + parent.getClass().getSimpleName());
            }
        }
        AjaxBehavior ajaxBehavior = this.createAjaxBehavior(fContext, eventName);
        bHolder.addClientBehavior(eventName, (ClientBehavior)ajaxBehavior);
    }

    public AjaxBehavior createAjaxBehavior(FaceletContext fContext, String eventName) {
        Application application = fContext.getFacesContext().getApplication();
        AjaxBehavior ajaxBehavior = (AjaxBehavior)application.createBehavior("org.ajax4jsf.behavior.Ajax");
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.disabled, Boolean.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.immediate, Boolean.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.execute, Object.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.render, Object.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.limitRender, Boolean.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.queueId, String.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.statusId, String.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.similarityGroupingId, String.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.onevent, String.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.onerror, String.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.onbegin, String.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.oncomplete, String.class);
        this.setBehaviorAttribute(fContext, ajaxBehavior, this.onbeforedomupdate, String.class);
        this.registerBehaviorListener(fContext, ajaxBehavior, this.listener);
        return ajaxBehavior;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        this.applyAttachedObject(ctx, parent, this.getEventName());
    }

    private void setBehaviorAttribute(FaceletContext ctx, AjaxBehavior behavior, TagAttribute attr, Class<?> type) {
        if (attr != null) {
            behavior.setValueExpression(attr.getLocalName(), attr.getValueExpression(ctx, type));
        }
    }

    public String getEventName() {
        return this.event != null ? this.event.getValue() : null;
    }

    public String getFor() {
        return null;
    }

    private boolean isWrapping() {
        return this.nextHandler instanceof TagHandler || this.nextHandler instanceof CompositeFaceletHandler;
    }

    public void registerBehaviorListener(FaceletContext fContext, AjaxBehavior behavior, TagAttribute listenerAttr) {
        if (listenerAttr != null) {
            MethodExpression mExpression = listenerAttr.getMethodExpression(fContext, Object.class, new Class[]{AjaxBehaviorEvent.class});
            behavior.addAjaxBehaviorListener(new AjaxBehaviorListenerImpl(mExpression));
        }
    }

    public class AjaxBehaviorListenerImpl
    implements AjaxBehaviorListener {
        private MethodExpression methodExpression;

        public AjaxBehaviorListenerImpl() {
        }

        public AjaxBehaviorListenerImpl(MethodExpression expression) {
            this.methodExpression = expression;
        }

        public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
            if (this.methodExpression != null) {
                ELContext elContext = FacesContext.getCurrentInstance().getELContext();
                try {
                    this.methodExpression.invoke(elContext, new Object[]{event});
                }
                catch (Exception e) {
                    throw new AbortProcessingException((Throwable)e);
                }
            }
        }
    }
}

