/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIMediaOutput;
import org.richfaces.resource.AbstractBaseResource;

public class MediaOutputResource
extends AbstractBaseResource
implements StateHolder {
    private Object userData;
    private MethodExpression contentProducer;
    private ValueExpression lastModifiedExpression;
    private ValueExpression expiresExpression;
    private ValueExpression timeToLiveExpression;

    public InputStream getInputStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.contentProducer.invoke(facesContext.getELContext(), new Object[]{baos, this.userData});
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.isCacheable(context) ? Boolean.TRUE : Boolean.FALSE, this.getContentType(), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.userData), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.contentProducer)};
        return state;
    }

    public void restoreState(FacesContext context, Object stateObject) {
        Object[] state = (Object[])stateObject;
        this.setCacheable((Boolean)state[0]);
        this.setContentType((String)state[1]);
        this.userData = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[2]);
        this.contentProducer = (MethodExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[3]);
    }

    public void initialize(UIMediaOutput uiMediaOutput) {
        this.setCacheable(uiMediaOutput.isCacheable());
        this.setContentType(uiMediaOutput.getMimeType());
        this.userData = uiMediaOutput.getValue();
        this.contentProducer = uiMediaOutput.getCreateContentExpression();
        this.lastModifiedExpression = uiMediaOutput.getValueExpression("lastModfied");
        this.expiresExpression = uiMediaOutput.getValueExpression("expires");
        this.timeToLiveExpression = uiMediaOutput.getValueExpression("timeToLive");
    }
}

