/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.ui;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jboss.seam.mail.MailSession;
import org.jboss.seam.mail.ui.MailComponent;
import org.jboss.seam.mail.ui.context.MailFacesContextImpl;
import org.jboss.seam.ui.JSF;

public class UIMessage
extends MailComponent {
    private MimeMessage mimeMessage;
    private Session session;
    private String importance;
    private String precedence;
    private Boolean requestReadReceipt;
    private String urlBase;
    private String charset;

    public Session getMailSession() {
        if (this.session == null) {
            this.session = this.getValue("session") != null ? (Session)this.getValue("session") : MailSession.instance();
        }
        return this.session;
    }

    public void setMailSession(Session session) {
        this.session = session;
    }

    public MimeMessage getMimeMessage() throws MessagingException {
        if (this.mimeMessage == null) {
            this.mimeMessage = new MimeMessage(this.getMailSession());
            MimeMultipart root = new MimeMultipart();
            this.mimeMessage.setContent((Multipart)root);
        }
        return this.mimeMessage;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.getUrlBase() != null) {
            MailFacesContextImpl.start(this.getUrlBase() + context.getExternalContext().getRequestContextPath());
        }
        this.mimeMessage = null;
        try {
            if ("high".equalsIgnoreCase(this.getImportance())) {
                this.getMimeMessage().addHeader("X-Prioity", "1");
                this.getMimeMessage().addHeader("Priority", "Urgent");
                this.getMimeMessage().addHeader("Importance", "high");
            } else if ("low".equalsIgnoreCase(this.getImportance())) {
                this.getMimeMessage().addHeader("X-Priority", "5");
                this.getMimeMessage().addHeader("Priority", "Non-urgent");
                this.getMimeMessage().addHeader("Importance", "low");
            }
            if (this.getPrecedence() != null) {
                this.getMimeMessage().addHeader("Precedence", this.getPrecedence());
            }
        }
        catch (MessagingException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public void encodeEnd(FacesContext ctx) throws IOException {
        try {
            if (this.isRequestReadReceipt() && this.getMimeMessage().getFrom() != null && this.getMimeMessage().getFrom().length == 1) {
                this.getMimeMessage().addHeader("Disposition-Notification-To", this.getMimeMessage().getFrom()[0].toString());
            }
            this.getMimeMessage().saveChanges();
            Transport transport = this.getMailSession().getTransport();
            transport.connect();
            transport.sendMessage((Message)this.getMimeMessage(), this.getMimeMessage().getAllRecipients());
            transport.close();
        }
        catch (MessagingException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        finally {
            MailFacesContextImpl.stop();
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        JSF.renderChildren((FacesContext)FacesContext.getCurrentInstance(), (UIComponent)this);
    }

    public String getImportance() {
        if (this.importance == null) {
            return this.getString("importance");
        }
        return this.importance;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getPrecedence() {
        if (this.precedence == null) {
            return this.getString("precedence");
        }
        return this.precedence;
    }

    public void setPrecedence(String precedence) {
        this.precedence = precedence;
    }

    public boolean isRequestReadReceipt() {
        if (this.requestReadReceipt == null) {
            return this.getBoolean("requestReadReceipt") == null ? false : this.getBoolean("requestReadReceipt");
        }
        return this.requestReadReceipt;
    }

    public void setRequestReadReceipt(boolean requestReadReceipt) {
        this.requestReadReceipt = requestReadReceipt;
    }

    public String getUrlBase() {
        if (this.urlBase == null) {
            return this.urlBase;
        }
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public String getCharset() {
        if (this.charset != null) {
            return this.charset;
        }
        if (this.getString("charset") != null) {
            return this.getString("charset");
        }
        return FacesContext.getCurrentInstance().getResponseWriter().getCharacterEncoding();
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public static class Importance {
        public static final String LOW = "low";
        public static final String NORMAL = "normal";
        public static final String HIGH = "high";
    }
}

