/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.SOAPMessageAbstraction;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPElementWriter;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.core.soap.SOAPMessageDispatcher;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.jboss.ws.core.soap.attachment.AttachmentPartImpl;
import org.jboss.ws.core.soap.attachment.CIDGenerator;
import org.jboss.ws.core.soap.attachment.MultipartRelatedEncoder;
import org.jboss.ws.core.soap.attachment.MultipartRelatedSwAEncoder;
import org.jboss.ws.core.soap.attachment.MultipartRelatedXOPEncoder;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageImpl
extends SOAPMessage
implements SOAPMessageAbstraction {
    private boolean saveRequired = true;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private List<AttachmentPart> attachments = new LinkedList<AttachmentPart>();
    private CIDGenerator cidGenerator = new CIDGenerator();
    private boolean isXOPMessage;
    private boolean isSWARefMessage;
    private SOAPPartImpl soapPart = new SOAPPartImpl(this);
    private MultipartRelatedEncoder multipartRelatedEncoder;
    private OperationMetaData opMetaData;

    SOAPMessageImpl() throws SOAPException {
        this.setProperty("javax.xml.soap.character-set-encoding", "UTF-8");
        this.setProperty("javax.xml.soap.write-xml-declaration", false);
    }

    public CIDGenerator getCidGenerator() {
        return this.cidGenerator;
    }

    public boolean isXOPMessage() {
        return this.isXOPMessage;
    }

    public void setXOPMessage(boolean isXOPMessage) {
        this.isXOPMessage = isXOPMessage;
    }

    public boolean isSWARefMessage() {
        return this.isSWARefMessage;
    }

    public void setSWARefMessage(boolean isSWAMessage) {
        this.isSWARefMessage = isSWAMessage;
    }

    public void setAttachments(Collection<AttachmentPart> parts) throws SOAPException {
        for (AttachmentPart part : parts) {
            this.attachments.add(part);
        }
        this.saveRequired = true;
    }

    @Override
    public void addAttachmentPart(AttachmentPart part) {
        if (part == null) {
            return;
        }
        this.attachments.add(part);
        this.saveRequired = true;
    }

    public AttachmentPart getAttachmentByContentId(String cid) throws SOAPException {
        for (AttachmentPart part : this.attachments) {
            String contentId = part.getContentId();
            if (!contentId.equals(cid)) continue;
            return part;
        }
        return null;
    }

    public AttachmentPart removeAttachmentByContentId(String cid) {
        for (AttachmentPart part : this.attachments) {
            String contentId = part.getContentId();
            if (!contentId.equals(cid)) continue;
            this.attachments.remove(part);
            return part;
        }
        return null;
    }

    public AttachmentPart getAttachmentByPartName(String partName) {
        for (AttachmentPart part : this.attachments) {
            String contentId = part.getContentId();
            if (!contentId.startsWith("<" + partName + "=")) continue;
            return part;
        }
        return null;
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public String getContentDescription() {
        String[] value = this.mimeHeaders.getHeader("Content-Description");
        return value == null ? null : value[0];
    }

    public void setContentDescription(String description) {
        this.mimeHeaders.setHeader("Content-Description", description);
    }

    @Override
    public MimeHeaders getMimeHeaders() {
        return this.mimeHeaders;
    }

    public void setMimeHeaders(MimeHeaders headers) {
        if (headers == null) {
            throw new IllegalArgumentException("MimeHeaders cannot be null");
        }
        this.mimeHeaders = headers;
    }

    public SOAPPart getSOAPPart() {
        return this.soapPart;
    }

    public void removeAllAttachments() {
        this.attachments.clear();
        this.saveRequired = true;
    }

    public int countAttachments() {
        return this.attachments.size();
    }

    public Iterator getAttachments() {
        this.saveRequired = true;
        return this.attachments.iterator();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        if (headers == null) {
            throw new WSException("MimeHeaders can not be null");
        }
        return new MimeMatchingAttachmentsIterator(headers, this.attachments);
    }

    private String getSOAPContentType() throws SOAPException {
        SOAPEnvelope env;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null && "http://www.w3.org/2003/05/soap/bindings/HTTP/".equalsIgnoreCase(msgContext.getEndpointMetaData().getBindingId())) {
            return "application/soap+xml";
        }
        SOAPEnvelope sOAPEnvelope = env = this.soapPart != null ? this.soapPart.getEnvelope() : null;
        if (env != null && "http://www.w3.org/2003/05/soap-envelope".equals(env.getNamespaceURI())) {
            return "application/soap+xml";
        }
        return "text/xml";
    }

    public void saveChanges() throws SOAPException {
        CommonMessageContext msgContext;
        if (this.saveRequired) {
            try {
                boolean hasAttachments;
                boolean bl = hasAttachments = this.attachments.size() > 0;
                if (this.isXOPMessage() && !XOPContext.isMTOMEnabled() && hasAttachments) {
                    throw new IllegalStateException("XOP parameter not properly inlined");
                }
                String contentType = this.getSOAPContentType() + "; charset=" + this.getCharSetEncoding();
                if (hasAttachments) {
                    if (this.isXOPMessage() && XOPContext.isMTOMEnabled()) {
                        this.multipartRelatedEncoder = new MultipartRelatedXOPEncoder(this);
                        this.multipartRelatedEncoder.encodeMultipartRelatedMessage();
                        contentType = this.multipartRelatedEncoder.getContentType();
                    } else {
                        this.multipartRelatedEncoder = new MultipartRelatedSwAEncoder(this);
                        this.multipartRelatedEncoder.encodeMultipartRelatedMessage();
                        contentType = this.multipartRelatedEncoder.getContentType();
                    }
                }
                this.mimeHeaders.setHeader("Content-Type", contentType);
            }
            catch (MessagingException ex) {
                throw new SOAPException((Throwable)ex);
            }
            this.saveRequired = false;
        }
        if ((msgContext = MessageContextAssociation.peekMessageContext()) != null) {
            msgContext.setModified(true);
        }
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    @Override
    public void writeTo(OutputStream outs) throws IOException {
        try {
            this.saveChanges();
            if (this.attachments.size() > 0) {
                this.multipartRelatedEncoder.writeTo(outs);
            } else {
                SOAPEnvelope soapEnv = this.getSOAPPart().getEnvelope();
                if (soapEnv != null) {
                    boolean writeXML = this.isWriteXMLDeclaration();
                    String charsetEncoding = this.getCharSetEncoding();
                    SOAPElementWriter writer = new SOAPElementWriter(outs, charsetEncoding);
                    writer.setWriteXMLDeclaration(writeXML).writeElement((SOAPEnvelopeImpl)soapEnv);
                }
            }
        }
        catch (SOAPException ex) {
            WSException.rethrow(ex);
        }
    }

    private String getCharSetEncoding() throws SOAPException {
        String charsetName = (String)this.getProperty("javax.xml.soap.character-set-encoding");
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        return charsetName;
    }

    public OperationMetaData getOperationMetaData(EndpointMetaData epMetaData) throws SOAPException {
        if (this.opMetaData == null) {
            SOAPMessageDispatcher dispatcher = new SOAPMessageDispatcher();
            this.opMetaData = dispatcher.getDispatchDestination(epMetaData, this);
        }
        return this.opMetaData;
    }

    @Override
    public boolean isFaultMessage() {
        SOAPFault soapFault = null;
        try {
            soapFault = this.getSOAPBody().getFault();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return soapFault != null;
    }

    private boolean isWriteXMLDeclaration() throws SOAPException {
        Boolean booleanValue = new Boolean(false);
        Object propValue = this.getProperty("javax.xml.soap.write-xml-declaration");
        if (propValue instanceof Boolean) {
            booleanValue = (Boolean)propValue;
        }
        if (propValue instanceof String) {
            booleanValue = new Boolean((String)propValue);
        }
        return booleanValue;
    }

    public AttachmentPart getAttachment(SOAPElement element) throws SOAPException {
        String ref = element.getAttribute("href");
        if (ref.length() == 0 && ((ref = element.getValue()) == null || ref.length() == 0)) {
            return null;
        }
        return this.getAttachmentByRef(ref);
    }

    private AttachmentPart getAttachmentByRef(String ref) throws SOAPException {
        AttachmentPart attachment;
        if (ref.startsWith("cid:")) {
            String cid = '<' + ref.substring("cid:".length()) + '>';
            attachment = this.getAttachmentByContentId(cid);
        } else {
            attachment = this.getAttachmentByContentLocation(ref);
        }
        if (attachment == null) {
            attachment = this.getAttachmentByPartName(ref);
        }
        return attachment;
    }

    private AttachmentPart getAttachmentByContentLocation(String location) {
        for (AttachmentPart attachment : this.attachments) {
            if (!location.equals(attachment.getContentLocation())) continue;
            return attachment;
        }
        return null;
    }

    public void removeAttachments(MimeHeaders headers) {
        MimeMatchingAttachmentsIterator attachmentItr = new MimeMatchingAttachmentsIterator(headers, this.attachments);
        while (attachmentItr.next() != null) {
            attachmentItr.remove();
        }
    }

    public static class MimeMatchingAttachmentsIterator
    implements Iterator {
        private Iterator iterator;
        private MimeHeaders headers = new MimeHeaders();
        private AttachmentPart lastMatch;

        public MimeMatchingAttachmentsIterator(MimeHeaders headers, List attachments) {
            this.iterator = attachments.iterator();
            if (headers != null) {
                this.headers = headers;
            }
        }

        private boolean containsAllHeaders(Iterator headerIterator, AttachmentPart part) {
            while (headerIterator.hasNext()) {
                MimeHeader header = (MimeHeader)headerIterator.next();
                String[] values = part.getMimeHeader(header.getName());
                if (values == null) {
                    return false;
                }
                boolean match = false;
                for (int j = 0; j < values.length; ++j) {
                    if (!values[j].equalsIgnoreCase(header.getValue())) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            return true;
        }

        private void nextMatch() {
            while (this.iterator.hasNext()) {
                AttachmentPart part = (AttachmentPart)this.iterator.next();
                if (!this.containsAllHeaders(this.headers.getAllHeaders(), part)) continue;
                this.lastMatch = part;
                break;
            }
        }

        public boolean hasNext() {
            if (this.lastMatch == null) {
                this.nextMatch();
            }
            return this.lastMatch != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            AttachmentPart retval = this.lastMatch;
            this.lastMatch = null;
            return retval;
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

