/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import javax.xml.ws.WebServiceFeature;
import org.jboss.ws.WSException;
import org.jboss.ws.annotation.FastInfoset;
import org.jboss.ws.annotation.JsonEncoding;
import org.jboss.ws.annotation.SchemaValidation;
import org.jboss.ws.feature.FastInfosetFeature;
import org.jboss.ws.feature.JsonEncodingFeature;
import org.jboss.ws.feature.SchemaValidationFeature;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointFeatureProcessor {
    protected void processEndpointFeatures(Deployment dep, ServerEndpointMetaData sepMetaData, Class<?> sepClass) {
        for (Annotation an : sepClass.getAnnotations()) {
            WebServiceFeature feature;
            Annotation anFeature;
            if (an.annotationType() == SchemaValidation.class) {
                this.processSchemaValidation(dep, sepMetaData, sepClass);
                continue;
            }
            if (an.annotationType() == FastInfoset.class) {
                anFeature = sepClass.getAnnotation(FastInfoset.class);
                feature = new FastInfosetFeature(anFeature.enabled());
                sepMetaData.addFeature(feature);
                continue;
            }
            if (an.annotationType() != JsonEncoding.class) continue;
            anFeature = sepClass.getAnnotation(JsonEncoding.class);
            feature = new JsonEncodingFeature(anFeature.enabled());
            sepMetaData.addFeature(feature);
        }
    }

    private void processSchemaValidation(Deployment dep, ServerEndpointMetaData sepMetaData, Class<?> sepClass) {
        Class handlerClass;
        SchemaValidation anFeature = sepClass.getAnnotation(SchemaValidation.class);
        SchemaValidationFeature feature = new SchemaValidationFeature(anFeature.enabled());
        String xsdLoc = anFeature.schemaLocation();
        if (xsdLoc.length() > 0) {
            if (dep instanceof ArchiveDeployment) {
                try {
                    URL xsdURL = ((ArchiveDeployment)dep).getMetaDataFileURL(xsdLoc);
                    xsdLoc = xsdURL.toExternalForm();
                }
                catch (IOException ex) {
                    throw new WSException("Cannot load schema: " + xsdLoc, ex);
                }
            }
            feature.setSchemaLocation(xsdLoc);
        }
        if ((handlerClass = anFeature.errorHandler()) != null) {
            try {
                ErrorHandler errorHandler = (ErrorHandler)handlerClass.newInstance();
                feature.setErrorHandler(errorHandler);
            }
            catch (Exception ex) {
                throw new WSException("Cannot instanciate error handler: " + handlerClass, ex);
            }
        }
        sepMetaData.addFeature(feature);
    }
}

