/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.ajax4jsf.renderkit.HeaderResourceProducer;
import org.ajax4jsf.renderkit.UserResourceRenderer;

public class ViewResources {
    LinkedHashSet scripts = new LinkedHashSet();
    LinkedHashSet styles = new LinkedHashSet();
    LinkedHashSet userScripts = new LinkedHashSet();
    LinkedHashSet userStyles = new LinkedHashSet();
    boolean processStyles = true;
    boolean processScripts = true;
    RenderKit renderKit = null;

    public void collect(FacesContext context) {
        UIViewRoot root = context.getViewRoot();
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.renderKit = rkFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        this.processHeadResources(context, (UIComponent)root);
        this.scripts.addAll(this.userScripts);
    }

    private void processHeadResources(FacesContext context, UIComponent root) {
        UIComponent child;
        Renderer renderer = this.getRenderer(context, root);
        if (null != renderer) {
            LinkedHashSet set;
            HeaderResourceProducer producer;
            if ((this.processScripts || this.processStyles) && renderer instanceof HeaderResourceProducer) {
                producer = (HeaderResourceProducer)renderer;
                if (this.processScripts && null != (set = producer.getHeaderScripts(context, root))) {
                    this.scripts.addAll(set);
                }
                if (this.processStyles && null != (set = producer.getHeaderStyles(context, root))) {
                    this.styles.addAll(set);
                }
            } else if (renderer instanceof UserResourceRenderer) {
                producer = (UserResourceRenderer)renderer;
                set = producer.getHeaderScripts(context, root);
                if (null != set) {
                    this.userScripts.addAll(set);
                }
                if (null != (set = producer.getHeaderStyles(context, root))) {
                    this.userStyles.addAll(set);
                }
            }
        }
        Iterator<Object> iter = root.getFacets().values().iterator();
        while (iter.hasNext()) {
            child = (UIComponent)iter.next();
            this.processHeadResources(context, child);
        }
        iter = root.getChildren().iterator();
        while (iter.hasNext()) {
            child = (UIComponent)iter.next();
            this.processHeadResources(context, child);
        }
    }

    private Renderer getRenderer(FacesContext context, UIComponent comp) {
        String rendererType = comp.getRendererType();
        if (rendererType != null) {
            return this.renderKit.getRenderer(comp.getFamily(), rendererType);
        }
        return null;
    }

    public boolean isProcessStyles() {
        return this.processStyles;
    }

    public void setProcessStyles(boolean processStyles) {
        this.processStyles = processStyles;
    }

    public boolean isProcessScripts() {
        return this.processScripts;
    }

    public void setProcessScripts(boolean processScripts) {
        this.processScripts = processScripts;
    }

    public Set getScripts() {
        return this.scripts;
    }

    public Set getStyles() {
        return this.styles;
    }

    public Set getUserStyles() {
        return this.userStyles;
    }

    public void addScript(String scriptUrl) {
        this.scripts.add(scriptUrl);
    }

    public void addStyle(String styleUrl) {
        this.styles.add(styleUrl);
    }
}

