/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.ajax4jsf.resource.ImageRenderer;
import org.ajax4jsf.resource.ResourceContext;

public class Png8Renderer
extends ImageRenderer {
    public static IndexColorModel webColorModel;

    public void sendImage(ResourceContext context, RenderedImage image) throws IOException {
        OutputStream outputStream = context.getOutputStream();
        try {
            ImageIO.write(image, "png", outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int getImageType() {
        return 13;
    }

    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, this.getImageType(), webColorModel);
    }

    public String getContentType() {
        return "image/png";
    }

    static {
        byte[] webLevels = new byte[]{0, 51, 102, -103, -52, -1};
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        b[0] = 0;
        g[0] = 0;
        r[0] = 0;
        for (int i = 0; i < webLevels.length; ++i) {
            for (int j = 0; j < webLevels.length; ++j) {
                for (int k = 0; k < webLevels.length; ++k) {
                    int colorNum = i * webLevels.length * webLevels.length + j * webLevels.length + k + 1;
                    r[colorNum] = webLevels[i];
                    g[colorNum] = webLevels[j];
                    b[colorNum] = webLevels[k];
                }
            }
        }
        webColorModel = new IndexColorModel(8, webLevels.length * webLevels.length * webLevels.length + 1, r, g, b, 0);
    }
}

