/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class EJBMethodPermission
extends Permission
implements Serializable {
    private static final long serialVersionID = 141000L;
    private String methodName;
    private String methodInterface;
    private String methodSig;

    public EJBMethodPermission(String name, String actions) {
        super(name);
        this.parseMethodSpec(actions);
    }

    public EJBMethodPermission(String ejbName, String methodInterface, Method method) {
        this(ejbName, method.getName(), methodInterface, EJBMethodPermission.convertParameters(method.getParameterTypes()));
    }

    public EJBMethodPermission(String ejbName, String methodName, String methodInterface, String[] methodParams) {
        super(ejbName);
        this.methodInterface = methodInterface;
        this.methodName = methodName;
        if (methodParams == null) {
            this.methodSig = null;
        } else {
            StringBuffer tmp = new StringBuffer();
            int n = 0;
            while (n < methodParams.length) {
                tmp.append(methodParams[n]);
                tmp.append(',');
                ++n;
            }
            if (tmp.length() > 0) {
                tmp.setLength(tmp.length() - 1);
            }
            this.methodSig = tmp.toString();
        }
    }

    public boolean equals(Object p) {
        boolean equals = false;
        if (p == null || !(p instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission perm = (EJBMethodPermission)p;
        equals = this.getName().equals(perm.getName());
        if (equals) {
            if (this.methodName != null) {
                if (perm.methodName == null) {
                    return false;
                }
                if (!this.methodName.equals(perm.methodName)) {
                    return false;
                }
            } else if (perm.methodName != null) {
                return false;
            }
            boolean bl = equals = this.methodInterface != perm.methodInterface;
            if (!equals && this.methodInterface != null) {
                equals = this.methodInterface.equals(perm.methodInterface);
            }
            if (!equals) {
                return false;
            }
            equals = this.methodSig != null ? perm.methodSig != null && this.methodSig.equals(perm.methodSig) : perm.methodSig == null;
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.methodName != null) {
            hashCode += this.methodName.hashCode();
        }
        if (this.methodInterface != null) {
            hashCode += this.methodInterface.hashCode();
        }
        if (this.methodSig != null) {
            hashCode += this.methodSig.hashCode();
        }
        return hashCode;
    }

    public String getActions() {
        StringBuffer actions = new StringBuffer();
        if (this.methodName != null) {
            actions.append(this.methodName);
        }
        if (this.methodInterface != null) {
            actions.append(',');
            actions.append(this.methodInterface);
        } else if (this.methodSig != null) {
            actions.append(',');
        }
        if (this.methodSig != null) {
            actions.append(',');
            actions.append(this.methodSig);
        }
        String methodSpec = null;
        if (actions.length() > 0) {
            methodSpec = actions.toString();
        }
        return methodSpec;
    }

    public boolean implies(Permission p) {
        boolean implies = false;
        if (p == null || !(p instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission perm = (EJBMethodPermission)p;
        implies = this.getName().equals(perm.getName());
        if (!implies) {
            return false;
        }
        if (this.methodName != null) {
            implies = this.methodName.equals(perm.methodName);
        }
        if (implies && this.methodInterface != null) {
            implies = this.methodInterface.equals(perm.methodInterface);
        }
        if (implies && this.methodSig != null) {
            implies = this.methodSig.equals(perm.methodSig);
        }
        return implies;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        if (this.methodInterface != null) {
            tmp.append(this.methodInterface);
            tmp.append(':');
        }
        if (this.methodName != null) {
            tmp.append(this.methodName);
        }
        tmp.append('(');
        if (this.methodSig != null) {
            tmp.append(this.methodSig);
        }
        tmp.append(')');
        return tmp.toString();
    }

    private static String[] convertParameters(Class[] params) {
        ArrayList<String> tmp = new ArrayList<String>();
        int p = 0;
        while (p < params.length) {
            Class c = params[p];
            if (c.isArray()) {
                StringBuffer sb = new StringBuffer();
                Class<?> subType = c.getComponentType();
                sb.append(subType.getName());
                while (subType != null) {
                    sb.append("[]");
                    subType = subType.getComponentType();
                }
                tmp.add(sb.toString());
            } else {
                tmp.add(c.getName());
            }
            ++p;
        }
        String[] sig = new String[tmp.size()];
        tmp.toArray(sig);
        return sig;
    }

    private void parseMethodSpec(String methodSpec) {
        this.methodName = null;
        this.methodInterface = null;
        this.methodSig = null;
        if (methodSpec != null) {
            StringTokenizer tokenizer = new StringTokenizer(methodSpec, ",", true);
            if (tokenizer.hasMoreTokens()) {
                this.methodName = tokenizer.nextToken();
                if (this.methodName.equals(",")) {
                    this.methodName = null;
                }
            }
            if (tokenizer.hasMoreTokens()) {
                this.methodInterface = tokenizer.nextToken();
                if (this.methodName != null && this.methodInterface.equals(",")) {
                    this.methodInterface = tokenizer.nextToken();
                }
                if (this.methodInterface.equals(",")) {
                    this.methodInterface = null;
                    this.methodSig = "";
                }
            }
            if (tokenizer.hasMoreTokens()) {
                if (this.methodInterface != null) {
                    tokenizer.nextToken();
                }
                StringBuffer tmp = new StringBuffer();
                while (tokenizer.hasMoreTokens()) {
                    tmp.append(tokenizer.nextToken());
                }
                this.methodSig = tmp.toString();
            }
        }
    }
}

