/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.renderkit.RenderKitUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.BitSet;

public class HtmlUtils {
    private static final char[] AMP_CHARS;
    private static final int MAX_BYTES_PER_CHAR = 10;
    private static final BitSet DONT_ENCODE_SET;
    private static String[] sISO8859_1_Entities;
    private static char _LAST_EMPTY_ELEMENT_START;
    private static String[][] emptyElementArr;
    private static String[] aNames;
    private static String[] bNames;
    private static String[] cNames;
    private static String[] fNames;
    private static String[] hNames;
    private static String[] iNames;
    private static String[] lNames;
    private static String[] mNames;
    private static String[] pNames;

    public static void writeText(Writer out, char[] buffer, char[] text) throws IOException {
        HtmlUtils.writeText(out, buffer, text, 0, text.length);
    }

    public static void writeText(Writer out, char[] buff, char[] text, int start, int length) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '<') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                        continue;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    out.write("&amp;");
                    continue;
                }
                buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(sISO8859_1_Entities[ch - 160]);
                out.write(59);
                continue;
            }
            buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
            HtmlUtils._writeDecRef(out, ch);
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    public static void writeText(Writer out, char[] buff, String text) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '<') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                        continue;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    out.write("&amp;");
                    continue;
                }
                buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(sISO8859_1_Entities[ch - 160]);
                out.write(59);
                continue;
            }
            buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
            HtmlUtils._writeDecRef(out, ch);
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    public static void writeAttribute(Writer out, char[] buff, String text) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '<') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                        continue;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    if (i + 1 < length && text.charAt(i + 1) == '{') {
                        out.write(ch);
                        continue;
                    }
                    out.write("&amp;");
                    continue;
                }
                if (ch == '\"') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    out.write("&quot;");
                    continue;
                }
                buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(sISO8859_1_Entities[ch - 160]);
                out.write(59);
                continue;
            }
            buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
            HtmlUtils._writeDecRef(out, ch);
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    public static void writeAttribute(Writer out, char[] buffer, char[] text) throws IOException {
        HtmlUtils.writeAttribute(out, buffer, text, 0, text.length);
    }

    public static void writeAttribute(Writer out, char[] buff, char[] text, int start, int length) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '<') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                        continue;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    if (i + 1 < end && text[i + 1] == '{') {
                        out.write(ch);
                        continue;
                    }
                    out.write("&amp;");
                    continue;
                }
                if (ch == '\"') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    out.write("&quot;");
                    continue;
                }
                buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(sISO8859_1_Entities[ch - 160]);
                out.write(59);
                continue;
            }
            buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
            HtmlUtils._writeDecRef(out, ch);
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    private static void _writeDecRef(Writer out, char ch) throws IOException {
        if (ch == 8364) {
            out.write("&euro;");
            return;
        }
        out.write("&#");
        int i = ch;
        if (i > 10000) {
            out.write(48 + i / 10000);
            out.write(48 + (i %= 10000) / 1000);
            out.write(48 + (i %= 1000) / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        } else if (i > 1000) {
            out.write(48 + i / 1000);
            out.write(48 + (i %= 1000) / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        } else {
            out.write(48 + i / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        }
        out.write(59);
    }

    private static int addToBuffer(Writer out, char[] buffer, int bufferIndex, int bufferLength, char ch) throws IOException {
        if (bufferIndex >= bufferLength) {
            out.write(buffer, 0, bufferIndex);
            bufferIndex = 0;
        }
        buffer[bufferIndex] = ch;
        return bufferIndex + 1;
    }

    private static int flushBuffer(Writer out, char[] buffer, int bufferIndex) throws IOException {
        if (bufferIndex > 0) {
            out.write(buffer, 0, bufferIndex);
        }
        return 0;
    }

    private HtmlUtils() {
    }

    public static void writeURL(Writer out, String text, String queryEncoding, String contentType) throws IOException, UnsupportedEncodingException {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '!' || ch > '~') {
                if (ch == ' ') {
                    out.write(43);
                    continue;
                }
                HtmlUtils.writeURIDoubleHex(out, ch);
                continue;
            }
            if (ch == '\"') {
                out.write("%22");
                continue;
            }
            if (ch == '?') {
                out.write(63);
                HtmlUtils.encodeURIString(out, text, queryEncoding, RenderKitUtils.isXml(contentType), i + 1);
                return;
            }
            out.write(ch);
        }
    }

    private static void encodeURIString(Writer out, String text, String encoding, boolean isXml, int start) throws IOException {
        MyByteArrayOutputStream buf = null;
        OutputStreamWriter writer = null;
        char[] charArray = null;
        int length = text.length();
        for (int i = start; i < length; ++i) {
            char ch = text.charAt(i);
            if (DONT_ENCODE_SET.get(ch)) {
                if (isXml && ch == '&') {
                    if (i + 1 < length && HtmlUtils.isAmpEscaped(text, i + 1)) {
                        out.write(ch);
                        continue;
                    }
                    out.write(AMP_CHARS);
                    continue;
                }
                out.write(ch);
                continue;
            }
            if (buf == null) {
                buf = new MyByteArrayOutputStream(10);
                writer = encoding != null ? new OutputStreamWriter((OutputStream)buf, encoding) : new OutputStreamWriter(buf);
                charArray = new char[1];
            }
            try {
                charArray[0] = ch;
                writer.write(charArray, 0, 1);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.getBuf();
            int size = buf.size();
            for (int j = 0; j < size; ++j) {
                HtmlUtils.writeURIDoubleHex(out, ba[j] + 256);
            }
            buf.reset();
        }
    }

    private static boolean isAmpEscaped(String text, int idx) {
        int i = 1;
        int ix = idx;
        while (i < AMP_CHARS.length) {
            if (text.charAt(ix) != AMP_CHARS[i]) {
                return false;
            }
            ++i;
            ++ix;
        }
        return true;
    }

    private static void writeURIDoubleHex(Writer out, int i) throws IOException {
        out.write(37);
        out.write(HtmlUtils.intToHex((i >> 4) % 16));
        out.write(HtmlUtils.intToHex(i % 16));
    }

    private static char intToHex(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(65 + (i - 10));
    }

    public static boolean validateEncoding(String encoding) {
        return Charset.isSupported(encoding);
    }

    public static boolean isEmptyElement(String name) {
        char firstChar = name.charAt(0);
        if (firstChar > _LAST_EMPTY_ELEMENT_START) {
            return false;
        }
        String[] array = emptyElementArr[name.charAt(0)];
        if (array != null) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!name.equalsIgnoreCase(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    static {
        int i;
        AMP_CHARS = "&amp;".toCharArray();
        DONT_ENCODE_SET = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        DONT_ENCODE_SET.set(37);
        DONT_ENCODE_SET.set(43);
        DONT_ENCODE_SET.set(35);
        DONT_ENCODE_SET.set(38);
        DONT_ENCODE_SET.set(61);
        DONT_ENCODE_SET.set(45);
        DONT_ENCODE_SET.set(95);
        DONT_ENCODE_SET.set(46);
        DONT_ENCODE_SET.set(42);
        DONT_ENCODE_SET.set(126);
        DONT_ENCODE_SET.set(47);
        DONT_ENCODE_SET.set(39);
        DONT_ENCODE_SET.set(33);
        DONT_ENCODE_SET.set(40);
        DONT_ENCODE_SET.set(41);
        DONT_ENCODE_SET.set(59);
        sISO8859_1_Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
        _LAST_EMPTY_ELEMENT_START = (char)112;
        emptyElementArr = new String[_LAST_EMPTY_ELEMENT_START + '\u0001'][];
        aNames = new String[]{"area"};
        bNames = new String[]{"br", "base", "basefont"};
        cNames = new String[]{"col"};
        fNames = new String[]{"frame"};
        hNames = new String[]{"hr"};
        iNames = new String[]{"img", "input", "isindex"};
        lNames = new String[]{"link"};
        mNames = new String[]{"meta"};
        pNames = new String[]{"param"};
        HtmlUtils.emptyElementArr[97] = aNames;
        HtmlUtils.emptyElementArr[65] = aNames;
        HtmlUtils.emptyElementArr[98] = bNames;
        HtmlUtils.emptyElementArr[66] = bNames;
        HtmlUtils.emptyElementArr[99] = cNames;
        HtmlUtils.emptyElementArr[67] = cNames;
        HtmlUtils.emptyElementArr[102] = fNames;
        HtmlUtils.emptyElementArr[70] = fNames;
        HtmlUtils.emptyElementArr[104] = hNames;
        HtmlUtils.emptyElementArr[72] = hNames;
        HtmlUtils.emptyElementArr[105] = iNames;
        HtmlUtils.emptyElementArr[73] = iNames;
        HtmlUtils.emptyElementArr[108] = lNames;
        HtmlUtils.emptyElementArr[76] = lNames;
        HtmlUtils.emptyElementArr[109] = mNames;
        HtmlUtils.emptyElementArr[77] = mNames;
        HtmlUtils.emptyElementArr[112] = pNames;
        HtmlUtils.emptyElementArr[80] = pNames;
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MyByteArrayOutputStream(int initialCapacity) {
            super(initialCapacity);
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

