Object.extend(Event, {
	_domReady : function() {
		var domReady = arguments.callee
		if (!domReady.done) {
			domReady.done = true;
	
			Event._readyCallbacks.each(function(f) { f() });
			Event._readyCallbacks = null;

			if (Event._timer) {
				clearInterval(Event._timer);
			}
	
			/*if (document.removeEventListener) {
				document.removeEventListener("DOMContentLoaded", domReady, false);
			}*/
	
			Event.stopObserving(window, 'load', domReady);
		}
	},
   
   onReady : function(f) {
       var domReady = this._domReady;
       if (domReady.done) {
    	   return f();
       }

       if (!this._readyCallbacks) {
           
           this._readyCallbacks = [];

           /*if (document.addEventListener) {
        	   document.addEventListener("DOMContentLoaded", domReady, false);
           }*/
           
           //if (/WebKit/i.test(navigator.userAgent)) {
               this._timer = setInterval(function() {
                   if (/loaded|complete/.test(document.readyState)) domReady();
               }, 10);
           //}
           
           this.observe(window, 'load', domReady);
       }
       
       this._readyCallbacks.push(f);
   }
}); 

Array.prototype.remove = function(object) {
	var index = this.indexOf(object, 0, this.length);
	if (index == -1) return;
	if (index == 0) {
		this.shift();
	} else {
		this.splice(index, 1);
	}
}
