/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf.core;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public final class ActionListenerHandler
extends TagHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;

    public ActionListenerHandler(TagConfig config) {
        super(config);
        TagAttribute type = this.getAttribute("type");
        if (type != null) {
            if (!type.isLiteral()) {
                throw new TagAttributeException(type, "Must be a literal class name of type ActionListener");
            }
            try {
                ReflectionUtil.forName(type.getValue());
            }
            catch (ClassNotFoundException e) {
                throw new TagAttributeException(type, "Couldn't qualify ActionListener", (Throwable)e);
            }
            this.listenerType = type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent instanceof ActionSource) {
            if (ComponentSupport.isNew(parent)) {
                ActionSource as = (ActionSource)parent;
                ValueExpression b = null;
                if (this.binding != null) {
                    b = this.binding.getValueExpression(ctx, ActionListener.class);
                }
                LazyActionListener listener = new LazyActionListener(this.listenerType, b);
                as.addActionListener((ActionListener)listener);
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type ActionSource, type is: " + parent);
        }
    }

    private static final class LazyActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -9202120013153262119L;
        private final String type;
        private final ValueExpression binding;

        public LazyActionListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            ActionListener instance = null;
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            if (this.binding != null) {
                instance = (ActionListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (ActionListener)ReflectionUtil.forName(this.type).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                instance.processAction(event);
            }
        }
    }
}

