/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.exception.JDBCExceptionHelper;

public class Isolater {
    private static final Log log = LogFactory.getLog((Class)Isolater.class);

    public static void doIsolatedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work);
        } else {
            new JdbcDelegate(session).delegateWork(work);
        }
    }

    public static class JdbcDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JdbcDelegate(SessionImplementor session) {
            this.session = session;
        }

        /*
         * Loose catch block
         */
        public void delegateWork(IsolatedWork work) throws HibernateException {
            block14: {
                Connection connection = null;
                boolean wasAutoCommit = false;
                connection = this.session.getBatcher().openConnection();
                if (connection.getAutoCommit()) {
                    wasAutoCommit = true;
                    connection.setAutoCommit(false);
                }
                work.doWork(connection);
                connection.commit();
                Object var7_4 = null;
                if (!wasAutoCommit) break block14;
                try {
                    connection.setAutoCommit(true);
                }
                catch (Throwable ignore) {
                    log.trace((Object)"was unable to reset connection back to auto-commit");
                }
                this.session.getBatcher().closeConnection(connection);
                {
                    break block14;
                    catch (Throwable t) {
                        try {
                            if (connection != null && !connection.isClosed()) {
                                connection.rollback();
                            }
                        }
                        catch (Throwable ignore) {
                            log.trace((Object)("unable to release connection on exception [" + ignore + "]"));
                        }
                        if (t instanceof HibernateException) {
                            throw (HibernateException)t;
                        }
                        if (t instanceof SQLException) {
                            throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), (SQLException)t, "error performing isolated work");
                        }
                        throw new HibernateException("error performing isolated work", t);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    if (wasAutoCommit) {
                        try {
                            connection.setAutoCommit(true);
                        }
                        catch (Throwable ignore) {
                            log.trace((Object)"was unable to reset connection back to auto-commit");
                        }
                        this.session.getBatcher().closeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static class JtaDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JtaDelegate(SessionImplementor session) {
            this.session = session;
        }

        /*
         * Loose catch block
         */
        public void delegateWork(IsolatedWork work) throws HibernateException {
            block18: {
                TransactionManager transactionManager = this.session.getFactory().getTransactionManager();
                Transaction surroundingTransaction = null;
                Connection connection = null;
                boolean caughtException = false;
                surroundingTransaction = transactionManager.suspend();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("surrounding JTA transaction suspended [" + surroundingTransaction + "]"));
                }
                transactionManager.begin();
                connection = this.session.getBatcher().openConnection();
                work.doWork(connection);
                this.session.getBatcher().closeConnection(connection);
                transactionManager.commit();
                Object var9_6 = null;
                if (surroundingTransaction == null) break block18;
                try {
                    transactionManager.resume(surroundingTransaction);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("surrounding JTA transaction resumed [" + surroundingTransaction + "]"));
                    }
                    break block18;
                }
                catch (Throwable t) {
                    if (!caughtException) {
                        new HibernateException("unable to resume previously suspended transaction", t);
                    }
                    break block18;
                }
                {
                    catch (Throwable t) {
                        caughtException = true;
                        try {
                            if (connection != null && !connection.isClosed()) {
                                this.session.getBatcher().closeConnection(connection);
                            }
                        }
                        catch (Throwable ignore) {
                            log.trace((Object)("unable to release connection on exception [" + ignore + "]"));
                        }
                        try {
                            transactionManager.rollback();
                        }
                        catch (Throwable ignore) {
                            log.trace((Object)("unable to rollback new transaction on exception [" + ignore + "]"));
                        }
                        if (t instanceof HibernateException) {
                            throw (HibernateException)t;
                        }
                        throw new HibernateException("error performing isolated work", t);
                    }
                }
                catch (Throwable throwable) {
                    block19: {
                        Object var9_7 = null;
                        if (surroundingTransaction != null) {
                            try {
                                transactionManager.resume(surroundingTransaction);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("surrounding JTA transaction resumed [" + surroundingTransaction + "]"));
                                }
                            }
                            catch (Throwable t) {
                                if (caughtException) break block19;
                                new HibernateException("unable to resume previously suspended transaction", t);
                            }
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private static interface Delegate {
        public void delegateWork(IsolatedWork var1) throws HibernateException;
    }
}

