/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.ConfigProvider;
import org.jboss.ws.core.client.ServiceObjectFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public class ServiceObjectFactoryJAXWS
extends ServiceObjectFactory {
    private static final Logger log = Logger.getLogger(ServiceObjectFactoryJAXWS.class);
    private static ThreadLocal<UnifiedServiceRefMetaData> serviceRefAssociation = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            void var14_23;
            void var14_19;
            Class<?> targetClass;
            Reference ref = (Reference)obj;
            String targetClassName = (String)ref.get("TARGET_CLASS_NAME").getContent();
            UnifiedServiceRefMetaData serviceRef = this.unmarshallServiceRef(ref);
            String serviceRefName = serviceRef.getServiceRefName();
            QName serviceQName = serviceRef.getServiceQName();
            String serviceImplClass = serviceRef.getServiceImplClass();
            if (serviceImplClass == null) {
                serviceImplClass = (String)ref.get("SERVICE_CLASS_NAME").getContent();
            }
            if (Service.class.getName().equals(targetClassName)) {
                targetClassName = serviceImplClass;
            }
            log.debug((Object)("[name=" + serviceRefName + ",service=" + serviceImplClass + ",target=" + targetClassName + "]"));
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            Class<?> serviceClass = ctxLoader.loadClass(serviceImplClass);
            Class<?> clazz = targetClass = targetClassName != null ? ctxLoader.loadClass(targetClassName) : null;
            if (!Service.class.isAssignableFrom(serviceClass)) {
                throw new IllegalArgumentException("WebServiceRef type '" + serviceClass + "' is not assignable to javax.xml.ws.Service");
            }
            log.debug((Object)("Loaded Service '" + serviceClass.getName() + "' from: " + serviceClass.getProtectionDomain().getCodeSource()));
            URL wsdlURL = serviceRef.getWsdlLocation();
            try {
                serviceRefAssociation.set(serviceRef);
                if (serviceClass == Service.class) {
                    if (wsdlURL == null) throw new IllegalArgumentException("Cannot create generic javax.xml.ws.Service without wsdlLocation: " + serviceRefName);
                    Service service = Service.create((URL)wsdlURL, (QName)serviceQName);
                } else if (wsdlURL != null) {
                    Constructor<?> ctor = serviceClass.getConstructor(URL.class, QName.class);
                    Object obj2 = ctor.newInstance(wsdlURL, serviceQName);
                } else {
                    Service service = (Service)serviceClass.newInstance();
                }
                Object var18_26 = null;
                serviceRefAssociation.set(null);
            }
            catch (Throwable throwable) {
                Object var18_27 = null;
                serviceRefAssociation.set(null);
                throw throwable;
            }
            this.configureService((Service)var14_19, serviceRef);
            if (targetClassName == null || targetClassName.equals(serviceImplClass)) return var14_23;
            try {
                void var14_21;
                Object port = null;
                if (serviceClass != Service.class) {
                    for (Method method : serviceClass.getDeclaredMethods()) {
                        String methodName = method.getName();
                        Class<?> retType = method.getReturnType();
                        if (!methodName.startsWith("get") || !targetClass.isAssignableFrom(retType)) continue;
                        Object object = port = method.invoke((Object)var14_19, new Object[0]);
                        break;
                    }
                }
                if (port != null) return var14_23;
                Method method = serviceClass.getMethod("getPort", Class.class);
                Object object = port = method.invoke((Object)var14_21, targetClass);
                return var14_23;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        catch (Throwable ex) {
            WSException.rethrow("Cannot create service", ex);
            return null;
        }
    }

    public static UnifiedServiceRefMetaData getServiceRefAssociation() {
        return serviceRefAssociation.get();
    }

    private void configureService(Service service, UnifiedServiceRefMetaData serviceRef) {
        String configFile = serviceRef.getConfigFile();
        String configName = serviceRef.getConfigName();
        if (service instanceof ConfigProvider) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configure Service: [configName=" + configName + ",configFile=" + configFile + "]"));
            }
            ConfigProvider cp = (ConfigProvider)service;
            if (configName != null || configFile != null) {
                cp.setConfigName(configName, configFile);
            }
        }
    }

    private UnifiedServiceRefMetaData unmarshallServiceRef(Reference ref) throws ClassNotFoundException, NamingException {
        UnifiedServiceRefMetaData sref;
        RefAddr refAddr = ref.get("SERVICE_REF_META_DATA");
        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])refAddr.getContent());
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            sref = (UnifiedServiceRefMetaData)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
        }
        return sref;
    }
}

