/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.util.Calendar;
import java.util.Collection;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.jboss.ws.extensions.security.exception.FailedCheckException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.RequireOperation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequireTimestampOperation
implements RequireOperation {
    private String maxAge;

    public RequireTimestampOperation(String maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public void process(Document message, SecurityHeader header, Collection<String> processedIds) throws WSSecurityException {
        Timestamp stamp = header.getTimestamp();
        if (stamp == null) {
            throw new FailedCheckException("Required timestamp not present.");
        }
        if (this.maxAge == null) {
            return;
        }
        int max = Integer.parseInt(this.maxAge);
        Calendar expired = (Calendar)stamp.getCreated().clone();
        expired.add(13, max);
        if (!Calendar.getInstance().before(expired)) {
            throw new FailedCheckException("Timestamp of message is too old.");
        }
    }
}

