package org.jboss.eap.util.xp.patch.stream.manager;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
enum ManagerState {
    CLEAN(ManagerCommand.SETUP),
    INSTALLED(ManagerCommand.REMOVE),
    INCONSISTENT(ManagerCommand.REMOVE);

    private final Set<ManagerCommand> availableCommands;

    ManagerState(ManagerCommand... commands) {
        Set<ManagerCommand> set = new HashSet<>();
        for (ManagerCommand command : commands) {
            set.add(command);
        }
        availableCommands = Collections.unmodifiableSet(set);
    }

    public Set<ManagerCommand> getAvailableCommands() {
        return availableCommands;
    }
}
