package org.jboss.eap.util.xp.patch.stream.manager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.junit.Test;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class PatchXmlTestCase {
    @Test
    public void testValidBasePatchXml() throws Exception {
        PatchXml.validateBasePatch(getInputStream("valid-base-patch.xml"));

    }

    @Test
    public void testValidXpPatchXml() throws Exception {
        PatchXml.validateXpPatch(getInputStream("valid-xp-patch.xml"));
    }

    @Test(expected = IllegalStateException.class)
    public void testBasePatchBadPatchId() throws Exception {
        PatchXml.validateBasePatch(getInputStream("base-patch-bad-id.xml"));
    }

    @Test(expected = IllegalStateException.class)
    public void testXpPatchBadPatchId() throws Exception {
        PatchXml.validateXpPatch(getInputStream("xp-patch-bad-id.xml"));
    }

    @Test(expected = IllegalStateException.class)
    public void testBasePatchNoElement() throws Exception {
        PatchXml.validateBasePatch(getInputStream("base-patch-no-element.xml"));
    }

    @Test(expected = IllegalStateException.class)
    public void testXpPatchNoElement() throws Exception {
        PatchXml.validateXpPatch(getInputStream("xp-patch-no-element.xml"));
    }

    @Test(expected = IllegalStateException.class)
    public void testBasePatchBadPatchElementId() throws Exception {
        PatchXml.validateBasePatch(getInputStream("base-patch-bad-element-id.xml"));
    }

    @Test(expected = IllegalStateException.class)
    public void testXpPatchBadPatchElementId() throws Exception {
        PatchXml.validateXpPatch(getInputStream("xp-patch-bad-element-id.xml"));
    }

    @Test(expected = IllegalStateException.class)
    public void testBasePatchBadLayerName() throws Exception {
        PatchXml.validateBasePatch(getInputStream("base-patch-bad-layer.xml"));
    }

    @Test(expected = IllegalStateException.class)
    public void testXpPatchBadLayerName() throws Exception {
        PatchXml.validateXpPatch(getInputStream("xp-patch-bad-layer.xml"));
    }

    private InputStream getInputStream(String name) throws IOException {
        URL url = this.getClass().getResource(name);
        return url.openStream();
    }
}
