package org.jboss.eap.util.xp.patch.stream.manager;

import java.nio.file.Path;
import java.util.List;

import org.jboss.eap.util.xp.patch.stream.manager.server.wrapper.ServerWrapperProxy;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class RemoveManagerAction extends ManagerAction {
    private final List<FileSet> removeFileSets;
    private final Path jbossHome;
    private final ServerWrapperProxy serverWrapperProxy;

    private RemoveManagerAction(ManagerStatus status, ServerWrapperProxy serverWrapperProxy, boolean supportPolicyAccepted, List<FileSet> removeFileSets, Path jbossHome) {
        super(ManagerCommand.REMOVE, status, ManagerState.CLEAN, supportPolicyAccepted);
        this.removeFileSets = removeFileSets;
        this.jbossHome = jbossHome;
        if (status.getManagerState() == ManagerState.INSTALLED) {
            this.serverWrapperProxy = serverWrapperProxy;
        } else {
            this.serverWrapperProxy = null;
        }
    }

    static RemoveManagerAction create(ManagerStatus status, ServerWrapperProxy serverWrapperProxy, boolean supportPolicyAccepted, Path jbossHome) {
        return new RemoveManagerAction(status, serverWrapperProxy, supportPolicyAccepted, status.getFileSet(), jbossHome);
    }

    @Override
    Status doExecute() throws Exception {
        RemoveUtils removeUtils = new RemoveUtils(serverWrapperProxy, jbossHome);
        ManagerState state = this.status.getManagerState();
        Status status = Status.OK;
        try {
            if (this.status.getManagerState() == ManagerState.INSTALLED) {
                // Only do the 'proper' rolling back of patches when we are removing an install
                removeUtils.rollbackPatchStreamPatches(removeFileSets);
            }
        } catch (Exception e) {
            System.err.println(ManagerLogger.LOGGER.errorRemovingPatches());
            e.printStackTrace();
            status = Status.ERROR;
        }
        removeUtils.removeFiles(removeFileSets);
        if (state != ManagerState.OLD_INSTALLED) {
            System.out.println(ManagerLogger.LOGGER.successfullyRemovedExpansionPack());
        } else {
            System.out.println(ManagerLogger.LOGGER.successfullyRemovedBackedUpFiles());
        }
        return status;
    }
}
