import java.nio.file.Files

File pomFile = new File(basedir, "generated-pom.xml");
separator = File.separator
File pomFileCopy = new File(basedir, '..' + separator + '..' + separator + '..' + separator + 'src' + separator + 'it' + separator + targetFolder + separator + 'pom.xml');
System.err.println('pomFile file ' + pomFile.getAbsolutePath());
System.err.println('pomFile file exists ' + pomFile.exists());
System.err.println('pomFile file copy ' + pomFileCopy.getAbsolutePath());

assert pomFile.exists();
assert pomFileCopy.getParentFile().exists();
if (pomFileCopy.exists()) {
    pomFileCopy.delete();
}
Files.copy(pomFile.toPath(), pomFileCopy.toPath());

File logFile = new File(basedir, "build.log");
assert logFile.exists();
File logFileCopy = new File(logFile.getParentFile(), "generate-pom-file-" + logFile.getName())
if (logFileCopy.exists()) {
    logFileCopy.delete();
}
Files.copy(logFile.toPath(), logFileCopy.toPath());

// Workaround fix javadoc issue, not expecting deps
def s1 = '''
        </dependency>
        <dependency>
            <groupId>org.jboss.eap</groupId>
            <artifactId>wildfly-microprofile-config-smallrye</artifactId>
'''
def s2 = '''
        </dependency>
        <dependency>
            <groupId>org.jboss.eap</groupId>
            <artifactId>wildfly-microprofile-health-smallrye</artifactId>
'''
def s3 = '''
        </dependency>
        <dependency>
            <groupId>org.jboss.eap</groupId>
            <artifactId>wildfly-microprofile-metrics-smallrye</artifactId>
'''
def s4 = '''
        </dependency>
        <dependency>
            <groupId>\\$\\{ee.maven.groupId}</groupId>
            <artifactId>wildfly-microprofile-opentracing-extension</artifactId>
'''

pomFileCopy.text = pomFileCopy.text.replaceAll(s1, "")
pomFileCopy.text = pomFileCopy.text.replaceAll(s2, "")
pomFileCopy.text = pomFileCopy.text.replaceAll(s3, "")
pomFileCopy.text = pomFileCopy.text.replaceAll(s4, "")

return true;
