package org.wildfly.extension.opentelemetry.api;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode = "WFLYOTELAPI", length = 4)
interface OpenTelemetryApiLogger extends BasicLogger {
    OpenTelemetryApiLogger OTELAPI_LOGGER = Logger.getMessageLogger(OpenTelemetryApiLogger.class,
            OpenTelemetryApiLogger.class.getPackage().getName());

    @Message(id = 1, value = "An unexpected exporter type was found: %s")
    IllegalArgumentException unexpectedExporterType(String exporter);
}
