/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.helpers;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class IdentityMap
implements Map,
Serializable {
    private final Map map = new HashMap();

    private static IdentityKey popKey(Object key) {
        return new IdentityKey(key);
    }

    private static void pushKey(IdentityKey k) {
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        IdentityKey k = IdentityMap.popKey(key);
        boolean result = this.map.containsKey(k);
        IdentityMap.pushKey(k);
        return result;
    }

    public boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    public Object get(Object key) {
        IdentityKey k = IdentityMap.popKey(key);
        Object result = this.map.get(k);
        IdentityMap.pushKey(k);
        return result;
    }

    public Object put(Object key, Object value) {
        return this.map.put(IdentityMap.popKey(key), value);
    }

    public Object remove(Object key) {
        IdentityKey k = IdentityMap.popKey(key);
        Object result = this.map.remove(k);
        IdentityMap.pushKey(k);
        return result;
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            this.put(me.getKey(), me.getValue());
        }
    }

    public void clear() {
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            IdentityMap.pushKey((IdentityKey)iter.next());
        }
        this.map.clear();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        HashSet<IdentityMapEntry> set = new HashSet<IdentityMapEntry>();
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            set.add(new IdentityMapEntry(((IdentityKey)me.getKey()).key, me.getValue()));
        }
        return set;
    }

    public static final class IdentityKey
    implements Serializable {
        private Object key;

        IdentityKey(Object key) {
            this.key = key;
        }

        public boolean equals(Object other) {
            return this.key == ((IdentityKey)other).key;
        }

        public int hashCode() {
            return System.identityHashCode(this.key);
        }
    }

    public static final class IdentityMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        IdentityMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object result = this.value;
            this.value = value;
            return result;
        }
    }
}

