/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.soap.server;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAP12Constants;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.SOAP12NotUnderstoodHeaderBlock;
import org.jboss.com.sun.xml.ws.encoding.soap.server.SOAPXMLDecoder;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import org.jboss.com.sun.xml.ws.util.MessageInfoUtil;
import org.jboss.com.sun.xml.ws.util.SOAPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAP12XMLDecoder
extends SOAPXMLDecoder {
    private static final Set<String> requiredRoles = new HashSet<String>();

    public SOAP12XMLDecoder() {
        requiredRoles.add("http://www.w3.org/2003/05/soap-envelope/role/next");
        requiredRoles.add("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
    }

    @Override
    protected void decodeHeader(XMLStreamReader reader, MessageInfo messageInfo, InternalMessage request) {
        super.decodeHeader(reader, messageInfo, request);
    }

    @Override
    protected QName getBodyTag() {
        return SOAP12Constants.QNAME_SOAP_BODY;
    }

    @Override
    protected QName getEnvelopeTag() {
        return SOAP12Constants.QNAME_SOAP_ENVELOPE;
    }

    @Override
    protected QName getHeaderTag() {
        return SOAP12Constants.QNAME_SOAP_HEADER;
    }

    @Override
    protected QName getMUAttrQName() {
        return SOAP12Constants.QNAME_MUSTUNDERSTAND;
    }

    @Override
    protected QName getRoleAttrQName() {
        return SOAP12Constants.QNAME_ROLE;
    }

    @Override
    public Set<String> getRequiredRoles() {
        return requiredRoles;
    }

    @Override
    protected void checkHeadersAgainstKnown(XMLStreamReader reader, Set<String> roles, Set<QName> understoodHeaders, MessageInfo mi) {
        HashSet<QName> notUnderstoodHeaders = new HashSet<QName>();
        while (reader.getEventType() == 1) {
            String role;
            QName qName = reader.getName();
            String mu = reader.getAttributeValue(this.getMUAttrQName().getNamespaceURI(), this.getMUAttrQName().getLocalPart());
            if (mu != null && (mu.equals("1") || mu.equalsIgnoreCase("true")) && (role = reader.getAttributeValue(this.getRoleAttrQName().getNamespaceURI(), this.getRoleAttrQName().getLocalPart())) != null && roles.contains(role)) {
                logger.finest("Element=" + qName + " targeted at=" + role);
                if (understoodHeaders == null || !understoodHeaders.contains(qName)) {
                    logger.finest("Element not understood=" + qName);
                    notUnderstoodHeaders.add(qName);
                }
            }
            XMLStreamReaderUtil.skipElement(reader);
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        if (notUnderstoodHeaders.isEmpty()) {
            return;
        }
        SOAPFault sf = SOAPUtil.createSOAPFault("SOAP must understand error", SOAP12Constants.FAULT_CODE_MUST_UNDERSTAND, null, null, "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        HashSet<HeaderBlock> nuHeaderBlocks = new HashSet<HeaderBlock>();
        for (QName headerName : notUnderstoodHeaders) {
            nuHeaderBlocks.add(new SOAP12NotUnderstoodHeaderBlock(headerName));
        }
        MessageInfoUtil.setNotUnderstoodHeaders(mi, nuHeaderBlocks);
        throw new SOAPFaultException(sf);
    }

    @Override
    public String getBindingId() {
        return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    }

    @Override
    protected QName getSenderFaultCode() {
        return SOAP12Constants.FAULT_CODE_CLIENT;
    }

    @Override
    protected QName getReceiverFaultCode() {
        return SOAP12Constants.FAULT_CODE_SERVER;
    }

    @Override
    protected QName getVersionMismatchFaultCode() {
        return SOAP12Constants.FAULT_CODE_VERSION_MISMATCH;
    }
}

