/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Configuration;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.RecoveryScan;
import com.arjuna.ats.arjuna.recovery.ScanThread;
import com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple;
import java.util.Vector;

public class RecoveryManager {
    public static final int INDIRECT_MANAGEMENT = 0;
    public static final int DIRECT_MANAGEMENT = 1;
    private RecoveryManagerImple _theImple = null;
    private int _mode;
    private static RecoveryManager _recoveryManager = null;

    public static final synchronized RecoveryManager manager() throws IllegalArgumentException {
        return RecoveryManager.manager(0);
    }

    public static final synchronized RecoveryManager manager(int mode) throws IllegalArgumentException {
        if (_recoveryManager == null) {
            _recoveryManager = new RecoveryManager(mode);
        } else if (_recoveryManager.mode() != mode) {
            throw new IllegalArgumentException();
        }
        return _recoveryManager;
    }

    public final void scan() {
        this._theImple.scan();
    }

    public final void scan(RecoveryScan callback) {
        ScanThread st = new ScanThread(this._theImple, callback);
        st.start();
    }

    public final void stop() {
        this._theImple.stop();
    }

    public final void addModule(RecoveryModule module) {
        this._theImple.addModule(module);
    }

    public final Vector getModules() {
        return this._theImple.getModules();
    }

    public final int mode() {
        return this._mode;
    }

    public static void main(String[] args) {
        boolean testMode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-help") == 0) {
                System.out.println("Usage: com.arjuna.ats.arjuna.recovery.RecoveryManager [-help] [-test] [-version]");
                System.exit(0);
            }
            if (args[i].compareTo("-version") == 0) {
                System.out.println("Version " + Configuration.version());
                System.exit(0);
            }
            if (args[i].compareTo("-test") != 0) continue;
            testMode = true;
        }
        try {
            RecoveryManager.manager();
            if (testMode) {
                System.out.println("Ready");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private RecoveryManager(int mode) {
        this._theImple = mode == 0 ? new RecoveryManagerImple(true) : new RecoveryManagerImple(false);
        this._mode = mode;
    }
}

