/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryConfiguration;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.arjuna.Implementations;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor;
import com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery;
import com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader;
import com.arjuna.ats.internal.arjuna.utils.SocketProcessId;
import com.arjuna.common.util.propertyservice.PropertyManagerFactory;
import java.io.IOException;
import java.util.Vector;

public class RecoveryManagerImple {
    private PeriodicRecovery _periodicRecovery;
    private RecActivatorLoader _recActivatorLoader;

    public RecoveryManagerImple(boolean threaded) {
        block7: {
            block6: {
                this._periodicRecovery = null;
                this._recActivatorLoader = null;
                String rmPropertyFile = RecoveryConfiguration.recoveryManagerPropertiesFile();
                try {
                    arjPropertyManager.propertyManager = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
                }
                catch (Exception ex) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block6;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple_1", new Object[]{ex});
                }
            }
            tsLogger.arjLogger.mergeFacilityCode(262144L);
            tsLogger.arjLoggerI18N.mergeFacilityCode(262144L);
            Implementations.initialise();
            if (this.activeRecoveryManager()) {
                throw new FatalError("Recovery manager already active!");
            }
            this._recActivatorLoader = new RecActivatorLoader();
            ExpiredEntryMonitor.startUp();
            this._periodicRecovery = new PeriodicRecovery(threaded);
            try {
                if (tsLogger.arjLogger.isInfoEnabled()) {
                    RecoveryManagerImple recoveryManagerImple = this;
                    tsLogger.arjLogger.info("RecoveryManagerImple is ready on port " + recoveryManagerImple._periodicRecovery.getServerSocket().getLocalPort());
                }
            }
            catch (IOException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block7;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple_2", new Object[]{ex});
            }
        }
    }

    public final void scan() {
        this._periodicRecovery.doWork(false);
    }

    public final void addModule(RecoveryModule module) {
        this._periodicRecovery.addModule(module);
    }

    public final Vector getModules() {
        return this._periodicRecovery.getModules();
    }

    public void stop() {
        this._periodicRecovery.shutdown();
    }

    public void finalize() {
        this.stop();
    }

    private final boolean activeRecoveryManager() {
        SocketProcessId socket = null;
        boolean active = false;
        try {
            socket = new SocketProcessId();
            if (socket.getpid() == -1) {
                active = true;
            }
        }
        catch (FatalError ex) {
            active = true;
        }
        return active;
    }
}

