/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.common;

import com.arjuna.common.util.FileLocator;
import com.arjuna.orbportability.Services;
import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.logging.opLogger;
import java.io.File;
import java.io.FileNotFoundException;

public class Configuration {
    private static String _configFile = "CosServices.cfg";
    private static String _configFileRoot = null;
    private static int _bindDefault = 0;
    private static boolean _bindDefaultSet = false;
    private static String _propFile = "jbossjts-properties.xml";
    private static String _orbConfiguration = "defaultorb-configuration.xml";

    public static final synchronized String defaultORBConfiguration() {
        return _orbConfiguration;
    }

    public static final synchronized String propertiesFile() {
        return _propFile;
    }

    public static final synchronized void setPropertiesFile(String file) {
        _propFile = file;
    }

    private static final String stripDirectoryFromFilename(String filename) {
        int lastSlash;
        String dir = ".";
        int lastSeparator = filename.lastIndexOf(File.separatorChar);
        if (lastSeparator > (lastSlash = filename.lastIndexOf(47)) && lastSeparator != -1) {
            dir = filename.substring(0, lastSeparator);
        } else if (lastSlash != -1) {
            dir = filename.substring(0, lastSlash);
        }
        return dir;
    }

    public static final synchronized String propertiesDir() {
        String propDir;
        block3: {
            propDir = ".";
            try {
                propDir = FileLocator.locateFile((String)Configuration.propertiesFile());
                if (propDir != null) {
                    propDir = Configuration.stripDirectoryFromFilename(propDir);
                }
            }
            catch (FileNotFoundException e) {
                if (!opLogger.loggerI18N.isWarnEnabled()) break block3;
                opLogger.loggerI18N.warn("com.arjuna.orbportability.common.Configuration.cannotfindproperties", new Object[]{"Configuration.propertiesDir()", Configuration.propertiesFile()});
            }
        }
        return propDir;
    }

    public static final synchronized String configFile() {
        return _configFile;
    }

    public static synchronized void setConfigFile(String s) {
        _configFile = s;
    }

    public static final synchronized String configFileRoot() {
        if (_configFileRoot == null) {
            String oldConfigFile = null;
            try {
                oldConfigFile = FileLocator.locateFile((String)_configFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            _configFileRoot = oldConfigFile != null ? Configuration.stripDirectoryFromFilename(oldConfigFile) : Configuration.propertiesDir();
        }
        return _configFileRoot;
    }

    public static synchronized void setConfigFileRoot(String s) {
        _configFileRoot = s;
    }

    public static final synchronized int bindDefault() {
        int bindMethod = _bindDefault;
        if (!_bindDefaultSet) {
            String configuredMechanism = opPropertyManager.propertyManager.getProperty("com.arjuna.orbportability.bindMechanism");
            if (configuredMechanism != null) {
                bindMethod = Services.bindValue(configuredMechanism);
            }
            if (bindMethod == -1 && opLogger.loggerI18N.isWarnEnabled()) {
                opLogger.loggerI18N.warn("com.arjuna.orbportability.common.Configuration.bindDefault.invalidbind", new Object[]{"com.arjuna.orbportability.common.Configuration.bindDefault()"});
            }
        }
        return bindMethod;
    }

    public static final synchronized void setBindDefault(int i) {
        if (i < 0 || i > 4) {
            if (opLogger.loggerI18N.isWarnEnabled()) {
                opLogger.loggerI18N.warn("com.arjuna.orbportability.common.Configuration.setBindDefault.invaliddefaultvalue", new Object[]{"com.arjuna.orbportability.common.Configuration.setBindDefault", "" + i});
            }
        } else {
            _bindDefaultSet = true;
            _bindDefault = i;
        }
    }

    public static final String version() {
        return "unknown";
    }
}

