/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.AnnotatedElement;
import javax.ejb.AroundInvoke;
import javax.ejb.InvocationContext;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.Around;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BusinessProcessInterceptor;
import org.jboss.seam.interceptors.ConversationInterceptor;
import org.jboss.seam.interceptors.RollbackInterceptor;
import org.jboss.seam.util.Transactions;

@Around(value={RollbackInterceptor.class, BusinessProcessInterceptor.class, ConversationInterceptor.class})
public class TransactionInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(TransactionInterceptor.class);

    @AroundInvoke
    public Object doInTransactionIfNecessary(InvocationContext invocation) throws Exception {
        UserTransaction userTransaction;
        boolean begin = (TransactionInterceptor.isTransactional(invocation.getMethod()) || TransactionInterceptor.isTransactional(this.component.getBeanClass())) && !Transactions.isTransactionActiveOrMarkedRollback();
        Object object = userTransaction = begin ? Transactions.getUserTransaction() : null;
        if (begin) {
            log.debug((Object)"beginning transaction");
            userTransaction.begin();
        }
        try {
            Object result = invocation.proceed();
            if (begin) {
                log.debug((Object)"committing transaction");
                userTransaction.commit();
            }
            return result;
        }
        catch (Exception e) {
            if (begin) {
                log.debug((Object)"rolling back transaction");
                userTransaction.rollback();
            }
            throw e;
        }
    }

    private static boolean isTransactional(AnnotatedElement element) {
        return element.isAnnotationPresent(Transactional.class);
    }
}

