/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.stateless.unit;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import org.jboss.ejb3.test.stateless.StatelessRemote;
import org.jboss.logging.Logger;
import org.jboss.test.JBossTestCase;
import junit.framework.Test;

import javax.management.MBeanServerConnection;


/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
public class MetricsUnitTestCase
extends JBossTestCase
{
   private static final Logger log = Logger.getLogger(MetricsUnitTestCase.class);

   public MetricsUnitTestCase(String name)
   {
      super(name);
   }
   
   public void testDefaultJmxMetrics() throws Exception
   {
      MBeanServerConnection server = getServer();
      ObjectName testerName = new ObjectName("jboss.j2ee:jar=stateless-test.jar,name=DefaultPoolStatelessBean,service=EJB3");
      
      int size = 0;
      
      size = (Integer)server.getAttribute(testerName, "CurrentSize");
      assertEquals(-1, size);
      
      size = (Integer)server.getAttribute(testerName, "CreateCount");
      assertEquals(0, size);
      
      StatelessRemote stateless = (StatelessRemote)getInitialContext().lookup("DefaultPoolStatelessBean/remote");
      assertNotNull(stateless);
      stateless.test();     
      
      size = (Integer)server.getAttribute(testerName, "CurrentSize");
      assertEquals(-1, size);
      
      size = (Integer)server.getAttribute(testerName, "AvailableCount");
      assertEquals(-1, size);
      
      size = (Integer)server.getAttribute(testerName, "MaxSize");
      assertEquals(-1, size);
      
      size = (Integer)server.getAttribute(testerName, "CreateCount");
      assertEquals(1, size);
      
      size = (Integer)server.getAttribute(testerName, "RemoveCount");
      assertEquals(0, size);
      
   }
   
   public void testStrictMaxPoolJmxMetrics() throws Exception
   {
      MBeanServerConnection server = getServer();
      ObjectName testerName = new ObjectName("jboss.j2ee:jar=stateless-test.jar,name=StrictMaxPoolStatelessBean,service=EJB3");
      int size = 0;
      
      size = (Integer)server.getAttribute(testerName, "CurrentSize");
      assertEquals(0, size);
      
      size = (Integer)server.getAttribute(testerName, "CreateCount");
      assertEquals(0, size);
      
      StatelessRemote stateless = (StatelessRemote)getInitialContext().lookup("StrictMaxPoolStatelessBean/remote");
      assertNotNull(stateless);
      stateless.test();     
      
      size = (Integer)server.getAttribute(testerName, "CurrentSize");
      assertEquals(1, size);
      
      size = (Integer)server.getAttribute(testerName, "AvailableCount");
      assertEquals(123, size);
      
      size = (Integer)server.getAttribute(testerName, "MaxSize");
      assertEquals(123, size);
      
      size = (Integer)server.getAttribute(testerName, "CreateCount");
      assertEquals(1, size);
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(MetricsUnitTestCase.class, "stateless-test.jar");
   }

}
