/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.util.Classes;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.introspection.ClassInfo;
import org.jboss.xb.binding.introspection.ClassInfos;

public class FieldInfo {
    private static final Object[] NO_ARGS = new Object[0];
    private final Class owner;
    private final String name;
    private final Class type;
    private final GetValueAccess getter;
    private SetValueAccess setter;
    private boolean setterInitialized;

    static FieldInfo getFieldInfo(ClassInfo clsInfo, String name) {
        FieldInfo fieldInfo = null;
        try {
            Method getter = Classes.getAttributeGetter((Class)clsInfo.getType(), (String)name);
            fieldInfo = new FieldInfo(clsInfo.getType(), name, getter);
            clsInfo.addFieldInfo(fieldInfo);
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = clsInfo.getType().getField(name);
                fieldInfo = new FieldInfo(clsInfo.getType(), field);
                clsInfo.addFieldInfo(fieldInfo);
            }
            catch (NoSuchFieldException e1) {
                fieldInfo = clsInfo.introspect(name);
            }
        }
        return fieldInfo;
    }

    public static FieldInfo getFieldInfo(Class cls, String fieldName, boolean required) {
        return ClassInfos.getClassInfo(cls).getFieldInfo(fieldName, required);
    }

    public FieldInfo(Class owner, String name, Method getter) {
        this.owner = owner;
        this.name = name;
        this.type = getter.getReturnType();
        this.getter = GetValueAccessFactory.methodAccess(getter);
    }

    public FieldInfo(Class owner, String name, Method getter, Method setter) {
        this.owner = owner;
        this.name = name;
        this.type = getter.getReturnType();
        this.getter = GetValueAccessFactory.methodAccess(getter);
        this.setter = SetValueAccessFactory.methodAccess(setter);
        this.setterInitialized = true;
    }

    public FieldInfo(Class owner, Field field) {
        this.owner = owner;
        this.name = field.getName();
        this.type = field.getType();
        this.getter = GetValueAccessFactory.fieldAccess(field);
        this.setter = SetValueAccessFactory.fieldAccess(field);
        this.setterInitialized = true;
    }

    public Class getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        if (!this.setterInitialized) {
            this.initializeSetter();
        }
        return this.setter != null;
    }

    public Object getValue(Object owner) {
        try {
            return this.getter.get(owner);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("Failed to get value of the property '" + this.name + "' defined in " + owner + " from instance " + owner, e);
        }
    }

    public void setValue(Object owner, Object value) {
        if (!this.isWritable()) {
            throw new JBossXBRuntimeException("Failed to find setter or field for property '" + this.name + "' in " + owner);
        }
        try {
            this.setter.set(owner, value);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("Failed to set value '" + value + "' for property '" + this.name + "' defined in " + owner.getClass().getName() + " on instance " + owner, e);
        }
    }

    private void initializeSetter() {
        try {
            this.setter = SetValueAccessFactory.methodAccess(Classes.getAttributeSetter((Class)this.owner, (String)this.name, (Class)this.type));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.setterInitialized = true;
    }

    static /* synthetic */ Object[] access$000() {
        return NO_ARGS;
    }

    public static class SetValueAccessFactory {
        public static SetValueAccess fieldAccess(Field field) {
            return new SetValueAccess(field){
                private final /* synthetic */ Field val$field;
                {
                    this.val$field = val$field;
                }

                public void set(Object owner, Object value) throws IllegalAccessException {
                    this.val$field.set(owner, value);
                }
            };
        }

        public static SetValueAccess methodAccess(Method m) {
            return new SetValueAccess(m){
                private final /* synthetic */ Method val$m;
                {
                    this.val$m = val$m;
                }

                public void set(Object owner, Object value) throws IllegalAccessException, InvocationTargetException {
                    Object[] arguments = new Object[]{value};
                    try {
                        this.val$m.invoke(owner, value);
                    }
                    catch (IllegalArgumentException e) {
                        if (owner == null) {
                            throw new IllegalArgumentException("Null target for " + this.val$m.getName());
                        }
                        ArrayList<String> expected = new ArrayList<String>();
                        Class<?>[] parameters = this.val$m.getParameterTypes();
                        if (parameters != null) {
                            for (int i = 0; i < parameters.length; ++i) {
                                expected.add(parameters[i].getName());
                            }
                        }
                        ArrayList<String> actual = new ArrayList<String>();
                        if (arguments != null) {
                            for (int i = 0; i < arguments.length; ++i) {
                                if (arguments[i] == null) {
                                    actual.add(null);
                                    continue;
                                }
                                actual.add(arguments[i].getClass().getName());
                            }
                        }
                        throw new IllegalArgumentException("Wrong arguments. " + this.val$m.getName() + " for target " + owner + " expected=" + expected + " actual=" + actual);
                    }
                }
            };
        }
    }

    private static interface SetValueAccess {
        public void set(Object var1, Object var2) throws IllegalAccessException, InvocationTargetException;
    }

    public static class GetValueAccessFactory {
        public static GetValueAccess fieldAccess(Field field) {
            return new GetValueAccess(field){
                private final /* synthetic */ Field val$field;
                {
                    this.val$field = val$field;
                }

                public Object get(Object owner) throws IllegalAccessException {
                    return this.val$field.get(owner);
                }
            };
        }

        public static GetValueAccess methodAccess(Method m) {
            return new GetValueAccess(m){
                private final /* synthetic */ Method val$m;
                {
                    this.val$m = val$m;
                }

                public Object get(Object owner) throws IllegalAccessException, InvocationTargetException {
                    return this.val$m.invoke(owner, FieldInfo.access$000());
                }
            };
        }
    }

    private static interface GetValueAccess {
        public Object get(Object var1) throws IllegalAccessException, InvocationTargetException;
    }
}

