/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractAttributeMap
implements Map {
    private Collection values;
    private Set keySet;
    private Set entrySet;

    public int size() {
        int size = 0;
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++size;
        }
        return size;
    }

    public void clear() {
        Enumeration e = this.getAttributeNames();
        ArrayList keys = new ArrayList();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            this.removeAttribute((String)iterator.next());
        }
    }

    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            if (!value.equals(this.getAttribute(e.nextElement().toString()))) continue;
            return true;
        }
        return false;
    }

    public Collection values() {
        return this.values != null ? this.values : (this.values = new Values());
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.setAttribute(entry.getKey().toString(), entry.getValue());
        }
    }

    public Set entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    public Set keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    public Object get(Object key) {
        return this.getAttribute(key.toString());
    }

    public Object remove(Object key) {
        Object associatedValue = this.getAttribute(key.toString());
        this.removeAttribute(key.toString());
        return associatedValue;
    }

    public Object put(Object key, Object value) {
        Object previousValue = this.getAttribute(key.toString());
        this.setAttribute(key.toString(), value);
        return previousValue;
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration getAttributeNames();

    private class EntrySetEntry
    implements Map.Entry {
        private final Object currentKey;

        public EntrySetEntry(Object currentKey) {
            this.currentKey = currentKey;
        }

        public Object getKey() {
            return this.currentKey;
        }

        public Object getValue() {
            return AbstractAttributeMap.this.get(this.currentKey);
        }

        public Object setValue(Object value) {
            return AbstractAttributeMap.this.put(this.currentKey, value);
        }
    }

    private class EntryIterator
    extends KeyIterator {
        private EntryIterator() {
        }

        public Object next() {
            super.next();
            return new EntrySetEntry(this.currentKey);
        }
    }

    private class EntrySet
    extends KeySet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            return value.equals(AbstractAttributeMap.this.get(key));
        }

        public boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!value.equals(AbstractAttributeMap.this.get(key)) || key == null || value == null) {
                return false;
            }
            return AbstractAttributeMap.this.remove(key) != null;
        }
    }

    private class ValuesIterator
    extends KeyIterator {
        private ValuesIterator() {
        }

        public Object next() {
            super.next();
            return AbstractAttributeMap.this.get(this.currentKey);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValuesIterator();
        }

        public boolean contains(Object value) {
            return AbstractAttributeMap.this.containsValue(value);
        }

        public boolean remove(Object value) {
            if (value == null) {
                return false;
            }
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!value.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public int size() {
            return AbstractAttributeMap.this.size();
        }

        public boolean isEmpty() {
            return AbstractAttributeMap.this.isEmpty();
        }

        public void clear() {
            AbstractAttributeMap.this.clear();
        }
    }

    private class KeyIterator
    implements Iterator {
        protected final Enumeration e;
        protected Object currentKey;

        private KeyIterator() {
            this.e = AbstractAttributeMap.this.getAttributeNames();
        }

        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        public Object next() {
            this.currentKey = this.e.nextElement();
            return this.currentKey;
        }

        public void remove() {
            if (this.currentKey == null) {
                throw new NoSuchElementException("No element is pointed for remove operation");
            }
            AbstractAttributeMap.this.remove(this.currentKey);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return AbstractAttributeMap.this.size();
        }

        public boolean isEmpty() {
            return AbstractAttributeMap.this.isEmpty();
        }

        public boolean contains(Object key) {
            return AbstractAttributeMap.this.containsKey(key);
        }

        public boolean remove(Object key) {
            return AbstractAttributeMap.this.remove(key) != null;
        }

        public void clear() {
            AbstractAttributeMap.this.clear();
        }
    }
}

