/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.env;

import com.icesoft.faces.env.ServletEnvironmentRequest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;

public class PortletEnvironmentRequest
extends ServletEnvironmentRequest
implements PortletRequest {
    private Hashtable properties;
    private PortletRequest portletRequest;
    private PortletMode portletMode;
    private WindowState windowState;
    private PortletPreferences portletPreferences;
    private PortletSession portletSession;
    private PortalContext portalContext;
    private String responseContentType;
    private Vector responseContentTypes;

    public PortletEnvironmentRequest(PortletRequest portletRequest) {
        this.copyPortletRequestData(portletRequest);
    }

    private void copyPortletRequestData(PortletRequest req) {
        String[] value;
        this.portletRequest = req;
        this.authType = req.getAuthType();
        this.contextPath = req.getContextPath();
        this.remoteUser = req.getRemoteUser();
        this.userPrincipal = req.getUserPrincipal();
        this.requestedSessionId = req.getRequestedSessionId();
        this.isRequestedSessionIdValid = req.isRequestedSessionIdValid();
        this.attributes = new Hashtable();
        Enumeration items = req.getAttributeNames();
        String name = null;
        while (items.hasMoreElements()) {
            name = (String)items.nextElement();
            value = req.getAttribute(name);
            if (null == value) continue;
            this.attributes.put(name, value);
        }
        this.parameters = new Hashtable();
        items = req.getParameterNames();
        while (items.hasMoreElements()) {
            name = (String)items.nextElement();
            value = req.getParameterValues(name);
            if (null == value) continue;
            this.parameters.put(name, req.getParameterValues(name));
        }
        this.scheme = req.getScheme();
        this.serverName = req.getServerName();
        this.serverPort = req.getServerPort();
        this.locale = req.getLocale();
        this.locales = new Vector();
        items = req.getLocales();
        while (items.hasMoreElements()) {
            this.locales.add((Locale)items.nextElement());
        }
        this.isSecure = req.isSecure();
        this.properties = new Hashtable();
        items = req.getPropertyNames();
        while (items.hasMoreElements()) {
            name = (String)items.nextElement();
            this.properties.put(name, req.getProperties(name));
        }
        this.portletMode = req.getPortletMode();
        this.windowState = req.getWindowState();
        this.portletPreferences = req.getPreferences();
        this.portletSession = req.getPortletSession();
        this.portalContext = req.getPortalContext();
        this.responseContentType = req.getResponseContentType();
        this.responseContentTypes = new Vector();
        items = req.getResponseContentTypes();
        while (items.hasMoreElements()) {
            this.responseContentTypes.add((String)items.nextElement());
        }
    }

    public boolean isUserInRole(String role) {
        return this.portletRequest.isUserInRole(role);
    }

    public boolean isWindowStateAllowed(WindowState state) {
        return this.portletRequest.isWindowStateAllowed(state);
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        return this.portletRequest.isPortletModeAllowed(mode);
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public PortletPreferences getPreferences() {
        return this.portletPreferences;
    }

    public PortletSession getPortletSession() {
        return this.portletSession;
    }

    public PortletSession getPortletSession(boolean create) {
        return this.portletRequest.getPortletSession(create);
    }

    public String getProperty(String name) {
        Enumeration allProps = (Enumeration)this.properties.get(name);
        if (allProps.hasMoreElements()) {
            return (String)allProps.nextElement();
        }
        return null;
    }

    public Enumeration getProperties(String name) {
        return (Enumeration)this.properties.get(name);
    }

    public Enumeration getPropertyNames() {
        return this.properties.keys();
    }

    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public Enumeration getResponseContentTypes() {
        return this.responseContentTypes.elements();
    }
}

