/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.env;

import com.icesoft.faces.env.AcegiAuthWrapper;
import com.icesoft.faces.env.CommonEnvironmentRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletEnvironmentRequest
extends CommonEnvironmentRequest
implements HttpServletRequest {
    protected static Log log;
    private static String ACEGI_AUTH_CLASS;
    HttpServletRequest servletRequest;
    private String localName;
    private String localAddr;
    private int localPort;
    private Hashtable headers;
    private Cookie[] cookies;
    private String method;
    private String pathInfo;
    private String pathTranslated;
    private String queryString;
    private String requestURI;
    private StringBuffer requestURL;
    private String servletPath;
    private HttpSession servletSession;
    private boolean isRequestedSessionIdFromCookie;
    private boolean isRequestedSessionIdFromURL;
    private String characterEncoding;
    private int contentLength;
    private String contentType;
    private String protocol;
    private String remoteAddr;
    private String remoteHost;
    private int remotePort;
    private AcegiAuthWrapper acegiAuthWrapper;
    private static Class acegiAuthClass;

    public ServletEnvironmentRequest() {
    }

    public ServletEnvironmentRequest(HttpServletRequest servletRequest) {
        this.copyServletRequestData(servletRequest);
    }

    private void copyServletRequestData(HttpServletRequest req) {
        this.servletRequest = req;
        this.authType = req.getAuthType();
        this.contextPath = req.getContextPath();
        this.remoteUser = req.getRemoteUser();
        this.userPrincipal = req.getUserPrincipal();
        if (null != acegiAuthClass && acegiAuthClass.isInstance(this.userPrincipal)) {
            this.acegiAuthWrapper = new AcegiAuthWrapper(this.userPrincipal);
        }
        this.requestedSessionId = req.getRequestedSessionId();
        this.isRequestedSessionIdValid = req.isRequestedSessionIdValid();
        this.attributes = new Hashtable();
        Enumeration items = req.getAttributeNames();
        String name = null;
        while (items.hasMoreElements()) {
            name = (String)items.nextElement();
            Object attribute = req.getAttribute(name);
            if (null == name || null == attribute) continue;
            this.attributes.put(name, attribute);
        }
        this.headers = new Hashtable();
        items = req.getHeaderNames();
        name = null;
        while (items.hasMoreElements()) {
            name = (String)items.nextElement();
            this.headers.put(name, req.getHeaders(name));
        }
        this.parameters = new Hashtable();
        items = req.getParameterNames();
        while (items.hasMoreElements()) {
            name = (String)items.nextElement();
            this.attributes.put(name, req.getParameterValues(name));
        }
        this.scheme = req.getScheme();
        this.serverName = req.getServerName();
        this.serverPort = req.getServerPort();
        this.locale = req.getLocale();
        this.locales = new Vector();
        items = req.getLocales();
        while (items.hasMoreElements()) {
            this.locales.add(items.nextElement());
        }
        this.isSecure = req.isSecure();
        this.headers = null;
        this.cookies = req.getCookies();
        this.method = req.getMethod();
        this.pathInfo = req.getPathInfo();
        this.pathTranslated = req.getPathTranslated();
        this.queryString = req.getQueryString();
        this.requestURI = req.getRequestURI();
        this.requestURL = req.getRequestURL();
        this.servletPath = req.getServletPath();
        this.servletSession = req.getSession();
        this.isRequestedSessionIdFromCookie = req.isRequestedSessionIdFromCookie();
        this.isRequestedSessionIdFromURL = req.isRequestedSessionIdFromURL();
        this.characterEncoding = req.getCharacterEncoding();
        this.contentLength = req.getContentLength();
        this.contentType = req.getContentType();
        this.protocol = req.getProtocol();
        this.remoteAddr = req.getRemoteAddr();
        this.remoteHost = req.getRemoteHost();
    }

    public boolean isUserInRole(String role) {
        if (null != this.acegiAuthWrapper) {
            return this.acegiAuthWrapper.isUserInRole(role);
        }
        return this.servletRequest.isUserInRole(role);
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        return -1L;
    }

    public String getHeader(String name) {
        Enumeration allProps = (Enumeration)this.headers.get(name);
        if (allProps.hasMoreElements()) {
            return (String)allProps.nextElement();
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        return (Enumeration)this.headers.get(name);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(name, -1);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        return this.servletRequest.getSession(create);
    }

    public HttpSession getSession() {
        return this.servletSession;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.isRequestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.isRequestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.characterEncoding = encoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public RequestDispatcher getRequestDispatcher(String name) {
        return null;
    }

    public String getRealPath(String path) {
        return this.servletRequest.getRealPath(path);
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    static {
        block3: {
            log = LogFactory.getLog((Class)ServletEnvironmentRequest.class);
            ACEGI_AUTH_CLASS = "org.acegisecurity.Authentication";
            try {
                acegiAuthClass = Class.forName(ACEGI_AUTH_CLASS);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Acegi Security engaged.");
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Acegi Security not detected.");
            }
        }
    }
}

