/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.app;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.app.AppDescriptor;
import org.jbpm.bpel.app.AppDescriptorVisitor;
import org.jbpm.bpel.app.AppPartnerLink;
import org.jbpm.bpel.app.AppScope;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.graph.def.NodeCollection;

public class ScopeMatcher
implements AppDescriptorVisitor {
    private Map scopeConfigurations;
    private Scope parent;

    public Map match(BpelProcessDefinition definition, AppDescriptor configuration) {
        this.scopeConfigurations = new HashMap();
        this.parent = definition.getGlobalScope();
        this.visit(configuration);
        return this.scopeConfigurations;
    }

    public void visit(AppDescriptor appDescriptor) {
        this.scopeConfigurations.put(this.parent, appDescriptor);
        this.propagate(appDescriptor);
    }

    public void visit(AppScope appScope) {
        Scope scope = this.findScope(appScope.getName(), this.parent);
        if (scope != null) {
            this.scopeConfigurations.put(scope, appScope);
            Scope previousParent = this.parent;
            this.parent = scope;
            this.propagate(appScope);
            this.parent = previousParent;
        }
    }

    public void visit(AppPartnerLink appPartnerLink) {
    }

    private void propagate(AppScope config) {
        Iterator configIt = config.getScopes().iterator();
        while (configIt.hasNext()) {
            AppScope scopeConfig = (AppScope)configIt.next();
            scopeConfig.accept(this);
        }
    }

    private Scope findScope(String configName, NodeCollection parent) {
        Iterator nodesIt = parent.getNodes().iterator();
        Scope matchingScope = null;
        while (nodesIt.hasNext()) {
            Scope scope;
            Activity activity = (Activity)((Object)nodesIt.next());
            if (!(activity instanceof CompositeActivity)) continue;
            if (activity instanceof Scope && configName == null && activity.getName() == null || configName != null && configName.equals(activity.getName())) {
                if (matchingScope != null) {
                    throw new BpelException("conflicting name");
                }
                matchingScope = (Scope)activity;
            }
            if ((scope = this.findScope(configName, (NodeCollection)activity)) == null) continue;
            if (matchingScope != null) {
                throw new BpelException("conflicting name");
            }
            matchingScope = scope;
        }
        return matchingScope;
    }
}

