/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.def;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bpel.graph.def.ImportsDefinition;
import org.jbpm.bpel.graph.def.Namespace;
import org.jbpm.bpel.graph.def.ProcessInstanceStarter;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.util.ClassLoaderUtil;

public class BpelProcessDefinition
extends ProcessDefinition {
    private String targetNamespace;
    private String queryLanguage;
    private String expressionLanguage;
    private String location;
    private Set namespaces = new HashSet();
    private static final Log log = LogFactory.getLog((Class)BpelProcessDefinition.class);
    private static List moduleClasses = BpelProcessDefinition.readModuleClasses();
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$org$jbpm$module$def$ModuleDefinition;

    public BpelProcessDefinition() {
    }

    public BpelProcessDefinition(String name) {
        super(name);
    }

    public ProcessInstance createProcessInstance() {
        ProcessInstance processInstance = new ProcessInstance((ProcessDefinition)this);
        Token rootToken = processInstance.getRootToken();
        this.getGlobalScope().createInstance(rootToken).initializeData();
        this.fireEvent("process-start", new ExecutionContext(rootToken));
        return processInstance;
    }

    public Node addNode(Node node) {
        if (!(node instanceof Scope)) {
            throw new IllegalArgumentException("not a scope: " + node);
        }
        List nodes = this.getNodes();
        if (nodes != null && !nodes.isEmpty()) {
            this.removeNode((Node)nodes.get(0));
        }
        return super.addNode(node);
    }

    public ModuleDefinition getDefinition(Class clazz) {
        Map definitions = this.getDefinitions();
        return definitions != null ? (ModuleDefinition)definitions.get(clazz.getName()) : null;
    }

    public Map getDefinitions() {
        if (this.definitions == null) {
            this.initDefinitions();
        }
        return this.definitions;
    }

    private void initDefinitions() {
        int n = moduleClasses.size();
        for (int i = 0; i < n; ++i) {
            Class moduleClass = (Class)moduleClasses.get(i);
            try {
                ModuleDefinition module = (ModuleDefinition)moduleClass.newInstance();
                this.addDefinition(module);
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("could not initialize module: " + moduleClass));
            }
        }
    }

    public Scope getGlobalScope() {
        Scope globalScope;
        List nodes = this.getNodes();
        if (nodes == null || nodes.isEmpty()) {
            globalScope = new Scope();
            globalScope.setName("global");
            globalScope.setImplicit(true);
            globalScope.setSuppressJoinFailure(Boolean.FALSE);
            this.addNode(globalScope);
        } else {
            globalScope = (Scope)((Object)nodes.get(0));
        }
        return globalScope;
    }

    public ImportsDefinition getImports() {
        return (ImportsDefinition)this.getDefinition(ImportsDefinition.class);
    }

    public void messageReceived(ReceiveAction trigger, Token rootToken) {
        ScopeInstance globalInstance = Scope.getInstance(rootToken);
        globalInstance.enableEvents();
        new ProcessInstanceStarter(globalInstance.getPrimaryToken(), trigger).visit(this);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Set getNamespaces() {
        return this.namespaces;
    }

    public Namespace getNamespace(String prefix, String URI2) {
        Iterator namespaceIt = this.namespaces.iterator();
        while (namespaceIt.hasNext()) {
            Namespace namespace = (Namespace)namespaceIt.next();
            if (!prefix.equals(namespace.getPrefix()) || !URI2.equals(namespace.getURI())) continue;
            return namespace;
        }
        return null;
    }

    public Namespace addNamespace(Namespace namespace) {
        if (!this.namespaces.add(namespace)) {
            namespace = this.getNamespace(namespace.getPrefix(), namespace.getURI());
        }
        return namespace;
    }

    public Set addNamespaces(Set namespaces) {
        HashSet<Namespace> internNamespaces = new HashSet<Namespace>();
        Iterator namespaceIt = namespaces.iterator();
        while (namespaceIt.hasNext()) {
            Namespace namespace = (Namespace)namespaceIt.next();
            Namespace internNamespace = this.addNamespace(namespace);
            internNamespaces.add(internNamespace);
        }
        return internNamespaces;
    }

    public Namespace addNamespace(String prefix, String URI2) {
        Namespace namespace = this.getNamespace(prefix, URI2);
        if (namespace == null) {
            namespace = new Namespace(prefix, URI2);
            this.namespaces.add(namespace);
        }
        return namespace;
    }

    public Set addNamespaces(Map namespaceMap) {
        HashSet<Namespace> internNamespaces = new HashSet<Namespace>();
        Iterator namespaceEntryIt = namespaceMap.entrySet().iterator();
        while (namespaceEntryIt.hasNext()) {
            Map.Entry namespaceEntry = namespaceEntryIt.next();
            Namespace internNamespace = this.addNamespace((String)namespaceEntry.getKey(), (String)namespaceEntry.getValue());
            internNamespaces.add(internNamespace);
        }
        return internNamespaces;
    }

    private static List readModuleClasses() {
        Properties modulesProperties;
        String resource = JbpmConfiguration.Configs.getString((String)"resource.bpel.modules");
        try {
            modulesProperties = BpelProcessDefinition.loadProperties(resource);
        }
        catch (IOException e) {
            log.warn((Object)("could not read bpel modules document: " + resource));
            return Collections.EMPTY_LIST;
        }
        ArrayList<Class> moduleClasses = new ArrayList<Class>();
        Iterator<Object> moduleNameIt = modulesProperties.keySet().iterator();
        while (moduleNameIt.hasNext()) {
            String moduleName;
            Class moduleClass;
            if (!(class$org$jbpm$module$def$ModuleDefinition == null ? BpelProcessDefinition.class$("org.jbpm.module.def.ModuleDefinition") : class$org$jbpm$module$def$ModuleDefinition).isAssignableFrom(moduleClass = ClassLoaderUtil.loadClass((String)(moduleName = (String)moduleNameIt.next())))) {
                log.warn((Object)("not a module definition: " + moduleClass));
                continue;
            }
            moduleClasses.add(moduleClass);
            log.debug((Object)("registered module class: " + moduleClass.getName()));
        }
        return moduleClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String resource) throws IOException {
        InputStream resourceStream = ClassLoaderUtil.getStream((String)resource);
        if (resourceStream == null) {
            throw new FileNotFoundException(resource);
        }
        Properties properties = new Properties();
        try {
            properties.load(resourceStream);
        }
        finally {
            resourceStream.close();
        }
        return properties;
    }
}

