/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.jms;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.app.AppDescriptor;
import org.jbpm.bpel.app.AppPartnerRole;
import org.jbpm.bpel.app.ScopeMatcher;
import org.jbpm.bpel.endpointref.EndpointReference;
import org.jbpm.bpel.endpointref.EndpointReferenceFactory;
import org.jbpm.bpel.graph.basic.Receive;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.graph.scope.OnEvent;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.graph.struct.Pick;
import org.jbpm.bpel.graph.struct.StructuredActivity;
import org.jbpm.bpel.integration.catalog.ServiceCatalog;
import org.jbpm.bpel.integration.client.SoapClient;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.integration.def.ReplyAction;
import org.jbpm.bpel.integration.exe.PartnerLinkInstance;
import org.jbpm.bpel.integration.jms.JmsIntegrationService;
import org.jbpm.bpel.integration.jms.JmsIntegrationServiceFactory;
import org.jbpm.bpel.integration.jms.OutstandingRequest;
import org.jbpm.bpel.integration.jms.PartnerLinkEntriesBuilder;
import org.jbpm.bpel.integration.jms.PartnerLinkEntry;
import org.jbpm.bpel.integration.jms.RequestListener;
import org.jbpm.bpel.integration.jms.StartListener;
import org.jbpm.bpel.integration.jms.StartListenersBuilder;
import org.jbpm.bpel.persistence.db.IntegrationSession;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.graph.exe.Token;
import org.jbpm.svc.Services;

public class IntegrationControl {
    private final JmsIntegrationServiceFactory integrationServiceFactory;
    private Connection jmsConnection;
    private AppDescriptor appDescriptor;
    private Map partnerLinkEntriesById = Collections.EMPTY_MAP;
    private Map partnerLinkEntriesByHandle = Collections.EMPTY_MAP;
    private List startListeners = Collections.EMPTY_LIST;
    private final Map requestListeners = new Hashtable();
    private final Map outstandingRequests = new Hashtable();
    private final Map partnerClients = new LRUMap();
    public static final String NAME_JMS_CONTEXT = "jbpm.bpel.jms.context";
    public static final String DEFAULT_JMS_CONTEXT = "java:comp/env/jms";
    public static final String CONNECTION_FACTORY_NAME = "IntegrationConnectionFactory";
    private static final QName DEFAULT_REFERENCE_NAME = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference");
    public static final Log log = LogFactory.getLog((Class)IntegrationControl.class);
    private static final long serialVersionUID = 1L;

    IntegrationControl(JmsIntegrationServiceFactory integrationServiceFactory) {
        this.integrationServiceFactory = integrationServiceFactory;
    }

    public JmsIntegrationServiceFactory getIntegrationServiceFactory() {
        return this.integrationServiceFactory;
    }

    public Connection getJmsConnection() {
        return this.jmsConnection;
    }

    public AppDescriptor getAppDescriptor() {
        return this.appDescriptor;
    }

    public void setAppDescriptor(AppDescriptor appDescriptor) {
        this.appDescriptor = appDescriptor;
    }

    public PartnerLinkEntry getPartnerLinkEntry(PartnerLinkDefinition partnerLink) {
        return (PartnerLinkEntry)this.partnerLinkEntriesById.get(new Long(partnerLink.getId()));
    }

    public PartnerLinkEntry getPartnerLinkEntry(String handle) {
        return (PartnerLinkEntry)this.partnerLinkEntriesByHandle.get(handle);
    }

    public Map getRequestListeners() {
        return this.requestListeners;
    }

    public void addRequestListener(RequestListener requestListener) {
        Object listenerKey = IntegrationControl.createKey(requestListener.getReceiverId(), requestListener.getTokenId());
        this.requestListeners.put(listenerKey, requestListener);
    }

    public RequestListener removeRequestListener(ReceiveAction receiveAction, Token token) {
        Object listenerKey = IntegrationControl.createKey(receiveAction.getId(), token.getId());
        return (RequestListener)this.requestListeners.remove(listenerKey);
    }

    private static Object createKey(long receiverId, long tokenId) {
        return new RequestListener.Key(receiverId, tokenId);
    }

    public Map getOutstandingRequests() {
        return this.outstandingRequests;
    }

    public void addOutstandingRequest(ReceiveAction receiveAction, Token token, OutstandingRequest request) {
        Object key = IntegrationControl.createKey(receiveAction.getPartnerLink().getInstance(token), receiveAction.getOperation(), receiveAction.getMessageExchange());
        if (this.outstandingRequests.put(key, request) != null) {
            throw new BpelFaultException(BpelConstants.FAULT_CONFLICTING_REQUEST);
        }
        log.debug((Object)("added outstanding request: receiver=" + receiveAction + ", token=" + token + ", request=" + request));
    }

    public OutstandingRequest removeOutstandingRequest(ReplyAction replyAction, Token token) {
        Object key = IntegrationControl.createKey(replyAction.getPartnerLink().getInstance(token), replyAction.getOperation(), replyAction.getMessageExchange());
        OutstandingRequest request = (OutstandingRequest)this.outstandingRequests.remove(key);
        if (request == null) {
            throw new BpelFaultException(BpelConstants.FAULT_MISSING_REQUEST);
        }
        log.debug((Object)("removed outstanding request: replier=" + replyAction + ", token=" + token + ", request=" + request));
        return request;
    }

    private static Object createKey(PartnerLinkInstance partnerLinkInstance, Operation operation, String messageExchange) {
        return new OutstandingRequest.Key(IntegrationControl.getOrAssignId(partnerLinkInstance), operation.getName(), messageExchange);
    }

    public Map getPartnerClients() {
        return this.partnerClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoapClient getPartnerClient(PartnerLinkInstance instance) {
        Long instanceId = new Long(IntegrationControl.getOrAssignId(instance));
        Map map = this.partnerClients;
        synchronized (map) {
            SoapClient partnerClient = (SoapClient)this.partnerClients.get(instanceId);
            if (partnerClient == null) {
                partnerClient = this.createPartnerClient(instance);
                this.partnerClients.put(instanceId, partnerClient);
            }
            return partnerClient;
        }
    }

    private SoapClient createPartnerClient(PartnerLinkInstance instance) {
        EndpointReference partnerRef = instance.getPartnerReference();
        if (partnerRef == null) {
            partnerRef = this.createPartnerReference(instance.getDefinition());
            instance.setPartnerReference(partnerRef);
            log.debug((Object)("initialized partner reference: instance=" + instance + ", reference=" + partnerRef));
        }
        Port port = partnerRef.selectPort(this.getServiceCatalog());
        log.debug((Object)("selected partner port: instance=" + instance + ", port=" + port.getName()));
        return new SoapClient(port);
    }

    private static long getOrAssignId(PartnerLinkInstance instance) {
        long instanceId = instance.getId();
        if (instanceId == 0L) {
            Services.assignId((Object)instance);
            instanceId = instance.getId();
        }
        return instanceId;
    }

    EndpointReference createPartnerReference(PartnerLinkDefinition definition) {
        EndpointReference partnerReference;
        PartnerLinkEntry entry = this.getPartnerLinkEntry(definition);
        AppPartnerRole.InitiateMode initiateMode = entry.getInitiateMode();
        if (AppPartnerRole.InitiateMode.STATIC.equals((Object)initiateMode)) {
            partnerReference = entry.getPartnerReference();
        } else if (AppPartnerRole.InitiateMode.PULL.equals((Object)initiateMode)) {
            EndpointReferenceFactory refFactory = EndpointReferenceFactory.getInstance(DEFAULT_REFERENCE_NAME, null);
            partnerReference = refFactory.createEndpointReference();
        } else {
            throw new BpelFaultException(BpelConstants.FAULT_UNINITIALIZED_PARTNER_ROLE);
        }
        return partnerReference;
    }

    public ServiceCatalog getServiceCatalog() {
        return this.getAppDescriptor().getServiceCatalog();
    }

    public List getStartListeners() {
        return this.startListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableInboundMessageActivities(JbpmContext jbpmContext) throws NamingException, JMSException {
        InitialContext initialContext = new InitialContext();
        try {
            BpelProcessDefinition process = this.getAppDescriptor().findProcessDefinition(jbpmContext);
            this.createPartnerLinkEntries(initialContext, process);
            this.createJmsConnection(initialContext);
            try {
                StartListenersBuilder builder = new StartListenersBuilder(this);
                builder.visit(process);
                this.startListeners = builder.getStartListeners();
                int n = this.startListeners.size();
                for (int i = 0; i < n; ++i) {
                    StartListener startListener = (StartListener)this.startListeners.get(i);
                    startListener.open();
                }
                IntegrationSession integrationSession = IntegrationSession.getInstance(jbpmContext);
                JmsIntegrationService integrationService = JmsIntegrationService.get(jbpmContext);
                Iterator receiveTokenIt = integrationSession.findReceiveTokens(process).iterator();
                while (receiveTokenIt.hasNext()) {
                    Token token = (Token)receiveTokenIt.next();
                    Receive receive = (Receive)token.getNode();
                    integrationService.jmsReceive(receive.getReceiveAction(), token, this);
                }
                Iterator pickTokenIt = integrationSession.findPickTokens(process).iterator();
                while (pickTokenIt.hasNext()) {
                    Token token = (Token)pickTokenIt.next();
                    StructuredActivity.Begin begin = (StructuredActivity.Begin)token.getNode();
                    Pick pick = (Pick)begin.getCompositeActivity();
                    integrationService.jmsReceive(pick.getOnMessages(), token, this);
                }
                Iterator eventTokenIt = integrationSession.findEventTokens(process).iterator();
                while (eventTokenIt.hasNext()) {
                    Token token = (Token)eventTokenIt.next();
                    Scope scope = (Scope)token.getNode();
                    Iterator onEventsIt = scope.getOnEvents().iterator();
                    while (onEventsIt.hasNext()) {
                        OnEvent onEvent = (OnEvent)onEventsIt.next();
                        integrationService.jmsReceive(onEvent.getReceiveAction(), token, this);
                    }
                }
                this.jmsConnection.start();
            }
            catch (JMSException e) {
                this.jmsConnection.close();
                throw e;
            }
        }
        finally {
            initialContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableInboundMessageActivities() throws JMSException {
        Iterator startListenerIt = this.startListeners.iterator();
        while (startListenerIt.hasNext()) {
            StartListener startListener = (StartListener)startListenerIt.next();
            startListener.close();
        }
        this.startListeners = Collections.EMPTY_LIST;
        Map map = this.requestListeners;
        synchronized (map) {
            Iterator requestListenerIt = this.requestListeners.values().iterator();
            while (requestListenerIt.hasNext()) {
                RequestListener requestListener = (RequestListener)requestListenerIt.next();
                requestListener.close();
            }
            this.requestListeners.clear();
        }
        this.closeJmsConnection();
    }

    void createPartnerLinkEntries(InitialContext initialContext, BpelProcessDefinition process) throws NamingException {
        Map scopeDescriptors = new ScopeMatcher().match(process, this.getAppDescriptor());
        PartnerLinkEntriesBuilder builder = new PartnerLinkEntriesBuilder(scopeDescriptors, IntegrationControl.getJmsContext(initialContext), this.integrationServiceFactory.getDefaultDestination());
        builder.visit(process);
        this.partnerLinkEntriesById = builder.getPartnerLinkEntriesById();
        this.partnerLinkEntriesByHandle = builder.getPartnerLinkEntriesByHandle();
    }

    void createJmsConnection(InitialContext initialContext) throws NamingException, JMSException {
        ConnectionFactory jmsConnectionFactory;
        block2: {
            Context jmsContext = IntegrationControl.getJmsContext(initialContext);
            try {
                jmsConnectionFactory = (ConnectionFactory)jmsContext.lookup(CONNECTION_FACTORY_NAME);
                log.debug((Object)"retrieved jms connection factory: IntegrationConnectionFactory");
            }
            catch (NameNotFoundException e) {
                log.debug((Object)"jms connection factory not found: IntegrationConnectionFactory");
                log.debug((Object)"falling back to default from integration service factory");
                jmsConnectionFactory = this.integrationServiceFactory.getDefaultConnectionFactory();
                if (jmsConnectionFactory != null) break block2;
                throw e;
            }
        }
        this.jmsConnection = jmsConnectionFactory.createConnection();
    }

    void closeJmsConnection() throws JMSException {
        if (this.jmsConnection != null) {
            this.jmsConnection.close();
            this.jmsConnection = null;
        }
    }

    void reset() {
        this.appDescriptor = null;
        this.partnerLinkEntriesById = Collections.EMPTY_MAP;
        this.partnerLinkEntriesByHandle = Collections.EMPTY_MAP;
        this.startListeners = Collections.EMPTY_LIST;
        this.requestListeners.clear();
        this.outstandingRequests.clear();
        this.partnerClients.clear();
    }

    static Context getJmsContext(InitialContext initialContext) {
        Context jmsContext;
        String jmsContextName = DEFAULT_JMS_CONTEXT;
        if (JbpmConfiguration.Configs.hasObject((String)NAME_JMS_CONTEXT)) {
            jmsContextName = JbpmConfiguration.Configs.getString((String)NAME_JMS_CONTEXT);
        }
        try {
            jmsContext = (Context)initialContext.lookup(jmsContextName);
        }
        catch (NamingException e) {
            log.debug((Object)"could not retrieve jms context, falling back to initial context");
            jmsContext = initialContext;
        }
        return jmsContext;
    }
}

