/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.jms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.endpointref.EndpointReference;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.integration.IntegrationService;
import org.jbpm.bpel.integration.client.SoapClient;
import org.jbpm.bpel.integration.def.Correlations;
import org.jbpm.bpel.integration.def.InvokeAction;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.integration.def.ReplyAction;
import org.jbpm.bpel.integration.exe.PartnerLinkInstance;
import org.jbpm.bpel.integration.jms.IntegrationControl;
import org.jbpm.bpel.integration.jms.JmsIntegrationServiceFactory;
import org.jbpm.bpel.integration.jms.OutstandingRequest;
import org.jbpm.bpel.integration.jms.PartnerLinkEntry;
import org.jbpm.bpel.integration.jms.RequestListener;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.exe.Token;
import org.jbpm.svc.Services;

public class JmsIntegrationService
implements IntegrationService {
    private final JmsIntegrationServiceFactory integrationServiceFactory;
    private List requestListeners = new ArrayList();
    private static final Log log = LogFactory.getLog((Class)JmsIntegrationService.class);
    private static final long serialVersionUID = 1L;

    JmsIntegrationService(JmsIntegrationServiceFactory integrationServiceFactory) {
        this.integrationServiceFactory = integrationServiceFactory;
    }

    public void receive(ReceiveAction receiveAction, Token token) {
        JmsIntegrationService.assignIdIfTransient(token);
        IntegrationControl integrationControl = this.getIntegrationControl(token);
        try {
            this.jmsReceive(receiveAction, token, integrationControl);
        }
        catch (JMSException e) {
            throw new BpelException("could not create request listener", (Exception)((Object)e));
        }
    }

    void jmsReceive(ReceiveAction receiveAction, Token token, IntegrationControl integrationControl) throws JMSException {
        Session jmsSession = JmsIntegrationService.createJmsSession(integrationControl);
        this.createRequestListener(receiveAction, token, integrationControl, jmsSession);
    }

    public void receive(List receivers, Token token) {
        JmsIntegrationService.assignIdIfTransient(token);
        IntegrationControl integrationControl = this.getIntegrationControl(token);
        try {
            this.jmsReceive(receivers, token, integrationControl);
        }
        catch (JMSException e) {
            throw new BpelException("could not create request listeners", (Exception)((Object)e));
        }
    }

    void jmsReceive(List receivers, Token token, IntegrationControl integrationControl) throws JMSException {
        Session jmsSession = JmsIntegrationService.createJmsSession(integrationControl);
        Iterator receiverIt = receivers.iterator();
        while (receiverIt.hasNext()) {
            ReceiveAction receiveAction = (ReceiveAction)receiverIt.next();
            this.createRequestListener(receiveAction, token, integrationControl, jmsSession);
        }
    }

    private static void assignIdIfTransient(Token token) {
        if (token.getId() == 0L) {
            Services.assignId((Object)token);
        }
    }

    private static Session createJmsSession(IntegrationControl integrationControl) throws JMSException {
        return integrationControl.getJmsConnection().createSession(false, 2);
    }

    private void createRequestListener(ReceiveAction receiveAction, Token token, IntegrationControl integrationControl, Session jmsSession) throws JMSException {
        String selector = JmsIntegrationService.formatSelector(receiveAction, token);
        Destination destination = integrationControl.getPartnerLinkEntry(receiveAction.getPartnerLink()).getDestination();
        MessageConsumer consumer = jmsSession.createConsumer(destination, selector);
        RequestListener requestListener = new RequestListener(receiveAction.getId(), token.getId(), consumer);
        integrationControl.addRequestListener(requestListener);
        this.requestListeners.add(requestListener);
        log.debug((Object)("created request listener: receiver=" + receiveAction + ", token=" + token));
    }

    private static String formatSelector(ReceiveAction receiveAction, Token token) {
        StringBuffer selector = new StringBuffer();
        selector.append("jbpm_bpel_partnerLinkId").append('=').append(receiveAction.getPartnerLink().getId());
        selector.append(" AND ").append("jbpm_bpel_operationName").append("='").append(receiveAction.getOperation().getName()).append('\'');
        Correlations correlations = receiveAction.getCorrelations();
        if (correlations != null) {
            Iterator propertyEntryIt = correlations.getReceptionProperties(token).entrySet().iterator();
            while (propertyEntryIt.hasNext()) {
                Map.Entry propertyEntry = propertyEntryIt.next();
                QName propertyName = (QName)propertyEntry.getKey();
                selector.append(" AND ").append(propertyName.getLocalPart()).append("='").append(propertyEntry.getValue()).append('\'');
            }
        }
        return selector.toString();
    }

    public void endReception(ReceiveAction receiveAction, Token token) {
        this.closeRequestListener(receiveAction, token, this.getIntegrationControl(token));
    }

    public void endReception(List receivers, Token token) {
        IntegrationControl integrationControl = this.getIntegrationControl(token);
        Iterator receiverIt = receivers.iterator();
        while (receiverIt.hasNext()) {
            ReceiveAction receiveAction = (ReceiveAction)receiverIt.next();
            this.closeRequestListener(receiveAction, token, integrationControl);
        }
    }

    private void closeRequestListener(ReceiveAction receiveAction, Token token, IntegrationControl integrationControl) {
        try {
            this.jmsEndReception(receiveAction, token, integrationControl);
        }
        catch (JMSException e) {
            log.debug((Object)"could not close request listener", (Throwable)e);
        }
    }

    void jmsEndReception(ReceiveAction receiveAction, Token token, IntegrationControl integrationControl) throws JMSException {
        RequestListener requestListener = integrationControl.removeRequestListener(receiveAction, token);
        if (requestListener == null) {
            return;
        }
        this.requestListeners.remove(requestListener);
        requestListener.close();
    }

    public void reply(ReplyAction replyAction, Token token) {
        try {
            this.replyOutstandingRequest(replyAction, token);
        }
        catch (JMSException e) {
            throw new BpelException("could not send reply", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyOutstandingRequest(ReplyAction replyAction, Token token) throws JMSException {
        Map parts = replyAction.writeMessage(token);
        IntegrationControl integrationControl = this.getIntegrationControl(token);
        OutstandingRequest request = integrationControl.removeOutstandingRequest(replyAction, token);
        Session jmsSession = JmsIntegrationService.createJmsSession(integrationControl);
        try {
            request.sendReply(parts, replyAction.getFaultName(), jmsSession);
        }
        finally {
            jmsSession.close();
        }
    }

    public void invoke(InvokeAction invokeAction, Token token) {
        Map inputParts = invokeAction.writeMessage(token);
        PartnerLinkDefinition partnerLinkDef = invokeAction.getPartnerLink();
        PartnerLinkInstance partnerLinkInst = partnerLinkDef.getInstance(token);
        IntegrationControl integrationControl = this.getIntegrationControl(token);
        SoapClient partnerClient = integrationControl.getPartnerClient(partnerLinkInst);
        Operation operation = invokeAction.getOperation();
        String operationName = operation.getName();
        if (operation.getOutput() != null) {
            Map outputParts;
            try {
                outputParts = partnerClient.call(operationName, inputParts);
            }
            catch (BpelFaultException e) {
                JmsIntegrationService.replaceMessageType(e, token);
                throw e;
            }
            log.debug((Object)("invoked: partnerLink=" + partnerLinkDef.getName() + ", operation=" + operationName + ", output=" + outputParts));
            invokeAction.readMessage(outputParts, token);
        } else {
            partnerClient.callOneWay(operationName, inputParts);
            log.debug((Object)("invoked: partnerLink=" + partnerLinkDef.getName() + ", operation=" + operationName));
        }
    }

    private static void replaceMessageType(BpelFaultException faultException, Token token) {
        MessageValue faultData = faultException.getFaultInstance().getMessageValue();
        BpelProcessDefinition processDefinition = (BpelProcessDefinition)token.getProcessInstance().getProcessDefinition();
        MessageType persistentType = processDefinition.getImports().getMessageType(faultData.getType().getName());
        faultData.setType(persistentType);
    }

    public EndpointReference getMyReference(PartnerLinkDefinition partnerLink, Token token) {
        IntegrationControl integrationControl = this.getIntegrationControl(token);
        PartnerLinkEntry partnerLinkEntry = integrationControl.getPartnerLinkEntry(partnerLink);
        return partnerLinkEntry.getMyReference();
    }

    public void close() {
        JbpmContext jbpmContext = this.integrationServiceFactory.getJbpmConfiguration().getCurrentJbpmContext();
        if (jbpmContext.getServices().getTxService().isRollbackOnly()) {
            this.closeRequestListeners();
        } else {
            try {
                this.openRequestListeners();
            }
            catch (JMSException e) {
                throw new BpelException("could not open subsequent request listeners", (Exception)((Object)e));
            }
        }
    }

    private void openRequestListeners() throws JMSException {
        int n = this.requestListeners.size();
        for (int i = 0; i < n; ++i) {
            RequestListener requestListener = (RequestListener)this.requestListeners.get(i);
            requestListener.open();
        }
    }

    private void closeRequestListeners() {
        int n = this.requestListeners.size();
        for (int i = 0; i < n; ++i) {
            RequestListener requestListener = (RequestListener)this.requestListeners.get(i);
            try {
                requestListener.close();
                continue;
            }
            catch (JMSException e) {
                log.debug((Object)"could not close request listener", (Throwable)e);
            }
        }
    }

    public IntegrationControl getIntegrationControl(Token token) {
        return this.integrationServiceFactory.getIntegrationControl(token.getProcessInstance().getProcessDefinition());
    }

    public static JmsIntegrationService get(JbpmContext jbpmContext) {
        return (JmsIntegrationService)jbpmContext.getServices().getService("integration");
    }
}

