/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.jms;

import java.util.Enumeration;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.integration.jms.IntegrationControl;
import org.jbpm.bpel.integration.jms.JmsIntegrationService;
import org.jbpm.bpel.integration.jms.OutstandingRequest;
import org.jbpm.bpel.persistence.db.IntegrationSession;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class RequestListener
implements MessageListener {
    private final long receiverId;
    private final long tokenId;
    private MessageConsumer consumer;
    private static final Log log = LogFactory.getLog((Class)RequestListener.class);

    RequestListener(long receiverId, long tokenId, MessageConsumer consumer) {
        this.receiverId = receiverId;
        this.tokenId = tokenId;
        this.consumer = consumer;
    }

    long getReceiverId() {
        return this.receiverId;
    }

    long getTokenId() {
        return this.tokenId;
    }

    public void open() throws JMSException {
        this.consumer.setMessageListener((MessageListener)this);
        log.debug((Object)("opened request listener: receiver=" + this.receiverId + ", token=" + this.tokenId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message request) {
        if (!(request instanceof ObjectMessage)) {
            log.error((Object)("received non-object jms message: " + request));
            return;
        }
        boolean acknowledgeMessage = true;
        JbpmContext jbpmContext = JbpmConfiguration.getInstance().createJbpmContext();
        try {
            log.debug((Object)("received request: " + RequestListener.messageToString(request)));
            Token token = jbpmContext.loadTokenForUpdate(this.tokenId);
            ReceiveAction receiveAction = IntegrationSession.getInstance(jbpmContext).loadReceiver(this.receiverId);
            ObjectMessage objectRequest = (ObjectMessage)request;
            Map parts = (Map)((Object)objectRequest.getObject());
            try {
                receiveAction.readMessage(parts, token);
                if (receiveAction.getOperation().getOutput() != null) {
                    OutstandingRequest outRequest = new OutstandingRequest((Queue)request.getJMSReplyTo(), request.getJMSMessageID());
                    IntegrationControl integrationControl = JmsIntegrationService.get(jbpmContext).getIntegrationControl(token);
                    integrationControl.addOutstandingRequest(receiveAction, token, outRequest);
                }
                receiveAction.getInboundMessageActivity().messageReceived(receiveAction, token);
            }
            catch (BpelFaultException e) {
                log.debug((Object)"caught exception while processing request", (Throwable)((Object)e));
                token.getNode().raiseException((Throwable)((Object)e), new ExecutionContext(token));
            }
        }
        catch (Exception e) {
            log.error((Object)"could not resume process execution", (Throwable)e);
            acknowledgeMessage = false;
            jbpmContext.setRollbackOnly();
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                log.error((Object)"could not close jbpm context", (Throwable)e);
                acknowledgeMessage = false;
            }
        }
        if (acknowledgeMessage) {
            try {
                request.acknowledge();
            }
            catch (JMSException e) {
                log.error((Object)"could not acknowledge message", (Throwable)e);
            }
        }
    }

    public void close() throws JMSException {
        this.consumer.close();
        this.consumer = null;
        log.debug((Object)("closed request listener: receiver=" + this.receiverId + ", token=" + this.tokenId));
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        try {
            builder.append("queue", (Object)((QueueReceiver)this.consumer).getQueue()).append("selector", (Object)this.consumer.getMessageSelector());
        }
        catch (JMSException e) {
            log.debug((Object)"could not fill request listener fields", (Throwable)e);
        }
        return builder.toString();
    }

    public static String messageToString(Message message) throws JMSException {
        StringBuffer result = new StringBuffer();
        result.append("id=").append(message.getJMSMessageID()).append(", destination=").append(message.getJMSDestination());
        Destination replyTo = message.getJMSReplyTo();
        if (replyTo != null) {
            result.append(", replyTo=").append(replyTo).append(", correlationId=").append(message.getJMSCorrelationID());
        }
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            result.append(", ").append(propertyName).append('=').append(message.getObjectProperty(propertyName));
        }
        return result.toString();
    }

    public static class Key {
        private final long receiverId;
        private final long tokenId;

        Key(long receiverId, long tokenId) {
            this.receiverId = receiverId;
            this.tokenId = tokenId;
        }

        public long getReceiverId() {
            return this.receiverId;
        }

        public long getTokenId() {
            return this.tokenId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.receiverId == that.receiverId && this.tokenId == that.tokenId;
        }

        public int hashCode() {
            return new HashCodeBuilder(863, 5).append(this.receiverId).append(this.tokenId).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("receiverId", this.receiverId).append("tokenId", this.tokenId).toString();
        }
    }
}

