/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.jms;

import java.io.Serializable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.integration.jms.IntegrationControl;
import org.jbpm.bpel.integration.jms.JmsIntegrationServiceFactory;
import org.jbpm.bpel.integration.jms.OutstandingRequest;
import org.jbpm.bpel.integration.jms.RequestListener;
import org.jbpm.bpel.persistence.db.IntegrationSession;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class StartListener
implements MessageListener {
    private final long processId;
    private final long receiverId;
    private MessageConsumer consumer;
    private static final Log log = LogFactory.getLog((Class)StartListener.class);

    StartListener(long processId, long receiverId, MessageConsumer consumer) {
        this.processId = processId;
        this.receiverId = receiverId;
        this.consumer = consumer;
    }

    public void open() throws JMSException {
        this.consumer.setMessageListener((MessageListener)this);
        log.debug((Object)("opened start listener: process=" + this.processId + ", receiver=" + this.receiverId));
    }

    public long getReceiverId() {
        return this.receiverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message request) {
        if (!(request instanceof ObjectMessage)) {
            log.error((Object)("received non-object jms message: " + request));
            return;
        }
        boolean acknowledgeMessage = true;
        JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance();
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            log.debug((Object)("received request: " + RequestListener.messageToString(request)));
            BpelProcessDefinition processDefinition = (BpelProcessDefinition)((Object)jbpmContext.getSession().load(BpelProcessDefinition.class, (Serializable)new Long(this.processId)));
            ProcessInstance instance = processDefinition.createProcessInstance();
            ReceiveAction receiveAction = IntegrationSession.getInstance(jbpmContext).loadReceiver(this.receiverId);
            Token rootToken = instance.getRootToken();
            try {
                Map inputParts = (Map)((Object)((ObjectMessage)request).getObject());
                receiveAction.readMessage(inputParts, rootToken);
                if (receiveAction.getOperation().getOutput() != null) {
                    OutstandingRequest outRequest = new OutstandingRequest((Queue)request.getJMSReplyTo(), request.getJMSMessageID());
                    IntegrationControl integrationControl = JmsIntegrationServiceFactory.getInstance(jbpmConfiguration).getIntegrationControl(processDefinition);
                    integrationControl.addOutstandingRequest(receiveAction, rootToken, outRequest);
                }
                processDefinition.messageReceived(receiveAction, rootToken);
            }
            catch (BpelFaultException e) {
                log.debug((Object)"caught exception while processing request", (Throwable)((Object)e));
                processDefinition.getGlobalScope().raiseException((Throwable)((Object)e), new ExecutionContext(rootToken));
            }
            jbpmContext.save(instance);
        }
        catch (Exception e) {
            log.error((Object)"could not start process instance", (Throwable)e);
            acknowledgeMessage = false;
            jbpmContext.setRollbackOnly();
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                log.debug((Object)"could not close jbpm context", (Throwable)e);
                acknowledgeMessage = false;
            }
        }
        if (acknowledgeMessage) {
            try {
                request.acknowledge();
            }
            catch (JMSException e) {
                log.error((Object)"could not acknowledge message", (Throwable)e);
            }
        }
    }

    public void close() throws JMSException {
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
            log.debug((Object)("closed start listener: process=" + this.processId + ", receiver=" + this.receiverId));
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        try {
            builder.append("queue", (Object)((QueueReceiver)this.consumer).getQueue()).append("selector", (Object)this.consumer.getMessageSelector());
        }
        catch (JMSException e) {
            log.debug((Object)"could not fill request listener fields", (Throwable)e);
        }
        return builder.toString();
    }
}

