/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.server;

import com.ibm.wsdl.extensions.soap.SOAPConstants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.servlet.ServletContext;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.integration.jms.IntegrationControl;
import org.jbpm.bpel.integration.jms.PartnerLinkEntry;
import org.jbpm.bpel.integration.jms.RequestListener;
import org.jbpm.bpel.integration.server.EndpointMetadata;
import org.jbpm.bpel.integration.server.EndpointMetadataLookup;
import org.jbpm.bpel.integration.soap.MessageDirection;
import org.jbpm.bpel.integration.soap.SoapBindConstants;
import org.jbpm.bpel.integration.soap.SoapFormatter;
import org.jbpm.bpel.sublang.def.Query;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.wsdl.PropertyAlias;
import org.jbpm.bpel.wsdl.util.WsdlUtil;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapHandler
implements Handler {
    private QName[] headers;
    private String partnerLinkHandle;
    private long responseTimeout;
    private long oneWayTimeout;
    private JbpmConfiguration jbpmConfiguration;
    private IntegrationControl integrationControl;
    private SoapFormatter formatter;
    private static final Log log = LogFactory.getLog((Class)SoapHandler.class);
    public static final String PARTNER_LINK_HANDLE_PARAM = "partnerLinkHandle";
    public static final String RESPONSE_TIMEOUT_PARAM = "responseTimeout";
    public static final String ONE_WAY_TIMEOUT_PARAM = "oneWayTimeout";
    public static final String JBPM_CONFIGURATION_PARAM = "jbpm.configuration.resource";
    static final String OPERATION_NAME_PROP = "jbpm.bpel.operation.name";
    static final String MESSAGE_PARTS_PROP = "jbpm.bpel.message.parts";
    static final String FAULT_NAME_PROP = "jbpm.bpel.fault.name";
    static final String FAULT_EXCEPTION_PROP = "jbpm.bpel.fault.exception";
    static final String INTEGRATION_CONTROL_ATTR = "jbpm.bpel.integration.control";
    public static final String ENDPOINT_METADATA_LOOKUPS = "jbpm.bpel.endpoint.metadata.lookups";

    public SoapHandler() {
    }

    SoapHandler(String partnerLinkHandle, IntegrationControl integrationControl, Binding binding) {
        this.partnerLinkHandle = partnerLinkHandle;
        this.jbpmConfiguration = JbpmConfiguration.getInstance();
        this.integrationControl = integrationControl;
        this.formatter = new SoapFormatter(binding);
    }

    public void init(HandlerInfo handlerInfo) throws JAXRPCException {
        String configurationName;
        String oneWayTimeoutText;
        this.headers = handlerInfo.getHeaders();
        Map handlerConfig = handlerInfo.getHandlerConfig();
        this.partnerLinkHandle = (String)handlerConfig.get(PARTNER_LINK_HANDLE_PARAM);
        if (this.partnerLinkHandle == null) {
            throw new JAXRPCException("Parameter 'partnerLinkHandle' is mandatory in the handler configuration");
        }
        String receiveTimeoutText = (String)handlerConfig.get(RESPONSE_TIMEOUT_PARAM);
        if (receiveTimeoutText != null) {
            try {
                this.responseTimeout = Long.parseLong(receiveTimeoutText);
            }
            catch (NumberFormatException e) {
                throw new JAXRPCException("Parameter 'responseTimeout' does not contain a parsable long", (Throwable)e);
            }
        }
        if ((oneWayTimeoutText = (String)handlerConfig.get(ONE_WAY_TIMEOUT_PARAM)) != null) {
            try {
                this.oneWayTimeout = Long.parseLong(oneWayTimeoutText);
            }
            catch (NumberFormatException e) {
                throw new JAXRPCException("Parameter 'oneWayTimeout' does not contain a parsable long", (Throwable)e);
            }
        }
        this.jbpmConfiguration = (configurationName = (String)handlerConfig.get(JBPM_CONFIGURATION_PARAM)) != null ? JbpmConfiguration.getInstance((String)configurationName) : JbpmConfiguration.getInstance();
    }

    public void destroy() {
    }

    public QName[] getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(MessageContext messageContext) throws JAXRPCException, SOAPFaultException {
        block16: {
            JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
            try {
                this.lookupEndpointMetadata(jbpmContext, messageContext);
                Session jmsSession = this.integrationControl.getJmsConnection().createSession(false, 2);
                try {
                    SOAPMessage soapMessage = ((SOAPMessageContext)messageContext).getMessage();
                    ObjectMessage jmsRequest = this.sendRequest(soapMessage, jmsSession, jbpmContext);
                    TemporaryQueue replyTo = (TemporaryQueue)jmsRequest.getJMSReplyTo();
                    if (replyTo == null) break block16;
                    try {
                        ObjectMessage jmsResponse = this.receiveResponse(jmsSession, replyTo);
                        messageContext.setProperty(OPERATION_NAME_PROP, (Object)jmsRequest.getStringProperty("jbpm_bpel_operationName"));
                        messageContext.setProperty(MESSAGE_PARTS_PROP, (Object)jmsResponse.getObject());
                        String faultName = jmsResponse.getStringProperty("jbpm_bpel_faultName");
                        if (faultName != null) {
                            messageContext.setProperty(FAULT_NAME_PROP, (Object)faultName);
                            throw new SOAPFaultException(SoapBindConstants.CLIENT_FAULTCODE, "Business logic fault", null, null);
                        }
                    }
                    finally {
                        replyTo.delete();
                    }
                }
                finally {
                    jmsSession.close();
                }
            }
            catch (SOAPFaultException e) {
                log.debug((Object)"request caused a fault", (Throwable)e);
                messageContext.setProperty(FAULT_EXCEPTION_PROP, (Object)e);
            }
            catch (SOAPException e) {
                log.debug((Object)"incoming soap message carries invalid content", (Throwable)e);
                messageContext.setProperty(FAULT_EXCEPTION_PROP, (Object)new SOAPFaultException(SoapBindConstants.CLIENT_FAULTCODE, e.getMessage(), null, null));
            }
            catch (JMSException e) {
                throw new JAXRPCException("message delivery failed", (Throwable)e);
            }
            finally {
                jbpmContext.close();
            }
        }
        return true;
    }

    private void lookupEndpointMetadata(JbpmContext jbpmContext, MessageContext messageContext) {
        EndpointMetadataLookup endpointMetadataLookup = SoapHandler.getEndpointMetadataLookup(jbpmContext, messageContext.getClass());
        EndpointMetadata endpointMetadata = endpointMetadataLookup.lookupMetaData(messageContext);
        ServletContext servletContext = endpointMetadata.getServletContext();
        this.integrationControl = (IntegrationControl)servletContext.getAttribute(INTEGRATION_CONTROL_ATTR);
        Definition definition = endpointMetadata.getWsdlDefinition();
        Service service = definition.getService(endpointMetadata.getServiceName());
        Port port = service.getPort(endpointMetadata.getPortName());
        this.formatter = new SoapFormatter(port.getBinding());
        this.formatter.setFaultFormat(endpointMetadata.getFaultFormat());
    }

    private static EndpointMetadataLookup getEndpointMetadataLookup(JbpmContext jbpmContext, Class messageContextClass) {
        Map endpointMetadataLookups = (Map)jbpmContext.getObjectFactory().createObject(ENDPOINT_METADATA_LOOKUPS);
        String messageContextClassName = messageContextClass.getName();
        EndpointMetadataLookup endpointMetadataLookup = (EndpointMetadataLookup)endpointMetadataLookups.get(messageContextClassName);
        log.debug((Object)("using custom endpoint metadata lookup: messageContext=" + messageContextClassName + ", endpointMetadataLookup=" + endpointMetadataLookup.getClass().getName()));
        return endpointMetadataLookup;
    }

    public boolean handleResponse(MessageContext messageContext) throws JAXRPCException {
        Map parts = (Map)messageContext.getProperty(MESSAGE_PARTS_PROP);
        SOAPFaultException faultException = (SOAPFaultException)((Object)messageContext.getProperty(FAULT_EXCEPTION_PROP));
        if (parts == null && faultException == null) {
            return true;
        }
        String operationName = (String)messageContext.getProperty(OPERATION_NAME_PROP);
        SOAPMessage soapMessage = ((SOAPMessageContext)messageContext).getMessage();
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            this.lookupEndpointMetadata(jbpmContext, messageContext);
            SOAPEnvelope envelope = soapMessage.getSOAPPart().getEnvelope();
            SOAPBody body = envelope.getBody();
            body.detachNode();
            body = envelope.addBody();
            if (faultException == null) {
                this.writeResponse(operationName, soapMessage, parts);
            } else {
                String faultName = (String)messageContext.getProperty(FAULT_NAME_PROP);
                this.writeFault(operationName, soapMessage, faultException, faultName, parts);
            }
        }
        catch (SOAPException e) {
            throw new JAXRPCException("could not compose outbound soap message", (Throwable)e);
        }
        finally {
            jbpmContext.close();
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) throws JAXRPCException {
        return true;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public long getOneWayTimeout() {
        return this.oneWayTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectMessage sendRequest(SOAPMessage soapMessage, Session jmsSession, JbpmContext jbpmContext) throws SOAPException, JMSException {
        ObjectMessage jmsRequest = jmsSession.createObjectMessage();
        PartnerLinkEntry partnerLinkEntry = this.integrationControl.getPartnerLinkEntry(this.partnerLinkHandle);
        long partnerLinkId = partnerLinkEntry.getId();
        jmsRequest.setLongProperty("jbpm_bpel_partnerLinkId", partnerLinkId);
        Operation operation = this.determineOperation(soapMessage);
        if (operation == null) {
            throw new SOAPException("could not determine operation to perform");
        }
        String operationName = operation.getName();
        jmsRequest.setStringProperty("jbpm_bpel_operationName", operationName);
        log.debug((Object)("received request: partnerLink=" + this.partnerLinkHandle + ", operation=" + operationName));
        HashMap requestParts = new HashMap();
        this.formatter.readMessage(operationName, soapMessage, requestParts, MessageDirection.INPUT);
        jmsRequest.setObject(requestParts);
        BpelProcessDefinition process = this.integrationControl.getAppDescriptor().findProcessDefinition(jbpmContext);
        MessageType requestType = process.getImports().getMessageType(operation.getInput().getMessage().getQName());
        SoapHandler.fillCorrelationProperties(requestParts, jmsRequest, requestType.getPropertyAliases());
        MessageProducer producer = jmsSession.createProducer(partnerLinkEntry.getDestination());
        try {
            if (operation.getOutput() != null) {
                TemporaryQueue replyTo = jmsSession.createTemporaryQueue();
                jmsRequest.setJMSReplyTo((Destination)replyTo);
                producer.setTimeToLive(this.responseTimeout);
            } else {
                producer.setTimeToLive(this.oneWayTimeout);
            }
            producer.send((Message)jmsRequest);
            log.debug((Object)("sent request: " + RequestListener.messageToString((Message)jmsRequest)));
            ObjectMessage objectMessage = jmsRequest;
            return objectMessage;
        }
        finally {
            producer.close();
        }
    }

    private Operation determineOperation(SOAPMessage soapMessage) throws SOAPException {
        Binding binding = this.formatter.getBinding();
        SOAPBinding soapBinding = (SOAPBinding)WsdlUtil.getExtension(binding.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_BINDING);
        String style = soapBinding.getStyle();
        if (style == null) {
            style = "document";
        }
        PortType portType = binding.getPortType();
        SOAPElement bodyElement = XmlUtil.getElement((SOAPElement)soapMessage.getSOAPBody());
        if (style.equals("rpc")) {
            String operationName = bodyElement.getLocalName();
            return portType.getOperation(operationName, null, null);
        }
        List operations = portType.getOperations();
        int n = operations.size();
        for (int i = 0; i < n; ++i) {
            Operation operation = (Operation)operations.get(i);
            javax.wsdl.Message inputMessage = operation.getInput().getMessage();
            QName docLitElementName = WsdlUtil.getDocLitElementName(inputMessage);
            if (!XmlUtil.nodeQNameEquals((Node)bodyElement, docLitElementName)) continue;
            return operation;
        }
        return null;
    }

    private static void fillCorrelationProperties(Map requestParts, ObjectMessage jmsRequest, Map propertyAliases) throws JMSException {
        if (propertyAliases == null) {
            return;
        }
        Iterator aliasEntryIt = propertyAliases.entrySet().iterator();
        while (aliasEntryIt.hasNext()) {
            Map.Entry aliasEntry = aliasEntryIt.next();
            QName propertyName = (QName)aliasEntry.getKey();
            PropertyAlias alias = (PropertyAlias)aliasEntry.getValue();
            String partName = alias.getPart();
            Object value = requestParts.get(partName);
            if (value == null) {
                log.debug((Object)("message part not found, cannot get property value: property=" + propertyName + ", part=" + partName));
                continue;
            }
            Query query = alias.getQuery();
            if (query != null) {
                try {
                    value = query.getEvaluator().evaluate((Element)value);
                }
                catch (BpelFaultException e) {
                    log.debug((Object)("query evaluation failed, cannot get property value: property=" + propertyName + ", part=" + partName + ", query=" + query.getText()), (Throwable)((Object)e));
                    continue;
                }
            }
            jmsRequest.setObjectProperty(propertyName.getLocalPart(), value instanceof Node ? DatatypeUtil.toString((Node)value) : value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectMessage receiveResponse(Session jmsSession, TemporaryQueue replyTo) throws JMSException, SOAPFaultException {
        MessageConsumer consumer = jmsSession.createConsumer((Destination)replyTo);
        try {
            log.debug((Object)("listening for response: " + replyTo.getQueueName()));
            ObjectMessage jmsResponse = (ObjectMessage)consumer.receive(this.responseTimeout);
            if (jmsResponse == null) {
                log.debug((Object)("response timeout expired: " + replyTo.getQueueName()));
                throw new SOAPFaultException(SoapBindConstants.SERVER_FAULTCODE, "The service is not in an appropiate state for the requested operation", null, null);
            }
            jmsResponse.acknowledge();
            log.debug((Object)("received response: " + RequestListener.messageToString((Message)jmsResponse)));
            ObjectMessage objectMessage = jmsResponse;
            return objectMessage;
        }
        finally {
            consumer.close();
        }
    }

    protected void writeResponse(String operationName, SOAPMessage soapMessage, Map responseParts) throws SOAPException {
        this.formatter.writeMessage(operationName, soapMessage, responseParts, MessageDirection.OUTPUT);
    }

    protected void writeFault(String operationName, SOAPMessage soapMessage, SOAPFaultException faultException, String faultName, Map faultParts) throws SOAPException {
        this.formatter.writeFault(operationName, soapMessage, faultException.getFaultCode(), faultException.getFaultString(), faultName, faultParts);
    }
}

