/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import org.jbpm.bpel.graph.def.Import;
import org.jbpm.bpel.par.DefDescriptor;
import org.jbpm.bpel.xml.DefaultProblemHandler;
import org.jbpm.bpel.xml.ErrorHandlerAdapter;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.jpdl.xml.Problem;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefDescriptorReader {
    private static final DefDescriptorReader INSTANCE = new DefDescriptorReader();
    private ProblemHandler problemHandler;

    protected DefDescriptorReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DefDescriptor defDescriptor, InputSource input) {
        DocumentBuilder builder = XmlUtil.getDocumentBuilder();
        ProblemHandler problemHandler = this.getProblemHandler();
        ErrorHandlerAdapter problemAdapter = new ErrorHandlerAdapter(problemHandler);
        builder.setErrorHandler(problemAdapter);
        try {
            Element definitionElem = builder.parse(input).getDocumentElement();
            if (problemHandler.getProblemCount() > 0) {
                return;
            }
            String location = definitionElem.getAttribute("location");
            defDescriptor.setLocation(location);
            Element importsElem = XmlUtil.getElement(definitionElem, "http://jbpm.org/bpel", "imports");
            if (importsElem != null) {
                this.readImports(importsElem, defDescriptor);
            }
        }
        catch (SAXException e) {
            problemHandler.add(new Problem(2, "definition descriptor contains invalid xml", (Throwable)e));
        }
        catch (IOException e) {
            problemHandler.add(new Problem(2, "definition descriptor is not readable", (Throwable)e));
        }
        finally {
            builder.setErrorHandler(null);
        }
    }

    public void readImports(Element importsElem, DefDescriptor defDescriptor) {
        Iterator importElemIt = XmlUtil.getElements(importsElem, "http://jbpm.org/bpel");
        while (importElemIt.hasNext()) {
            Object obj = importElemIt.next();
            Element importElem = (Element)obj;
            Import imp = this.readImport(importElem);
            defDescriptor.addImport(imp);
        }
    }

    public Import readImport(Element importElem) {
        Import imp = new Import();
        imp.setLocation(importElem.getAttribute("location"));
        imp.setNamespace(XmlUtil.getAttribute(importElem, "namespace"));
        String importName = importElem.getLocalName();
        Import.Type importType = "wsdl".equals(importName) ? Import.Type.WSDL : Import.Type.XML_SCHEMA;
        imp.setType(importType);
        return imp;
    }

    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    protected ProblemHandler getProblemHandler() {
        if (this.problemHandler == null) {
            this.problemHandler = new DefaultProblemHandler();
        }
        return this.problemHandler;
    }

    public static DefDescriptorReader getInstance() {
        return INSTANCE;
    }
}

