/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.Navigator;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.StringFunction;
import org.jbpm.bpel.xml.util.Duration;
import org.w3c.dom.Node;

public class DatatypeUtil {
    private static final Pattern dateTimePattern = Pattern.compile("(-?\\p{Digit}{4,})-(\\p{Digit}{2})-(\\p{Digit}{2})(?:T(\\p{Digit}{2}):(\\p{Digit}{2}):(\\p{Digit}{2})(?:\\.(\\p{Digit}{1,3})\\p{Digit}*)?)?((?:(?:\\+|-)\\p{Digit}{2}:\\p{Digit}{2})|(Z))?");
    private static final Log log = LogFactory.getLog((Class)DatatypeUtil.class);

    private DatatypeUtil() {
    }

    public static String toString(Object value) {
        return StringFunction.evaluate((Object)value, (Navigator)DocumentNavigator.getInstance());
    }

    public static String toString(Node node) {
        return StringFunction.evaluate((Object)node, (Navigator)DocumentNavigator.getInstance());
    }

    public static boolean toBoolean(Object value) {
        Boolean bool;
        if (value instanceof Boolean) {
            bool = (Boolean)value;
        } else {
            bool = value instanceof Node ? DatatypeUtil.parseBoolean(DatatypeUtil.toString((Node)value)) : (value instanceof String ? DatatypeUtil.parseBoolean((String)value) : null);
            if (bool == null) {
                bool = BooleanFunction.evaluate((Object)value, (Navigator)DocumentNavigator.getInstance());
            }
        }
        return bool;
    }

    public static Calendar toDateTime(Object value) {
        Calendar dateTime = null;
        if (value instanceof Node) {
            dateTime = DatatypeUtil.parseDateTime(DatatypeUtil.toString((Node)value));
        } else if (value instanceof String) {
            dateTime = DatatypeUtil.parseDateTime((String)value);
        }
        if (value instanceof Calendar) {
            dateTime = (Calendar)value;
        } else if (value instanceof Date) {
            dateTime = Calendar.getInstance();
            dateTime.setTime((Date)value);
        } else {
            log.debug((Object)("cannot interpret value as dateTime: " + value));
        }
        return dateTime;
    }

    public static Duration toDuration(Object value) {
        Duration duration = null;
        if (value instanceof Node) {
            duration = Duration.parseDuration(DatatypeUtil.toString((Node)value));
        } else if (value instanceof String) {
            duration = Duration.parseDuration((String)value);
        } else if (value instanceof Duration) {
            duration = (Duration)value;
        } else {
            log.debug((Object)("cannot interpret value as duration: " + value));
        }
        return duration;
    }

    public static Boolean parseBoolean(String text) {
        switch (text.length()) {
            case 1: {
                switch (text.charAt(0)) {
                    case '0': {
                        return Boolean.FALSE;
                    }
                    case '1': {
                        return Boolean.TRUE;
                    }
                }
                break;
            }
            case 4: {
                if (!"true".equals(text)) break;
                return Boolean.TRUE;
            }
            case 5: {
                if (!"false".equals(text)) break;
                return Boolean.FALSE;
            }
        }
        log.debug((Object)("invalid boolean lexical representation: " + text));
        return null;
    }

    public static Calendar parseDateTime(String text) {
        Calendar dateTime = null;
        Matcher matcher = dateTimePattern.matcher(text);
        if (matcher.matches()) {
            dateTime = Calendar.getInstance();
            dateTime.clear();
            dateTime.set(1, Integer.parseInt(matcher.group(1)));
            dateTime.set(2, Integer.parseInt(matcher.group(2)) - 1);
            dateTime.set(5, Integer.parseInt(matcher.group(3)));
            String group = matcher.group(4);
            if (group != null) {
                dateTime.set(11, Integer.parseInt(group));
                dateTime.set(12, Integer.parseInt(matcher.group(5)));
                dateTime.set(13, Integer.parseInt(matcher.group(6)));
                group = matcher.group(7);
                if (group != null) {
                    dateTime.set(14, Integer.parseInt(group));
                }
            }
            if ((group = matcher.group(8)) != null) {
                TimeZone timeZone = group.equals("Z") ? TimeZone.getTimeZone("GMT+00:00") : TimeZone.getTimeZone("GMT" + group);
                dateTime.setTimeZone(timeZone);
            }
            dateTime.setLenient(false);
        } else {
            log.debug((Object)("invalid dateTime lexical representation: " + text));
        }
        return dateTime;
    }
}

