/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml.util;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.function.StringFunction;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.endpointref.EndpointReference;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.bpel.xml.util.LocalEntityResolver;
import org.jbpm.bpel.xml.util.NodeIterator;
import org.jbpm.util.ClassLoaderUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String DEFAULT_NAMESPACE_PREFIX = "defaultNS";
    static final String QUALIFIED_VALUE_PREFIX = "valueNS";
    private static final Log log = LogFactory.getLog((Class)XmlUtil.class);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private static ThreadLocal documentBuilderLocal = new ThreadLocal(){

        protected Object initialValue() {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setCoalescing(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            try {
                factory.setAttribute(XmlUtil.JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
            }
            catch (IllegalArgumentException e) {
                log.fatal((Object)"JAXP implementation does not support XML Schema, BPEL reader will not work properly", (Throwable)e);
                throw new AssertionError((Object)e);
            }
            try {
                factory.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", Boolean.TRUE);
                factory.setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)"JAXP implementation is not Xerces, cannot enable dynamic schema validation, XML documents without schema location will not parse");
            }
            try {
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                documentBuilder.setEntityResolver(new LocalEntityResolver());
                return documentBuilder;
            }
            catch (ParserConfigurationException e) {
                throw new BpelException("could not create document builder", e);
            }
        }
    };
    private static ThreadLocal transformerFactoryLocal = new ThreadLocal(){

        protected Object initialValue() {
            return TransformerFactory.newInstance();
        }
    };

    private XmlUtil() {
    }

    public static Element getElement(org.w3c.dom.Node parent, String localName) {
        return XmlUtil.getElement(parent, null, localName);
    }

    public static SOAPElement getElement(SOAPElement parent, String localName) {
        return XmlUtil.getElement(parent, null, localName);
    }

    public static Element getElement(org.w3c.dom.Node parent, String namespaceURI, String localName) {
        for (org.w3c.dom.Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!QualifiedNameElementPredicate.evaluate(child, namespaceURI, localName)) continue;
            return (Element)child;
        }
        return null;
    }

    public static SOAPElement getElement(SOAPElement parent, String namespaceURI, String localName) {
        Iterator childIt = parent.getChildElements();
        while (childIt.hasNext()) {
            Node child = (Node)childIt.next();
            if (!QualifiedNameElementPredicate.evaluate((org.w3c.dom.Node)child, namespaceURI, localName)) continue;
            return (SOAPElement)child;
        }
        return null;
    }

    public static SOAPElement getElement(SOAPElement parent, QName name) {
        return XmlUtil.getElement(parent, name.getNamespaceURI(), name.getLocalPart());
    }

    public static Element getElement(org.w3c.dom.Node parent) {
        for (org.w3c.dom.Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static SOAPElement getElement(SOAPElement parent) {
        Iterator childIt = parent.getChildElements();
        while (childIt.hasNext()) {
            Object child = childIt.next();
            if (!(child instanceof SOAPElement)) continue;
            return (SOAPElement)child;
        }
        return null;
    }

    public static Iterator getElements(org.w3c.dom.Node parent, String namespaceURI) {
        return IteratorUtils.filteredIterator((Iterator)new NodeIterator(parent), (Predicate)new NamespaceElementPredicate(namespaceURI));
    }

    public static Iterator getElements(org.w3c.dom.Node parent, String namespaceURI, String localName) {
        return IteratorUtils.filteredIterator((Iterator)new NodeIterator(parent), (Predicate)new QualifiedNameElementPredicate(namespaceURI, localName));
    }

    public static String getAttribute(Element ownerElem, String attrName) {
        Attr attribute = ownerElem.getAttributeNode(attrName);
        return attribute != null ? attribute.getValue() : null;
    }

    public static QName parseQName(String prefixedName, org.w3c.dom.Node contextNode) {
        int index = prefixedName.indexOf(58);
        if (index == -1) {
            return new QName(prefixedName);
        }
        String prefix = prefixedName.substring(0, index);
        return new QName(XmlUtil.getNamespaceURI(prefix, contextNode), prefixedName.substring(index + 1), prefix);
    }

    public static boolean nodeQNameEquals(org.w3c.dom.Node node, QName name) {
        return XmlUtil.nodeNamespaceURIEquals(node, name.getNamespaceURI()) && node.getLocalName().equals(name.getLocalPart());
    }

    public static boolean nodeNamespaceURIEquals(org.w3c.dom.Node node, String namespaceURI) {
        String nodeNamespaceURI = node.getNamespaceURI();
        return StringUtils.isEmpty((String)nodeNamespaceURI) ? StringUtils.isEmpty((String)namespaceURI) : nodeNamespaceURI.equals(namespaceURI);
    }

    public static void setObjectValue(org.w3c.dom.Node node, Object value) {
        switch (node.getNodeType()) {
            case 1: {
                XmlUtil.setObjectValue((Element)node, value);
                break;
            }
            case 9: {
                XmlUtil.setObjectValue(((Document)node).getDocumentElement(), value);
                break;
            }
            default: {
                String nil;
                if (value instanceof Element && DatatypeUtil.parseBoolean(nil = ((Element)value).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil")) == Boolean.TRUE) {
                    throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
                }
                node.setNodeValue(DatatypeUtil.toString(value));
            }
        }
    }

    public static void setObjectValue(Element elem, Object value) {
        if (value instanceof org.w3c.dom.Node) {
            if (value instanceof SOAPElement) {
                XmlUtil.copy(elem, (SOAPElement)value);
            } else if (value instanceof Element) {
                XmlUtil.copy(elem, (Element)value);
            } else if (value instanceof Document) {
                XmlUtil.copy(elem, ((Document)value).getDocumentElement());
            } else {
                XmlUtil.setStringValue(elem, ((org.w3c.dom.Node)value).getNodeValue());
            }
        } else if (value instanceof EndpointReference) {
            ((EndpointReference)value).writeServiceRef(elem);
        } else {
            XmlUtil.setStringValue(elem, StringFunction.evaluate((Object)value, (Navigator)DocumentNavigator.getInstance()));
        }
    }

    public static void setStringValue(Element elem, String value) {
        elem.removeAttributeNS("http://jbpm.org/bpel", "initialized");
        org.w3c.dom.Node firstChild = elem.getFirstChild();
        if (firstChild instanceof Text) {
            firstChild.setNodeValue(value);
        } else {
            firstChild = elem.getOwnerDocument().createTextNode(value);
        }
        XmlUtil.removeChildNodes(elem);
        elem.appendChild(firstChild);
    }

    public static void setQNameValue(Element elem, QName value) {
        String prefixedValue;
        String namespace = value.getNamespaceURI();
        if (namespace.length() > 0) {
            String prefix = XmlUtil.getPrefix(namespace, elem);
            if (prefix == null) {
                prefix = XmlUtil.generatePrefix(elem, QUALIFIED_VALUE_PREFIX);
                XmlUtil.addNamespaceDeclaration(elem, namespace, prefix);
            }
            prefixedValue = prefix + ':' + value.getLocalPart();
        } else {
            prefixedValue = value.getLocalPart();
        }
        XmlUtil.setStringValue(elem, prefixedValue);
    }

    public static void setQNameValue(SOAPElement elem, QName value) throws SOAPException {
        String prefixedValue;
        String namespace = value.getNamespaceURI();
        if (namespace.length() > 0) {
            String prefix = XmlUtil.getPrefix(namespace, elem);
            if (prefix == null) {
                prefix = XmlUtil.generatePrefix((Element)elem, QUALIFIED_VALUE_PREFIX);
                elem.addNamespaceDeclaration(prefix, namespace);
            }
            prefixedValue = prefix + ':' + value.getLocalPart();
        } else {
            prefixedValue = value.getLocalPart();
        }
        elem.setValue(prefixedValue);
    }

    public static void copy(Element target, Element source) {
        if (traceEnabled) {
            log.trace((Object)("copying from: " + XmlUtil.toTraceString(source)));
        }
        XmlUtil.removeAttributes(target);
        XmlUtil.copyAttributes(target, source);
        XmlUtil.copyVisibleNamespaces(target, source);
        XmlUtil.removeChildNodes(target);
        XmlUtil.copyChildNodes(target, source);
        if (traceEnabled) {
            log.trace((Object)("copied to: " + XmlUtil.toTraceString(target)));
        }
    }

    private static String toTraceString(Element elem) {
        String namespace = elem.getNamespaceURI();
        String localName = elem.getLocalName();
        if (StringUtils.isEmpty((String)namespace)) {
            return localName;
        }
        StringBuffer traceBuffer = new StringBuffer(namespace.length() + localName.length());
        traceBuffer.append('{').append(namespace).append('}');
        String prefix = elem.getPrefix();
        if (!StringUtils.isEmpty((String)prefix)) {
            traceBuffer.append(prefix).append(':');
        }
        return traceBuffer.append(localName).toString();
    }

    public static void copyVisibleNamespaces(Element target, Element source) {
        XmlUtil.copyNamespaces(target, source);
        org.w3c.dom.Node parent = source.getParentNode();
        while (parent instanceof Element) {
            XmlUtil.copyNamespaces(target, (Element)parent);
            parent = parent.getParentNode();
        }
    }

    public static void copyNamespaces(Element target, Element source) {
        if (!source.hasAttributes()) {
            return;
        }
        NamedNodeMap attributes = source.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node attribute = attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) continue;
            String namespaceURI = attribute.getNodeValue();
            String prefix = attribute.getLocalName();
            if ("xmlns".equals(prefix)) {
                if ("".equals(XmlUtil.getPrefix(namespaceURI, target))) continue;
                XmlUtil.addNamespaceDeclaration(target, namespaceURI);
                if (!traceEnabled) continue;
                log.trace((Object)("added default namespace declaration: " + namespaceURI));
                continue;
            }
            if (prefix.equals(XmlUtil.getPrefix(namespaceURI, target))) continue;
            XmlUtil.addNamespaceDeclaration(target, namespaceURI, prefix);
            if (!traceEnabled) continue;
            log.trace((Object)("added namespace declaration: " + prefix + "->" + namespaceURI));
        }
    }

    public static void copyAttributes(Element target, Element source) {
        if (!source.hasAttributes()) {
            return;
        }
        NamedNodeMap attributes = source.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node attribute = attributes.item(i);
            String namespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) continue;
            target.setAttributeNS(namespaceURI, attribute.getNodeName(), attribute.getNodeValue());
        }
    }

    public static void copyChildNodes(Element target, Element source) {
        Document targetDoc = target.getOwnerDocument();
        block4: for (org.w3c.dom.Node child = source.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    target.appendChild(targetDoc.importNode(child, true));
                    if (!traceEnabled) continue block4;
                    log.trace((Object)("appended element: " + XmlUtil.toTraceString((Element)child)));
                    continue block4;
                }
                case 3: 
                case 4: {
                    target.appendChild(targetDoc.createTextNode(child.getNodeValue()));
                    if (!traceEnabled) continue block4;
                    log.trace((Object)("appended text: " + child.getNodeValue()));
                    continue block4;
                }
                default: {
                    log.debug((Object)("discarding child: " + child));
                }
            }
        }
    }

    public static void copy(Element target, SOAPElement source) {
        if (traceEnabled) {
            log.trace((Object)("copying from: " + XmlUtil.toTraceString((Element)source)));
        }
        XmlUtil.removeAttributes(target);
        XmlUtil.copyAttributes(target, source);
        XmlUtil.copyVisibleNamespaces(target, source);
        XmlUtil.removeChildNodes(target);
        XmlUtil.copyChildNodes(target, source);
        if (traceEnabled) {
            log.trace((Object)("copied to: " + XmlUtil.toTraceString(target)));
        }
    }

    public static void copyVisibleNamespaces(Element target, SOAPElement source) {
        XmlUtil.copyNamespaces(target, source, source.getVisibleNamespacePrefixes());
    }

    public static void copyNamespaces(Element target, SOAPElement source) {
        XmlUtil.copyNamespaces(target, source, source.getNamespacePrefixes());
    }

    private static void copyNamespaces(Element target, SOAPElement source, Iterator prefixIt) {
        while (prefixIt.hasNext()) {
            String namespaceURI;
            String prefix = (String)prefixIt.next();
            if (prefix.equals(XmlUtil.getPrefix(namespaceURI = source.getNamespaceURI(prefix), target))) continue;
            XmlUtil.addNamespaceDeclaration(target, namespaceURI, prefix);
            if (!traceEnabled) continue;
            log.trace((Object)("added namespace declaration: " + prefix + "->" + namespaceURI));
        }
    }

    public static void copyAttributes(Element target, SOAPElement source) {
        if (!source.hasAttributes()) {
            return;
        }
        Iterator attrNameIt = source.getAllAttributes();
        while (attrNameIt.hasNext()) {
            Name attrName = (Name)attrNameIt.next();
            String namespaceURI = attrName.getURI();
            String value = source.getAttributeValue(attrName);
            if (StringUtils.isEmpty((String)namespaceURI)) {
                String localName = attrName.getLocalName();
                target.setAttribute(localName, value);
                if (!traceEnabled) continue;
                log.trace((Object)("set attribute: " + localName));
                continue;
            }
            String qualifiedName = attrName.getQualifiedName();
            target.setAttributeNS(namespaceURI, qualifiedName, value);
            if (!traceEnabled) continue;
            log.trace((Object)("set attribute: " + qualifiedName));
        }
    }

    public static void copyChildNodes(Element target, SOAPElement source) {
        if (!source.hasChildNodes()) {
            return;
        }
        Iterator childIt = source.getChildElements();
        while (childIt.hasNext()) {
            Object child = childIt.next();
            if (child instanceof SOAPElement) {
                XmlUtil.copyChildElement(target, (SOAPElement)child);
                continue;
            }
            if (child instanceof javax.xml.soap.Text) {
                javax.xml.soap.Text childText = (javax.xml.soap.Text)child;
                String value = childText.getValue();
                target.appendChild(target.getOwnerDocument().createTextNode(value));
                if (!traceEnabled) continue;
                log.trace((Object)("appended text: " + value));
                continue;
            }
            log.debug((Object)("discarding child: " + child));
        }
    }

    private static void copyChildElement(Element parent, SOAPElement source) {
        String namespaceURI = source.getNamespaceURI();
        String name = source.getNodeName();
        Element target = parent.getOwnerDocument().createElementNS(namespaceURI, name);
        parent.appendChild(target);
        if (traceEnabled) {
            log.trace((Object)("appended element: {" + namespaceURI + '}' + name));
        }
        XmlUtil.copyNamespaces(target, source);
        XmlUtil.copyAttributes(target, source);
        XmlUtil.copyChildNodes(target, source);
    }

    public static void copy(SOAPElement target, Element source) throws SOAPException {
        if (traceEnabled) {
            log.trace((Object)("copying from: " + XmlUtil.toTraceString(source)));
        }
        XmlUtil.removeAttributes(target);
        XmlUtil.copyAttributes(target, source);
        XmlUtil.removeNamespaces(target);
        XmlUtil.copyVisibleNamespaces(target, source);
        target.removeContents();
        XmlUtil.copyChildNodes(target, source);
        if (traceEnabled) {
            log.trace((Object)("copied to: " + XmlUtil.toTraceString((Element)target)));
        }
    }

    public static void copyVisibleNamespaces(SOAPElement target, Element source) throws SOAPException {
        XmlUtil.copyNamespaces(target, source);
        org.w3c.dom.Node parent = source.getParentNode();
        while (parent instanceof Element) {
            XmlUtil.copyNamespaces(target, (Element)parent);
            parent = parent.getParentNode();
        }
    }

    public static void copyNamespaces(SOAPElement target, Element source) throws SOAPException {
        if (!source.hasAttributes()) {
            return;
        }
        NamedNodeMap attributes = source.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node attribute = attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) continue;
            String namespaceURI = attribute.getNodeValue();
            String prefix = attribute.getLocalName();
            if (!"xmlns".equals(prefix)) {
                if (namespaceURI.equals(target.getNamespaceURI(prefix))) continue;
                target.addNamespaceDeclaration(prefix, namespaceURI);
                if (!traceEnabled) continue;
                log.trace((Object)("added namespace declaration: " + prefix + "->" + namespaceURI));
                continue;
            }
            if (namespaceURI.length() <= 0) continue;
            prefix = XmlUtil.generatePrefix(source, DEFAULT_NAMESPACE_PREFIX);
            target.addNamespaceDeclaration(prefix, namespaceURI);
            if (!traceEnabled) continue;
            log.trace((Object)("reassigned default namespace declaration: " + prefix + "->" + namespaceURI));
        }
    }

    public static void copyAttributes(SOAPElement target, Element source) {
        if (!source.hasAttributes()) {
            return;
        }
        NamedNodeMap attributes = source.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node attribute = attributes.item(i);
            String namespaceURI = attribute.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) continue;
            String name = attribute.getNodeName();
            String value = attribute.getNodeValue();
            if (namespaceURI == null) {
                target.setAttribute(name, value);
            } else {
                target.setAttributeNS(namespaceURI, name, value);
            }
            if (!traceEnabled) continue;
            log.trace((Object)("set attribute: " + name));
        }
    }

    public static void copyChildNodes(SOAPElement target, Element source) throws SOAPException {
        if (!source.hasChildNodes()) {
            return;
        }
        block4: for (org.w3c.dom.Node child = source.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    XmlUtil.copyChildElement(target, (Element)child);
                    continue block4;
                }
                case 3: 
                case 4: {
                    String text = child.getNodeValue();
                    if (StringUtils.isWhitespace((String)text)) continue block4;
                    target.addTextNode(text);
                    if (!traceEnabled) continue block4;
                    log.trace((Object)("appended text: " + text));
                    continue block4;
                }
                default: {
                    log.debug((Object)("discarding child: " + child));
                }
            }
        }
    }

    public static void copyChildElement(SOAPElement parent, Element source) throws SOAPException {
        SOAPElement target;
        String localName = source.getLocalName();
        String prefix = source.getPrefix();
        String namespaceURI = source.getNamespaceURI();
        if (prefix == null) {
            if (StringUtils.isEmpty((String)namespaceURI)) {
                target = XmlUtil.addChildElement(parent, localName);
                if (traceEnabled) {
                    log.trace((Object)("appended element: " + localName));
                }
            } else {
                prefix = XmlUtil.getPrefix(namespaceURI, parent);
                if (prefix == null) {
                    prefix = XmlUtil.generatePrefix(source, DEFAULT_NAMESPACE_PREFIX);
                } else if (!namespaceURI.equals(source.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix))) {
                    prefix = XmlUtil.generatePrefix(source, prefix);
                }
                target = parent.addChildElement(localName, prefix, namespaceURI);
                if (traceEnabled) {
                    log.trace((Object)("added child element: {" + namespaceURI + '}' + prefix + ':' + localName));
                }
            }
        } else {
            target = parent.addChildElement(localName, prefix, namespaceURI);
            if (traceEnabled) {
                log.trace((Object)("added child element: {" + namespaceURI + '}' + prefix + ':' + localName));
            }
        }
        XmlUtil.copyNamespaces(target, source);
        XmlUtil.copyAttributes(target, source);
        XmlUtil.copyChildNodes(target, source);
    }

    public static SOAPElement addChildElement(SOAPElement parent, String localName) throws SOAPException {
        return parent.addChildElement(localName, "", "");
    }

    public static org.w3c.dom.Node appendForeignChild(org.w3c.dom.Node node, org.w3c.dom.Node foreignChild) {
        return node.appendChild(node.getOwnerDocument().importNode(foreignChild, true));
    }

    public static void addNamespaceDeclaration(Element elem, String namespaceURI) {
        elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
    }

    public static void addNamespaceDeclaration(Element elem, String namespaceURI, String prefix) {
        elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
    }

    public static void removeAttributes(Element elem) {
        if (elem.hasAttributes()) {
            int i;
            NamedNodeMap attributeMap = elem.getAttributes();
            int n = attributeMap.getLength();
            Attr[] attributes = new Attr[n];
            for (i = 0; i < n; ++i) {
                attributes[i] = (Attr)attributeMap.item(i);
            }
            for (i = 0; i < n; ++i) {
                elem.removeAttributeNode(attributes[i]);
            }
        }
    }

    public static void removeChildNodes(org.w3c.dom.Node node) {
        org.w3c.dom.Node current = node.getFirstChild();
        while (current != null) {
            org.w3c.dom.Node next = current.getNextSibling();
            node.removeChild(current);
            current = next;
        }
    }

    public static void removeAttributes(SOAPElement elem) {
        if (elem.hasAttributes()) {
            Iterator attrNameIt = elem.getAllAttributes();
            while (attrNameIt.hasNext()) {
                Name attrName = (Name)attrNameIt.next();
                elem.removeAttribute(attrName);
            }
        }
    }

    public static void removeNamespaces(SOAPElement elem) {
        Iterator prefixIt = elem.getNamespacePrefixes();
        while (prefixIt.hasNext()) {
            String prefix = (String)prefixIt.next();
            elem.removeNamespaceDeclaration(prefix);
        }
    }

    public static Document createDocument() {
        return XmlUtil.getDocumentBuilder().newDocument();
    }

    public static Element createElement(QName name) {
        String namespace = name.getNamespaceURI();
        if (namespace.length() == 0) {
            return XmlUtil.createElement(name.getLocalPart());
        }
        String prefix = name.getPrefix();
        return XmlUtil.createElement(name.getNamespaceURI(), prefix.length() != 0 ? prefix + ':' + name.getLocalPart() : name.getLocalPart());
    }

    public static Element createElement(String namespaceURI, String prefixedName) {
        Document doc = XmlUtil.createDocument();
        Element elem = doc.createElementNS(namespaceURI, prefixedName);
        doc.appendChild(elem);
        String prefix = elem.getPrefix();
        if (prefix != null) {
            XmlUtil.addNamespaceDeclaration(elem, namespaceURI, prefix);
        } else {
            XmlUtil.addNamespaceDeclaration(elem, namespaceURI);
        }
        return elem;
    }

    public static Element createElement(String localName) {
        Document doc = XmlUtil.createDocument();
        Element elem = doc.createElementNS(null, localName);
        doc.appendChild(elem);
        return elem;
    }

    public static Element parseText(String text) throws SAXException {
        try {
            return XmlUtil.getDocumentBuilder().parse(new InputSource(new StringReader(text))).getDocumentElement();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element parseResource(String resource) throws SAXException, IOException {
        InputStream resourceStream = ClassLoaderUtil.getStream((String)resource);
        if (resourceStream == null) {
            throw new FileNotFoundException(resource);
        }
        try {
            Element element = XmlUtil.getDocumentBuilder().parse(resourceStream, resource).getDocumentElement();
            return element;
        }
        finally {
            resourceStream.close();
        }
    }

    public static DocumentBuilder getDocumentBuilder() {
        return (DocumentBuilder)documentBuilderLocal.get();
    }

    public static Map getNamespaces(Element elem) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        try {
            Navigator nav = DocumentNavigator.getInstance();
            Iterator namespaceAxis = nav.getNamespaceAxisIterator((Object)elem);
            while (namespaceAxis.hasNext()) {
                Object namespace = namespaceAxis.next();
                String prefix = nav.getNamespacePrefix(namespace);
                if (StringUtils.isEmpty((String)prefix) || namespaces.containsKey(prefix)) continue;
                String uri = nav.getNamespaceStringValue(namespace);
                namespaces.put(prefix, uri);
            }
        }
        catch (UnsupportedAxisException e) {
            throw new AssertionError((Object)e);
        }
        return namespaces;
    }

    public static String getPrefix(String namespaceURI, org.w3c.dom.Node contextNode) {
        switch (contextNode.getNodeType()) {
            case 2: {
                contextNode = ((Attr)contextNode).getOwnerElement();
                break;
            }
            case 1: {
                break;
            }
            default: {
                contextNode = contextNode.getParentNode();
            }
        }
        while (contextNode != null && contextNode.getNodeType() == 1) {
            NamedNodeMap attributes = contextNode.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                org.w3c.dom.Node attr = attributes.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !namespaceURI.equals(attr.getNodeValue())) continue;
                String prefix = attr.getLocalName();
                return "xmlns".equals(prefix) ? "" : prefix;
            }
            contextNode = contextNode.getParentNode();
        }
        return null;
    }

    public static String getPrefix(String namespaceURI, SOAPElement contextElem) {
        Iterator prefixIt = contextElem.getVisibleNamespacePrefixes();
        while (prefixIt.hasNext()) {
            String prefix = (String)prefixIt.next();
            if (!namespaceURI.equals(contextElem.getNamespaceURI(prefix))) continue;
            return prefix;
        }
        return null;
    }

    public static String getNamespaceURI(String prefix, org.w3c.dom.Node contextNode) {
        return DOMUtils.getNamespaceURIFromPrefix((org.w3c.dom.Node)contextNode, (String)prefix);
    }

    private static String generatePrefix(Element contextElem, String baseText) {
        String prefix;
        if (!contextElem.hasAttributeNS("http://www.w3.org/2000/xmlns/", baseText)) {
            return baseText;
        }
        StringBuffer prefixBuffer = new StringBuffer(baseText);
        int baseLength = baseText.length();
        int i = 1;
        while (contextElem.hasAttributeNS("http://www.w3.org/2000/xmlns/", prefix = prefixBuffer.append(i).toString())) {
            prefixBuffer.setLength(baseLength);
            ++i;
        }
        return prefix;
    }

    public static Object evaluateXPath(String text, org.w3c.dom.Node context, Map namespaces) {
        try {
            Object result;
            DOMXPath xpath = new DOMXPath(text);
            if (namespaces != null) {
                xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
            }
            if ((result = xpath.evaluate((Object)context)) instanceof List) {
                List nodeset = (List)result;
                switch (nodeset.size()) {
                    case 0: {
                        result = null;
                        break;
                    }
                    case 1: {
                        result = nodeset.get(0);
                    }
                }
            }
            return result;
        }
        catch (JaxenException e) {
            throw new RuntimeException("could not evaluate XPath", e);
        }
    }

    public static TransformerFactory getTransformerFactory() {
        return (TransformerFactory)transformerFactoryLocal.get();
    }

    public static Templates createTemplates(URL templateURL) {
        Templates templates = null;
        try {
            InputStream templateStream = templateURL.openStream();
            templates = XmlUtil.getTransformerFactory().newTemplates(new StreamSource(templateStream));
            templateStream.close();
        }
        catch (Exception e) {
            log.error((Object)("unable to read templates: " + templateURL), (Throwable)e);
        }
        return templates;
    }

    private static class QualifiedNameElementPredicate
    implements Predicate {
        private final String namespaceURI;
        private final String localName;

        QualifiedNameElementPredicate(String namespaceURI, String localName) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
        }

        public boolean evaluate(Object arg) {
            return QualifiedNameElementPredicate.evaluate((org.w3c.dom.Node)arg, this.namespaceURI, this.localName);
        }

        static boolean evaluate(org.w3c.dom.Node node, String namespaceURI, String localName) {
            return node.getNodeType() == 1 && XmlUtil.nodeNamespaceURIEquals(node, namespaceURI) && localName.equals(node.getLocalName());
        }
    }

    private static class NamespaceElementPredicate
    implements Predicate {
        private final String namespaceURI;

        NamespaceElementPredicate(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        public boolean evaluate(Object arg) {
            return NamespaceElementPredicate.evaluate((org.w3c.dom.Node)arg, this.namespaceURI);
        }

        static boolean evaluate(org.w3c.dom.Node node, String namespaceURI) {
            return node.getNodeType() == 1 && XmlUtil.nodeNamespaceURIEquals(node, namespaceURI);
        }
    }
}

