/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.lang.reflect.AnnotatedElement;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.ws.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.core.client.ServiceRefObjectFactory;
import org.jboss.ws.core.jaxrpc.client.ServiceRefHandlerJAXRPC;
import org.jboss.ws.core.jaxws.client.ServiceRefHandlerJAXWS;
import org.jboss.ws.integration.ServiceRefElement;
import org.jboss.ws.integration.ServiceRefHandler;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class ServiceRefHandlerImpl
implements ServiceRefHandler {
    private static Logger log = Logger.getLogger(ServiceRefHandlerImpl.class);
    private ServiceRefObjectFactory objectFactory = new ServiceRefObjectFactory();

    public ServiceRefMetaData newServiceRefMetaData() {
        return new UnifiedServiceRefMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindServiceRef(Context encCtx, String encName, UnifiedVirtualFile vfsRoot, ClassLoader loader, ServiceRefMetaData sref) throws NamingException {
        if (sref.isProcessed()) {
            log.debug((Object)("Attempt to rebind the service-ref: " + sref.getServiceRefName()));
            return;
        }
        UnifiedServiceRefMetaData serviceRef = (UnifiedServiceRefMetaData)sref;
        serviceRef.setVfsRoot(vfsRoot);
        try {
            if (this.getServiceRefType(serviceRef, loader) == EndpointMetaData.Type.JAXRPC) {
                ServiceRefHandlerJAXRPC handler = new ServiceRefHandlerJAXRPC();
                handler.setupServiceRef(encCtx, encName, serviceRef);
            } else {
                AnnotatedElement anElement = (AnnotatedElement)sref.getAnnotatedElement();
                ServiceRefHandlerJAXWS handler = new ServiceRefHandlerJAXWS();
                handler.setupServiceRef(encCtx, encName, anElement, serviceRef);
            }
        }
        finally {
            sref.setProcessed(true);
        }
    }

    public Object newChild(ServiceRefElement ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.objectFactory.newChild(ref, navigator, namespaceURI, localName, attrs);
    }

    public void setValue(ServiceRefElement ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        this.objectFactory.setValue(ref, navigator, namespaceURI, localName, value);
    }

    private EndpointMetaData.Type getServiceRefType(UnifiedServiceRefMetaData serviceRef, ClassLoader loader) throws NamingException {
        String serviceRefType = serviceRef.getServiceRefType();
        if (serviceRefType != null || serviceRef.getAnnotatedElement() != null) {
            return EndpointMetaData.Type.JAXWS;
        }
        if (serviceRef.getMappingFile() != null) {
            return EndpointMetaData.Type.JAXRPC;
        }
        String siName = serviceRef.getServiceInterface();
        if (siName == null) {
            throw new IllegalStateException("<service-interface> cannot be null");
        }
        if (siName.equals("javax.xml.rpc.Service")) {
            return EndpointMetaData.Type.JAXRPC;
        }
        try {
            Class<?> siClass = loader.loadClass(siName);
            if (Service.class.isAssignableFrom(siClass)) {
                return EndpointMetaData.Type.JAXWS;
            }
            if (javax.xml.rpc.Service.class.isAssignableFrom(siClass)) {
                return EndpointMetaData.Type.JAXRPC;
            }
            throw new IllegalStateException("Illegal service interface: " + siName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load <service-interface>: " + siName);
        }
    }
}

